/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template.impl.activities.androidTVActivity.src.app_package;

import com.android.tools.idea.wizard.template.TemplateHelpersKt;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"cardPresenterJava", "", "packageName", "useAndroidX", "", "intellij.android.wizardTemplate.impl"})
public final class CardPresenterJavaKt {
    @NotNull
    public static final String cardPresenterJava(@NotNull String packageName, boolean useAndroidX) {
        return "\npackage " + packageName + ";\n\nimport android.graphics.drawable.Drawable;\nimport " + TemplateHelpersKt.getMaterialComponentName("android.support.v17.leanback.widget.ImageCardView", useAndroidX) + ";\nimport " + TemplateHelpersKt.getMaterialComponentName("android.support.v17.leanback.widget.Presenter", useAndroidX) + ";\nimport " + TemplateHelpersKt.getMaterialComponentName("android.support.v4.content.ContextCompat", useAndroidX) + ";\nimport android.util.Log;\nimport android.view.ViewGroup;\n\nimport com.bumptech.glide.Glide;\n\n/*\n * A CardPresenter is used to generate Views and bind Objects to them on demand.\n * It contains an Image CardView\n */\npublic class CardPresenter extends Presenter {\n    private static final String TAG = \"CardPresenter\";\n\n    private static final int CARD_WIDTH = 313;\n    private static final int CARD_HEIGHT = 176;\n    private static int sSelectedBackgroundColor;\n    private static int sDefaultBackgroundColor;\n    private Drawable mDefaultCardImage;\n\n    @Override\n    public ViewHolder onCreateViewHolder(ViewGroup parent) {\n        Log.d(TAG, \"onCreateViewHolder\");\n\n        sDefaultBackgroundColor =\n                ContextCompat.getColor(parent.getContext(), R.color.default_background);\n        sSelectedBackgroundColor =\n                ContextCompat.getColor(parent.getContext(), R.color.selected_background);\n        /*\n         * This template uses a default image in res/drawable, but the general case for Android TV\n         * will require your resources in xhdpi. For more information, see\n         * https://developer.android.com/training/tv/start/layouts.html#density-resources\n         */\n        mDefaultCardImage = ContextCompat.getDrawable(parent.getContext(), R.drawable.movie);\n\n        ImageCardView cardView =\n                new ImageCardView(parent.getContext()) {\n                    @Override\n                    public void setSelected(boolean selected) {\n                        updateCardBackgroundColor(this, selected);\n                        super.setSelected(selected);\n                    }\n                };\n\n        cardView.setFocusable(true);\n        cardView.setFocusableInTouchMode(true);\n        updateCardBackgroundColor(cardView, false);\n        return new ViewHolder(cardView);\n    }\n\n    private static void updateCardBackgroundColor(ImageCardView view, boolean selected) {\n        int color = selected ? sSelectedBackgroundColor : sDefaultBackgroundColor;\n        // Both background colors should be set because the view\"s background is temporarily visible\n        // during animations.\n        view.setBackgroundColor(color);\n        view.findViewById(R.id.info_field).setBackgroundColor(color);\n    }\n\n    @Override\n    public void onBindViewHolder(Presenter.ViewHolder viewHolder, Object item) {\n        Movie movie = (Movie) item;\n        ImageCardView cardView = (ImageCardView) viewHolder.view;\n\n        Log.d(TAG, \"onBindViewHolder\");\n        if (movie.getCardImageUrl() != null) {\n            cardView.setTitleText(movie.getTitle());\n            cardView.setContentText(movie.getStudio());\n            cardView.setMainImageDimensions(CARD_WIDTH, CARD_HEIGHT);\n            Glide.with(viewHolder.view.getContext())\n                    .load(movie.getCardImageUrl())\n                    .centerCrop()\n                    .error(mDefaultCardImage)\n                    .into(cardView.getMainImageView());\n        }\n    }\n\n    @Override\n    public void onUnbindViewHolder(Presenter.ViewHolder viewHolder) {\n        Log.d(TAG, \"onUnbindViewHolder\");\n        ImageCardView cardView = (ImageCardView) viewHolder.view;\n        // Remove references to images so that the garbage collector can free up memory\n        cardView.setBadgeImage(null);\n        cardView.setMainImage(null);\n    }\n}\n";
    }
}

