/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.ImmutableCDATA;
import org.jdom.ImmutableElement;
import org.jdom.ImmutableSameTypeAttributeList;
import org.jdom.ImmutableText;
import org.jdom.Text;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class JDOMInterner {
    @ApiStatus.Internal
    public static final JDOMInterner INSTANCE = new JDOMInterner();
    private final ObjectOpenHashSet<String> myStrings = new ObjectOpenHashSet();
    private final ObjectOpenCustomHashSet<Element> myElements = new ObjectOpenCustomHashSet((Hash.Strategy)new Hash.Strategy<Element>(){

        public int hashCode(Element e) {
            int result = e.getName().hashCode() * 31;
            result += JDOMInterner.computeAttributesHashCode(e);
            List content = e.getContent();
            result = result * 31 + content.size();
            for (Content child : content) {
                if (child instanceof Text) {
                    result = result * 31 + JDOMInterner.computeTextHashCode((Text)child);
                    continue;
                }
                if (!(child instanceof Element)) continue;
                result = result * 31 + this.hashCode((Element)child);
                break;
            }
            return result;
        }

        public boolean equals(Element o1, Element o2) {
            if (o1 == o2) {
                return true;
            }
            if (o1 == null || o2 == null || !Comparing.strEqual(o1.getName(), o2.getName()) || !JDOMInterner.attributesEqual(o1, o2)) {
                return false;
            }
            List content1 = o1.getContent();
            List content2 = o2.getContent();
            if (content1.size() != content2.size()) {
                return false;
            }
            for (int i = 0; i < content1.size(); ++i) {
                Content c1 = (Content)content1.get(i);
                Content c2 = (Content)content2.get(i);
                if (c1 instanceof Text) {
                    if (c2 instanceof Text && Comparing.strEqual(c1.getValue(), c2.getValue())) continue;
                    return false;
                }
                if (c1 instanceof Element) {
                    if (c2 instanceof Element && this.equals((Element)c1, (Element)c2)) continue;
                    return false;
                }
                throw new RuntimeException(c1.toString());
            }
            return true;
        }
    });
    private final ObjectOpenCustomHashSet<Text> myTexts = new ObjectOpenCustomHashSet((Hash.Strategy)new Hash.Strategy<Text>(){

        public int hashCode(Text object) {
            return JDOMInterner.computeTextHashCode(object);
        }

        public boolean equals(Text o1, Text o2) {
            return o1 == o2 || o1 != null && o2 != null && Comparing.strEqual(o1.getValue(), o2.getValue());
        }
    });

    private static int computeAttributesHashCode(Element e) {
        List<Attribute> attributes = JDOMUtil.getAttributes(e);
        if (attributes instanceof ImmutableSameTypeAttributeList) {
            return attributes.hashCode();
        }
        int result = 1;
        for (Attribute attribute : attributes) {
            result = result * 31 + JDOMInterner.computeAttributeHashCode(attribute.getName(), attribute.getValue());
        }
        return result;
    }

    private static boolean attributesEqual(Element o1, Element o2) {
        if (o1 instanceof ImmutableElement) {
            return ((ImmutableElement)o1).attributesEqual(o2);
        }
        if (o2 instanceof ImmutableElement) {
            return ((ImmutableElement)o2).attributesEqual(o1);
        }
        List<Attribute> a1 = JDOMUtil.getAttributes(o1);
        List<Attribute> a2 = JDOMUtil.getAttributes(o2);
        if (a1.size() != a2.size()) {
            return false;
        }
        for (int i = 0; i < a1.size(); ++i) {
            Attribute attr2;
            Attribute attr1 = a1.get(i);
            if (ImmutableElement.attributesEqual(attr1, attr2 = a2.get(i))) continue;
            return false;
        }
        return true;
    }

    static int computeAttributeHashCode(String name, String value) {
        return name.hashCode() * 31 + (value == null ? 0 : value.hashCode());
    }

    private static int computeTextHashCode(Text object) {
        return object.getValue().hashCode();
    }

    @NotNull
    public synchronized Element internElement(@NotNull Element element) {
        if (element instanceof ImmutableElement) {
            return element;
        }
        for (Content content : element.getContent()) {
            if (!(content instanceof Element)) continue;
            return new ImmutableElement(element, this);
        }
        Element interned = (Element)this.myElements.get((Object)element);
        if (interned == null) {
            interned = new ImmutableElement(element, this);
            this.myElements.add((Object)interned);
        }
        return interned;
    }

    public static boolean isInterned(@NotNull Element element) {
        return element instanceof ImmutableElement;
    }

    @NotNull
    synchronized Text internText(@NotNull Text text) {
        if (text instanceof ImmutableText || text instanceof ImmutableCDATA) {
            return text;
        }
        Object interned = (Text)this.myTexts.get((Object)text);
        if (interned == null) {
            interned = text instanceof CDATA ? new ImmutableCDATA(text.getText()) : new ImmutableText((String)this.myStrings.addOrGet((Object)text.getText()));
            this.myTexts.add(interned);
        }
        return interned;
    }

    synchronized String internString(String s) {
        return (String)this.myStrings.addOrGet((Object)s);
    }
}

