/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.xmlb.MultiNodeBinding;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.Serializer;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Binding {
    public static final Logger LOG = Logger.getInstance(Binding.class);

    @Nullable
    public Object serialize(@NotNull Object var1, @Nullable Object var2, @Nullable SerializationFilter var3);

    default public boolean isBoundTo(@NotNull Element element) {
        return false;
    }

    default public void init(@NotNull Type originalType, @NotNull Serializer serializer) {
    }

    @Nullable
    public static Object deserializeList(@NotNull Binding binding, @Nullable Object context, @NotNull List<? extends Element> nodes) {
        if (binding instanceof MultiNodeBinding) {
            return ((MultiNodeBinding)binding).deserializeList(context, nodes);
        }
        if (nodes.size() == 1) {
            return binding.deserializeUnsafe(context, nodes.get(0));
        }
        if (nodes.isEmpty()) {
            return null;
        }
        throw new AssertionError((Object)("Duplicate data for " + binding + " will be ignored"));
    }

    public Object deserializeUnsafe(Object var1, @NotNull Element var2);

    public static void addContent(@NotNull Element targetElement, Object node) {
        if (node instanceof Content) {
            Content content = (Content)node;
            targetElement.addContent(content);
        } else if (node instanceof List) {
            targetElement.addContent((Collection)((List)node));
        } else {
            throw new IllegalArgumentException("Wrong node: " + node);
        }
    }
}

