/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.serialization.MutableAccessor;
import com.intellij.util.xmlb.BeanBinding;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.MapBinding;
import com.intellij.util.xmlb.MultiNodeBinding;
import com.intellij.util.xmlb.NestedBinding;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.annotations.Property;
import java.awt.Rectangle;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class AccessorBindingWrapper
implements MultiNodeBinding,
NestedBinding {
    private final Binding myBinding;
    private final MutableAccessor myAccessor;
    private final boolean myFlat;
    private final Property.Style beanStyle;

    AccessorBindingWrapper(@NotNull MutableAccessor accessor, @NotNull Binding binding, boolean flat, Property.Style beanStyle) {
        this.myAccessor = accessor;
        this.myBinding = binding;
        this.myFlat = flat;
        this.beanStyle = beanStyle;
    }

    @Override
    @NotNull
    public MutableAccessor getAccessor() {
        return this.myAccessor;
    }

    public boolean isFlat() {
        return this.myFlat;
    }

    @Override
    @Nullable
    public Object serialize(@NotNull Object o, @Nullable Object context, @Nullable SerializationFilter filter) {
        Object value = this.myAccessor.read(o);
        if (value == null) {
            return null;
        }
        if (this.myFlat) {
            Element element = (Element)context;
            if (this.beanStyle == Property.Style.ATTRIBUTE && value instanceof Rectangle) {
                Rectangle bounds = (Rectangle)value;
                LOG.assertTrue(element != null);
                element.setAttribute("x", Integer.toString(bounds.x));
                element.setAttribute("y", Integer.toString(bounds.y));
                element.setAttribute("width", Integer.toString(bounds.width));
                element.setAttribute("height", Integer.toString(bounds.height));
            } else {
                ((BeanBinding)this.myBinding).serializeInto(value, element, filter);
            }
            return null;
        }
        return this.myBinding.serialize(value, context, filter);
    }

    @Override
    public Object deserializeUnsafe(Object context, @NotNull Element element) {
        return this.deserialize(context, element);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public Object deserialize(@NotNull Object context, @NotNull Element element) {
        Object currentValue = this.myAccessor.read(context);
        if (this.myBinding instanceof BeanBinding && !this.myAccessor.isWritable()) {
            ((BeanBinding)this.myBinding).deserializeInto(currentValue, element);
            return context;
        } else {
            Object deserializedValue;
            if (this.beanStyle == Property.Style.ATTRIBUTE && this.myBinding instanceof BeanBinding && ((BeanBinding)this.myBinding).myBeanClass == Rectangle.class) {
                String xA = element.getAttributeValue("x");
                String yA = element.getAttributeValue("y");
                String wA = element.getAttributeValue("width");
                String hA = element.getAttributeValue("height");
                if (xA == null || yA == null || wA == null || hA == null) return context;
                int x = StringUtilRt.parseInt(xA, 0);
                int y = StringUtilRt.parseInt(yA, 0);
                int h = StringUtilRt.parseInt(hA, 0);
                int w = StringUtilRt.parseInt(wA, 0);
                deserializedValue = new Rectangle(x, y, w, h);
            } else {
                deserializedValue = this.myBinding.deserializeUnsafe(currentValue, element);
            }
            if (currentValue == deserializedValue) return context;
            this.myAccessor.set(context, deserializedValue);
        }
        return context;
    }

    @Override
    @NotNull
    public Object deserializeList(@NotNull Object context, @NotNull List<? extends Element> elements) {
        Object currentValue = this.myAccessor.read(context);
        if (this.myBinding instanceof BeanBinding && !this.myAccessor.isWritable()) {
            ((BeanBinding)this.myBinding).deserializeInto(currentValue, elements.get(0));
        } else {
            Object deserializedValue = Binding.deserializeList(this.myBinding, currentValue, elements);
            if (currentValue != deserializedValue) {
                this.myAccessor.set(context, deserializedValue);
            }
        }
        return context;
    }

    @Override
    public boolean isMulti() {
        return this.myBinding instanceof MultiNodeBinding && ((MultiNodeBinding)this.myBinding).isMulti();
    }

    @Override
    public boolean isBoundTo(@NotNull Element element) {
        if (this.myBinding instanceof MapBinding) {
            return ((MapBinding)this.myBinding).isBoundToWithoutProperty(element);
        }
        return this.myBinding.isBoundTo(element);
    }

    public String toString() {
        return this.myBinding.toString();
    }
}

