/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.serialization.ClassUtil;
import com.intellij.serialization.MutableAccessor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.MultiNodeBinding;
import com.intellij.util.xmlb.NestedBinding;
import com.intellij.util.xmlb.NotNullDeserializeBinding;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.Serializer;
import com.intellij.util.xmlb.XmlSerializerImpl;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.XCollection;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractCollectionBinding
extends NotNullDeserializeBinding
implements MultiNodeBinding,
NestedBinding {
    private final MutableAccessor myAccessor;
    private List<Binding> itemBindings;
    protected final Class<?> itemType;
    @Nullable
    private final AbstractCollection annotation;
    @Nullable
    protected final XCollection newAnnotation;
    private Serializer serializer;

    AbstractCollectionBinding(@NotNull Class elementType, @Nullable MutableAccessor accessor) {
        this.myAccessor = accessor;
        this.itemType = elementType;
        XCollection xCollection = this.newAnnotation = accessor == null ? null : accessor.getAnnotation(XCollection.class);
        this.annotation = this.newAnnotation == null ? (accessor == null ? null : accessor.getAnnotation(AbstractCollection.class)) : null;
    }

    @Override
    @NotNull
    public MutableAccessor getAccessor() {
        return this.myAccessor;
    }

    protected boolean isSortOrderedSet() {
        return this.annotation == null || this.annotation.sortOrderedSet();
    }

    @Override
    public boolean isMulti() {
        return true;
    }

    @Override
    public void init(@NotNull Type originalType, @NotNull Serializer serializer) {
        this.serializer = serializer;
    }

    private boolean isSurroundWithTag() {
        return this.newAnnotation == null && (this.annotation == null || this.annotation.surroundWithTag());
    }

    @NotNull
    private @NotNull Class<?> @NotNull [] getElementTypes() {
        if (this.newAnnotation != null) {
            return this.newAnnotation.elementTypes();
        }
        return this.annotation == null ? ArrayUtil.EMPTY_CLASS_ARRAY : this.annotation.elementTypes();
    }

    @Nullable
    private Binding getItemBinding(@NotNull Class<?> aClass) {
        return ClassUtil.isPrimitive(aClass) ? null : this.serializer.getRootBinding(aClass, aClass);
    }

    @NotNull
    private synchronized List<Binding> getItemBindings() {
        if (this.itemBindings == null) {
            Binding binding = this.getItemBinding(this.itemType);
            Class<?>[] elementTypes = this.getElementTypes();
            if (elementTypes.length == 0) {
                this.itemBindings = binding == null ? Collections.emptyList() : Collections.singletonList(binding);
            } else {
                this.itemBindings = new SmartList<Binding>();
                if (binding != null) {
                    this.itemBindings.add(binding);
                }
                for (Class<?> aClass : elementTypes) {
                    Binding b = this.getItemBinding(aClass);
                    if (b == null || this.itemBindings.contains(b)) continue;
                    this.itemBindings.add(b);
                }
                if (this.itemBindings.isEmpty()) {
                    this.itemBindings = Collections.emptyList();
                }
            }
        }
        return this.itemBindings;
    }

    @Nullable
    private Binding getElementBinding(@NotNull Element element) {
        for (Binding binding : this.getItemBindings()) {
            if (!binding.isBoundTo(element)) continue;
            return binding;
        }
        return null;
    }

    @NotNull
    abstract Collection<?> getIterable(@NotNull Object var1);

    @Override
    @Nullable
    public Object serialize(@NotNull Object object, @Nullable Object context, @Nullable SerializationFilter filter) {
        String tagName;
        Collection<?> collection = this.getIterable(object);
        String string = tagName = this.isSurroundWithTag() ? this.getCollectionTagName(object) : null;
        if (tagName == null) {
            SmartList result = new SmartList();
            if (!collection.isEmpty()) {
                for (Object item : collection) {
                    ContainerUtil.addAllNotNull(result, this.serializeItem(item, result, filter));
                }
            }
            return result;
        }
        Element result = new Element(tagName);
        if (!collection.isEmpty()) {
            for (Object item : collection) {
                Content child = (Content)this.serializeItem(item, result, filter);
                if (child == null) continue;
                result.addContent(child);
            }
        }
        return result;
    }

    @Override
    @NotNull
    public Object deserialize(@Nullable Object context, @NotNull Element element) {
        if (!this.isSurroundWithTag()) {
            return this.doDeserializeList(context, Collections.singletonList(element));
        }
        return this.doDeserializeList(context, element.getChildren());
    }

    @Override
    @Nullable
    public Object deserializeList(@Nullable Object context, @NotNull List<? extends Element> elements) {
        if (!this.isSurroundWithTag()) {
            return this.doDeserializeList(context, elements);
        }
        assert (elements.size() == 1);
        Element element = elements.get(0);
        return this.doDeserializeList(context == null && element.getName().equals("set") ? new HashSet() : context, element.getChildren());
    }

    @NotNull
    protected abstract Object doDeserializeList(@Nullable Object var1, @NotNull List<? extends Element> var2);

    @Nullable
    private Object serializeItem(@Nullable Object value, Object context, @Nullable SerializationFilter filter) {
        if (value == null) {
            LOG.warn("Collection " + this.myAccessor + " contains 'null' object");
            return null;
        }
        Binding binding = this.getItemBinding(value.getClass());
        if (binding == null) {
            String elementName = this.getElementName();
            if (StringUtil.isEmpty(elementName)) {
                throw new Error("elementName must be not empty");
            }
            Element serializedItem = new Element(elementName);
            String attributeName = this.getValueAttributeName();
            String serialized = XmlSerializerImpl.convertToString(value);
            if (attributeName.isEmpty()) {
                if (!serialized.isEmpty()) {
                    serializedItem.addContent((Content)new Text(serialized));
                }
            } else {
                serializedItem.setAttribute(attributeName, JDOMUtil.removeControlChars(serialized));
            }
            return serializedItem;
        }
        return binding.serialize(value, context, filter);
    }

    protected final Object deserializeItem(@NotNull Element node, @Nullable Object context) {
        Binding binding = this.getElementBinding(node);
        if (binding == null) {
            String attributeName = this.getValueAttributeName();
            String value = attributeName.isEmpty() ? XmlSerializerImpl.getTextValue(node, "") : node.getAttributeValue(attributeName);
            return XmlSerializerImpl.convert(value, this.itemType);
        }
        return binding.deserializeUnsafe(context, node);
    }

    @NotNull
    private String getElementName() {
        if (this.newAnnotation != null) {
            return this.newAnnotation.elementName();
        }
        return this.annotation == null ? "option" : this.annotation.elementTag();
    }

    @NotNull
    private String getValueAttributeName() {
        if (this.newAnnotation != null) {
            return this.newAnnotation.valueAttributeName();
        }
        return this.annotation == null ? "value" : this.annotation.elementValueAttribute();
    }

    @Override
    public boolean isBoundTo(@NotNull Element element) {
        if (this.isSurroundWithTag()) {
            return element.getName().equals(this.getCollectionTagName(null));
        }
        if (this.getItemBindings().isEmpty()) {
            return element.getName().equals(this.getElementName());
        }
        return this.getElementBinding(element) != null;
    }

    @NotNull
    protected abstract String getCollectionTagName(@Nullable Object var1);
}

