/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.SystemInfoRt;
import java.lang.reflect.Constructor;
import org.jetbrains.annotations.NotNull;

public final class StringFactory {
    private static final Constructor<String> ourConstructor;

    @NotNull
    public static String createShared(char @NotNull [] chars) {
        if (ourConstructor != null) {
            try {
                return ourConstructor.newInstance(chars, Boolean.TRUE);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return new String(chars);
    }

    static {
        Constructor constructor = null;
        if (!SystemInfoRt.IS_AT_LEAST_JAVA9) {
            try {
                constructor = String.class.getDeclaredConstructor(char[].class, Boolean.TYPE);
                constructor.setAccessible(true);
            }
            catch (Throwable ignored) {
                constructor = null;
            }
        }
        ourConstructor = constructor;
    }
}

