/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class UnsyncByteArrayOutputStream
extends OutputStream {
    protected byte[] myBuffer;
    protected int myCount;
    private boolean myIsShared;

    public UnsyncByteArrayOutputStream() {
        this(32);
    }

    public UnsyncByteArrayOutputStream(int size) {
        this(new byte[size]);
    }

    public UnsyncByteArrayOutputStream(byte[] buffer) {
        this.myBuffer = buffer;
    }

    @Override
    public void write(int b) {
        int newCount = this.myCount + 1;
        if (newCount > this.myBuffer.length || this.myIsShared) {
            this.grow(newCount);
            this.myIsShared = false;
        }
        this.myBuffer[this.myCount] = (byte)b;
        this.myCount = newCount;
    }

    private void grow(int newCount) {
        this.myBuffer = Arrays.copyOf(this.myBuffer, newCount > this.myBuffer.length ? Math.max(this.myBuffer.length << 1, newCount) : this.myBuffer.length);
    }

    @Override
    public void write(byte @NotNull [] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int newCount = this.myCount + len;
        if (newCount > this.myBuffer.length || this.myIsShared) {
            this.grow(newCount);
            this.myIsShared = false;
        }
        System.arraycopy(b, off, this.myBuffer, this.myCount, len);
        this.myCount = newCount;
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.myBuffer, 0, this.myCount);
    }

    public void reset() {
        this.myCount = 0;
    }

    public byte[] toByteArray() {
        if (this.myBuffer.length == this.myCount) {
            this.myIsShared = true;
            return this.myBuffer;
        }
        return Arrays.copyOf(this.myBuffer, this.myCount);
    }

    public int size() {
        return this.myCount;
    }

    public String toString() {
        return new String(this.myBuffer, 0, this.myCount, StandardCharsets.UTF_8);
    }

    @NotNull
    public ByteArraySequence toByteArraySequence() {
        return new ByteArraySequence(this.myBuffer, 0, this.myCount);
    }

    @NotNull
    public InputStream toInputStream() {
        return new UnsyncByteArrayInputStream(this.myBuffer, 0, this.myCount);
    }
}

