/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexId;
import com.intellij.util.indexing.InvertedIndex;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.impl.AbstractUpdateData;
import com.intellij.util.indexing.impl.EmptyInputDataDiffBuilder;
import com.intellij.util.indexing.impl.IndexDebugProperties;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.InputData;
import com.intellij.util.indexing.impl.InputDataDiffBuilder;
import com.intellij.util.indexing.impl.KeyValueUpdateProcessor;
import com.intellij.util.indexing.impl.RemovedKeyProcessor;
import com.intellij.util.indexing.impl.UpdateData;
import com.intellij.util.indexing.impl.ValueContainerImpl;
import com.intellij.util.indexing.impl.forward.ForwardIndex;
import com.intellij.util.indexing.impl.forward.ForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.IntForwardIndex;
import com.intellij.util.indexing.impl.forward.IntForwardIndexAccessor;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MapReduceIndex<Key, Value, Input>
implements InvertedIndex<Key, Value, Input> {
    private static final Logger LOG = Logger.getInstance(MapReduceIndex.class);
    @NotNull
    protected final IndexId<Key, Value> myIndexId;
    @NotNull
    protected final IndexStorage<Key, Value> myStorage;
    protected final DataExternalizer<Value> myValueExternalizer;
    protected final IndexExtension<Key, Value, Input> myExtension;
    protected final AtomicLong myModificationStamp = new AtomicLong();
    protected final DataIndexer<Key, Value, Input> myIndexer;
    private final ForwardIndex myForwardIndex;
    private final ForwardIndexAccessor<Key, Value> myForwardIndexAccessor;
    @NotNull
    private final ReadWriteLock myLock;
    private final boolean myUseIntForwardIndex;
    private volatile boolean myDisposed;
    private final LowMemoryWatcher myLowMemoryFlusher = LowMemoryWatcher.register(new Runnable(){

        @Override
        public void run() {
            try {
                MapReduceIndex.this.myLock.readLock().lock();
                try {
                    MapReduceIndex.this.myStorage.clearCaches();
                }
                finally {
                    MapReduceIndex.this.myLock.readLock().unlock();
                }
                MapReduceIndex.this.flush();
            }
            catch (Throwable e) {
                MapReduceIndex.this.requestRebuild(e);
            }
        }
    });
    private final RemovedKeyProcessor<Key> myRemovedKeyProcessor = new RemovedKeyProcessor<Key>(){

        @Override
        public void process(Key key, int inputId) throws StorageException {
            MapReduceIndex.this.myModificationStamp.incrementAndGet();
            MapReduceIndex.this.myStorage.removeAllValues(key, inputId);
        }
    };
    private final KeyValueUpdateProcessor<Key, Value> myAddedKeyProcessor = new KeyValueUpdateProcessor<Key, Value>(){

        @Override
        public void process(Key key, Value value, int inputId) throws StorageException {
            MapReduceIndex.this.myModificationStamp.incrementAndGet();
            MapReduceIndex.this.myStorage.addValue(key, inputId, value);
        }
    };
    private final KeyValueUpdateProcessor<Key, Value> myUpdatedKeyProcessor = new KeyValueUpdateProcessor<Key, Value>(){

        @Override
        public void process(Key key, Value value, int inputId) throws StorageException {
            MapReduceIndex.this.myModificationStamp.incrementAndGet();
            MapReduceIndex.this.myStorage.removeAllValues(key, inputId);
            MapReduceIndex.this.myStorage.addValue(key, inputId, value);
        }
    };

    protected MapReduceIndex(@NotNull IndexExtension<Key, Value, Input> extension, @NotNull IndexStorage<Key, Value> storage, @Nullable ForwardIndex forwardIndex, @Nullable ForwardIndexAccessor<Key, Value> forwardIndexAccessor, @Nullable ReadWriteLock lock) {
        this.myIndexId = extension.getName();
        this.myExtension = extension;
        this.myIndexer = this.myExtension.getIndexer();
        this.myStorage = storage;
        this.myValueExternalizer = extension.getValueExternalizer();
        this.myForwardIndex = forwardIndex;
        this.myForwardIndexAccessor = forwardIndexAccessor;
        this.myUseIntForwardIndex = forwardIndex instanceof IntForwardIndex && forwardIndexAccessor instanceof IntForwardIndexAccessor;
        LOG.assertTrue(forwardIndex instanceof IntForwardIndex == forwardIndexAccessor instanceof IntForwardIndexAccessor, "Invalid index configuration");
        this.myLock = lock == null ? new ReentrantReadWriteLock() : lock;
    }

    protected MapReduceIndex(@NotNull IndexExtension<Key, Value, Input> extension, @NotNull IndexStorage<Key, Value> storage, @Nullable ForwardIndex forwardIndex, @Nullable ForwardIndexAccessor<Key, Value> forwardIndexAccessor) {
        this(extension, storage, forwardIndex, forwardIndexAccessor, null);
    }

    public ForwardIndex getForwardIndex() {
        return this.myForwardIndex;
    }

    public ForwardIndexAccessor<Key, Value> getForwardIndexAccessor() {
        return this.myForwardIndexAccessor;
    }

    @NotNull
    public IndexExtension<Key, Value, Input> getExtension() {
        return this.myExtension;
    }

    @NotNull
    public IndexStorage<Key, Value> getStorage() {
        return this.myStorage;
    }

    @NotNull
    public final ReadWriteLock getLock() {
        return this.myLock;
    }

    @Override
    public void clear() {
        this.myLock.writeLock().lock();
        try {
            this.myModificationStamp.incrementAndGet();
            this.doClear();
        }
        catch (StorageException | IOException e) {
            LOG.error(e);
        }
        finally {
            this.myLock.writeLock().unlock();
        }
    }

    protected void doClear() throws StorageException, IOException {
        this.myStorage.clear();
        if (this.myForwardIndex != null) {
            this.myForwardIndex.clear();
        }
    }

    @Override
    public void flush() throws StorageException {
        this.myLock.readLock().lock();
        try {
            this.doFlush();
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof StorageException || cause instanceof IOException) {
                throw new StorageException(cause);
            }
            throw e;
        }
        finally {
            this.myLock.readLock().unlock();
        }
    }

    protected void doFlush() throws IOException, StorageException {
        if (this.myForwardIndex != null) {
            this.myForwardIndex.force();
        }
        this.myStorage.flush();
    }

    @Override
    public void dispose() {
        this.myLowMemoryFlusher.stop();
        this.myLock.writeLock().lock();
        try {
            this.doDispose();
        }
        catch (StorageException e) {
            LOG.error(e);
        }
        finally {
            this.myDisposed = true;
            this.myLock.writeLock().unlock();
        }
    }

    protected void doDispose() throws StorageException {
        try {
            this.myStorage.close();
        }
        finally {
            try {
                if (this.myForwardIndex != null) {
                    this.myForwardIndex.close();
                }
            }
            catch (IOException e) {
                LOG.error(e);
            }
        }
    }

    @Override
    @NotNull
    public ValueContainer<Value> getData(@NotNull Key key) throws StorageException {
        this.myLock.readLock().lock();
        try {
            if (this.myDisposed) {
                ValueContainerImpl valueContainerImpl = new ValueContainerImpl();
                return valueContainerImpl;
            }
            IndexDebugProperties.DEBUG_INDEX_ID.set(this.myIndexId);
            ValueContainer<Value> valueContainer = this.myStorage.read(key);
            return valueContainer;
        }
        finally {
            IndexDebugProperties.DEBUG_INDEX_ID.set(null);
            this.myLock.readLock().unlock();
        }
    }

    @Override
    @NotNull
    public final Computable<Boolean> mapInputAndPrepareUpdate(int inputId, @Nullable Input content) throws MapInputException, ProcessCanceledException {
        InputData<Key, Value> data;
        try {
            data = this.mapInput(inputId, content);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MapInputException("Failed to map data for input " + inputId + " for index " + this.myIndexId.getName(), e);
        }
        UpdateData<Key, Value> updateData = new UpdateData<Key, Value>(inputId, data.getKeyValues(), () -> this.getKeysDiffBuilder(inputId), this.myIndexId, () -> this.updateForwardIndex(inputId, data));
        return () -> {
            try {
                this.updateWithMap(updateData);
            }
            catch (ProcessCanceledException | StorageException ex) {
                String message = "An exception during updateWithMap(). Index " + this.myIndexId.getName() + " will be rebuilt.";
                if (ex instanceof ProcessCanceledException) {
                    LOG.error(message, ex);
                } else {
                    LOG.info(message, ex);
                }
                this.requestRebuild(ex);
                return false;
            }
            return true;
        };
    }

    protected void updateForwardIndex(int inputId, @NotNull InputData<Key, Value> data) throws IOException {
        if (this.myForwardIndex != null) {
            if (this.myUseIntForwardIndex) {
                ((IntForwardIndex)this.myForwardIndex).putInt(inputId, ((IntForwardIndexAccessor)this.myForwardIndexAccessor).serializeIndexedDataToInt(data));
            } else {
                this.myForwardIndex.put(inputId, this.myForwardIndexAccessor.serializeIndexedData(data));
            }
        }
    }

    @NotNull
    protected InputDataDiffBuilder<Key, Value> getKeysDiffBuilder(int inputId) throws IOException {
        if (this.myForwardIndex != null) {
            if (this.myUseIntForwardIndex) {
                return ((IntForwardIndexAccessor)this.myForwardIndexAccessor).getDiffBuilderFromInt(inputId, ((IntForwardIndex)this.myForwardIndex).getInt(inputId));
            }
            return this.myForwardIndexAccessor.getDiffBuilder(inputId, this.myForwardIndex.get(inputId));
        }
        return new EmptyInputDataDiffBuilder(inputId);
    }

    @NotNull
    protected InputData<Key, Value> mapInput(int inputId, @Nullable Input content) {
        if (content == null) {
            return InputData.empty();
        }
        Map<Key, Value> data = this.mapByIndexer(inputId, content);
        MapReduceIndex.checkValuesHaveProperEqualsAndHashCode(data, this.myIndexId, this.myValueExternalizer);
        this.checkCanceled();
        return new InputData<Key, Value>(data);
    }

    @NotNull
    protected Map<Key, Value> mapByIndexer(int inputId, @NotNull Input content) {
        return this.myIndexer.map(content);
    }

    public abstract void checkCanceled();

    protected abstract void requestRebuild(@NotNull Throwable var1);

    public long getModificationStamp() {
        return this.myModificationStamp.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateWithMap(@NotNull AbstractUpdateData<Key, Value> updateData) throws StorageException {
        this.myLock.writeLock().lock();
        try {
            IndexId<?, ?> oldIndexId = IndexDebugProperties.DEBUG_INDEX_ID.get();
            try {
                IndexDebugProperties.DEBUG_INDEX_ID.set(this.myIndexId);
                boolean hasDifference = updateData.iterateKeys(this.myAddedKeyProcessor, this.myUpdatedKeyProcessor, this.myRemovedKeyProcessor);
                if (hasDifference) {
                    updateData.updateForwardIndex();
                }
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new StorageException(e);
            }
            finally {
                IndexDebugProperties.DEBUG_INDEX_ID.set(oldIndexId);
            }
        }
        finally {
            this.myLock.writeLock().unlock();
        }
    }

    public static <Key, Value> void checkValuesHaveProperEqualsAndHashCode(@NotNull Map<Key, Value> data, @NotNull IndexId<Key, Value> indexId, @NotNull DataExternalizer<Value> valueExternalizer) {
        if (IndexDebugProperties.DEBUG) {
            for (Map.Entry<Key, Value> e : data.entrySet()) {
                Value value = e.getValue();
                if (!Comparing.equal(value, value) || value != null && value.hashCode() != value.hashCode()) {
                    LOG.error("Index " + indexId + " violates equals / hashCode contract for Value parameter");
                }
                try {
                    BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream();
                    DataOutputStream outputStream = new DataOutputStream(out);
                    valueExternalizer.save(outputStream, value);
                    outputStream.close();
                    Value deserializedValue = valueExternalizer.read(new DataInputStream(out.toInputStream()));
                    if (Comparing.equal(value, deserializedValue) && (value == null || value.hashCode() == deserializedValue.hashCode())) continue;
                    LOG.error("Index " + indexId + " deserialization violates equals / hashCode contract for Value parameter");
                }
                catch (IOException ex) {
                    LOG.error(ex);
                }
            }
        }
    }

    public static final class MapInputException
    extends RuntimeException {
        public MapInputException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

