/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.openapi.util.Ref;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.impl.DirectInputDataDiffBuilder;
import com.intellij.util.indexing.impl.KeyValueUpdateProcessor;
import com.intellij.util.indexing.impl.RemovedKeyProcessor;
import gnu.trove.THashMap;
import gnu.trove.TObjectObjectProcedure;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class EmptyInputDataDiffBuilder<Key, Value>
extends DirectInputDataDiffBuilder<Key, Value> {
    public EmptyInputDataDiffBuilder(int inputId) {
        super(inputId);
    }

    @Override
    @NotNull
    public Collection<Key> getKeys() {
        return Collections.emptySet();
    }

    @Override
    public boolean differentiate(@NotNull Map<Key, Value> newData, @NotNull KeyValueUpdateProcessor<? super Key, ? super Value> addProcessor, @NotNull KeyValueUpdateProcessor<? super Key, ? super Value> updateProcessor, @NotNull RemovedKeyProcessor<? super Key> removeProcessor) throws StorageException {
        return EmptyInputDataDiffBuilder.processAllKeyValuesAsAdded(this.myInputId, newData, addProcessor);
    }

    public static <Key, Value> boolean processAllKeyValuesAsAdded(final int inputId, @NotNull Map<Key, Value> addedData, final @NotNull KeyValueUpdateProcessor<? super Key, ? super Value> addProcessor) throws StorageException {
        final Ref<Boolean> anyAdded = Ref.create(false);
        if (addedData instanceof THashMap) {
            final StorageException[] exception = new StorageException[]{null};
            ((THashMap)addedData).forEachEntry(new TObjectObjectProcedure<Key, Value>(){

                public boolean execute(Key k, Value v) {
                    try {
                        addProcessor.process(k, v, inputId);
                        anyAdded.set(true);
                    }
                    catch (StorageException e) {
                        exception[0] = e;
                        return false;
                    }
                    return true;
                }
            });
            if (exception[0] != null) {
                throw exception[0];
            }
        } else {
            for (Map.Entry<Key, Value> entry : addedData.entrySet()) {
                addProcessor.process(entry.getKey(), entry.getValue(), inputId);
                anyAdded.set(true);
            }
        }
        return anyAdded.get();
    }

    public static <Key, Value> boolean processAllKeyValuesAsRemoved(final int inputId, @NotNull Map<Key, Value> removedData, final @NotNull RemovedKeyProcessor<? super Key> removedProcessor) throws StorageException {
        final Ref<Boolean> anyRemoved = Ref.create(false);
        if (removedData instanceof THashMap) {
            final StorageException[] exception = new StorageException[]{null};
            ((THashMap)removedData).forEachEntry(new TObjectObjectProcedure<Key, Value>(){

                public boolean execute(Key k, Value v) {
                    try {
                        removedProcessor.process(k, inputId);
                        anyRemoved.set(true);
                    }
                    catch (StorageException e) {
                        exception[0] = e;
                        return false;
                    }
                    return true;
                }
            });
            if (exception[0] != null) {
                throw exception[0];
            }
        } else {
            for (Key key : removedData.keySet()) {
                removedProcessor.process(key, inputId);
                anyRemoved.set(true);
            }
        }
        return anyRemoved.get();
    }
}

