/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.graph;

import com.intellij.openapi.util.Couple;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.OutboundSemiGraph;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntStack;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DFSTBuilder<Node> {
    private final OutboundSemiGraph<Node> myGraph;
    private final Object2IntMap<Node> myNodeToNNumber;
    private final Node[] myInvN;
    private Couple<Node> myBackEdge;
    private Comparator<Node> myNComparator;
    private Comparator<Node> myTComparator;
    private final IntArrayList mySCCs = new IntArrayList();
    private final Object2IntMap<Node> myNodeToTNumber = new Object2IntOpenHashMap();
    private final Node[] myInvT;
    private final Node[] myAllNodes;

    public DFSTBuilder(@NotNull Graph<Node> graph) {
        this((Graph<Object>)graph, null);
    }

    public DFSTBuilder(@NotNull Graph<Node> graph, @Nullable Node entryNode) {
        this((OutboundSemiGraph<Node>)graph, entryNode);
    }

    public DFSTBuilder(@NotNull OutboundSemiGraph<Node> graph) {
        this(graph, null);
    }

    public DFSTBuilder(@NotNull OutboundSemiGraph<Node> graph, @Nullable Node entryNode) {
        int index;
        this.myAllNodes = graph.getNodes().toArray();
        if (entryNode != null && (index = ArrayUtil.indexOf(this.myAllNodes, entryNode)) != -1) {
            ArrayUtil.swap(this.myAllNodes, 0, index);
        }
        this.myGraph = graph;
        int size = graph.getNodes().size();
        this.myNodeToNNumber = new Object2IntOpenHashMap(size * 2, 0.5f);
        this.myInvN = new Object[size];
        this.myInvT = new Object[size];
        new Tarjan().build();
    }

    @NotNull
    public Comparator<Node> comparator() {
        return this.comparator(this.isAcyclic());
    }

    @NotNull
    public Comparator<Node> comparator(boolean useNNumber) {
        if (useNNumber) {
            if (this.myNComparator == null) {
                this.myNComparator = Comparator.comparingInt(arg_0 -> this.myNodeToNNumber.getInt(arg_0));
            }
            return this.myNComparator;
        }
        if (this.myTComparator == null) {
            this.myTComparator = Comparator.comparingInt(arg_0 -> this.myNodeToTNumber.getInt(arg_0));
        }
        return this.myTComparator;
    }

    @Nullable
    public Couple<Node> getCircularDependency() {
        return this.myBackEdge;
    }

    public boolean isAcyclic() {
        return this.getCircularDependency() == null;
    }

    @NotNull
    public Node getNodeByNNumber(int n) {
        return this.myInvN[n];
    }

    @NotNull
    public Node getNodeByTNumber(int n) {
        return this.myInvT[n];
    }

    @NotNull
    public IntList getSCCs() {
        return this.mySCCs;
    }

    @NotNull
    public Collection<Collection<Node>> getComponents() {
        final IntList componentSizes = this.getSCCs();
        if (componentSizes.isEmpty()) {
            return Collections.emptyList();
        }
        return new MyCollection<Collection<Node>>(componentSizes.size()){

            @Override
            @NotNull
            public Iterator<Collection<Node>> iterator() {
                return new MyIterator<Collection<Node>>(componentSizes.size()){
                    private int offset;

                    @Override
                    protected Collection<Node> get(int i) {
                        final int cSize = componentSizes.getInt(i);
                        final int cOffset = this.offset;
                        if (cSize == 0) {
                            return Collections.emptyList();
                        }
                        this.offset += cSize;
                        return new MyCollection<Node>(cSize){

                            @Override
                            @NotNull
                            public Iterator<Node> iterator() {
                                return new MyIterator<Node>(cSize){

                                    @Override
                                    public Node get(int i) {
                                        return DFSTBuilder.this.getNodeByTNumber(cOffset + i);
                                    }
                                };
                            }
                        };
                    }
                };
            }
        };
    }

    @NotNull
    public List<Node> getSortedNodes() {
        ArrayList<Node> result = new ArrayList<Node>(this.myGraph.getNodes());
        result.sort(this.comparator());
        return result;
    }

    private static abstract class MyIterator<T>
    implements Iterator<T> {
        private final int size;
        private int i;

        protected MyIterator(int size) {
            this.size = size;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.size;
        }

        @Override
        public T next() {
            if (this.i == this.size) {
                throw new NoSuchElementException();
            }
            return this.get(this.i++);
        }

        protected abstract T get(int var1);

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static abstract class MyCollection<T>
    extends AbstractCollection<T> {
        private final int size;

        protected MyCollection(int size) {
            this.size = size;
        }

        @Override
        public int size() {
            return this.size;
        }
    }

    private final class Tarjan {
        private final int[] lowLink;
        private final int[] index;
        private final IntStack nodesOnStack;
        private final boolean[] isOnStack;
        private final Stack<com.intellij.util.graph.DFSTBuilder$Tarjan.Frame> frames;
        private final Object2IntMap<Node> nodeIndex;
        private int dfsIndex;
        private int sccsSizeCombined;
        private final IntList topo;

        private Tarjan() {
            this.lowLink = new int[DFSTBuilder.this.myInvN.length];
            this.index = new int[DFSTBuilder.this.myInvN.length];
            this.nodesOnStack = new IntArrayList();
            this.isOnStack = new boolean[this.index.length];
            this.frames = new Stack();
            this.nodeIndex = new Object2IntOpenHashMap();
            this.topo = new IntArrayList(this.index.length);
        }

        private void build() {
            int i;
            Arrays.fill(this.index, -1);
            for (i = 0; i < DFSTBuilder.this.myAllNodes.length; ++i) {
                Object node = DFSTBuilder.this.myAllNodes[i];
                this.nodeIndex.put(node, i);
            }
            for (i = 0; i < this.index.length; ++i) {
                if (this.index[i] != -1) continue;
                this.frames.push((com.intellij.util.graph.DFSTBuilder$Tarjan.Frame)new Frame(i));
                ArrayList sccs = new ArrayList();
                this.strongConnect(sccs);
                for (List scc : sccs) {
                    int sccSize = scc.size();
                    DFSTBuilder.this.mySCCs.add(sccSize);
                    int sccBase = this.index.length - this.sccsSizeCombined - sccSize;
                    Object rootNode = DFSTBuilder.this.myAllNodes[i];
                    int rIndex = scc.indexOf(rootNode);
                    if (rIndex != -1) {
                        ContainerUtil.swapElements(scc, rIndex, 0);
                    }
                    for (int j = 0; j < scc.size(); ++j) {
                        Object sccNode = scc.get(j);
                        int tIndex = sccBase + j;
                        ((DFSTBuilder)DFSTBuilder.this).myInvT[tIndex] = sccNode;
                        DFSTBuilder.this.myNodeToTNumber.put(sccNode, tIndex);
                    }
                    this.sccsSizeCombined += sccSize;
                }
            }
            for (i = 0; i < this.topo.size(); ++i) {
                int nodeI = this.topo.getInt(i);
                Object node = DFSTBuilder.this.myAllNodes[nodeI];
                DFSTBuilder.this.myNodeToNNumber.put(node, this.index.length - 1 - i);
                ((DFSTBuilder)DFSTBuilder.this).myInvN[this.index.length - 1 - i] = node;
            }
            int[] ints = DFSTBuilder.this.mySCCs.elements();
            int i2 = 0;
            for (int j = DFSTBuilder.this.mySCCs.size() - 1; i2 < j; ++i2, --j) {
                int tmp = ints[i2];
                ints[i2] = ints[j];
                ints[j] = tmp;
            }
        }

        private void strongConnect(@NotNull List<? super List<Node>> sccs) {
            int successor = -1;
            block0: while (!this.frames.isEmpty()) {
                int pushedI;
                Frame pair = (Frame)this.frames.peek();
                int i = pair.nodeI;
                if (this.index[i] == -1) {
                    this.index[i] = this.dfsIndex;
                    this.lowLink[i] = this.dfsIndex++;
                    this.nodesOnStack.push(i);
                    this.isOnStack[i] = true;
                }
                if (ArrayUtil.indexOf(pair.out, successor) != -1) {
                    this.lowLink[i] = Math.min(this.lowLink[i], this.lowLink[successor]);
                }
                successor = i;
                while (pair.nextUnexploredIndex < pair.out.length) {
                    int nextI = pair.out[pair.nextUnexploredIndex++];
                    if (this.index[nextI] == -1) {
                        this.frames.push((com.intellij.util.graph.DFSTBuilder$Tarjan.Frame)new Frame(nextI));
                        continue block0;
                    }
                    if (!this.isOnStack[nextI]) continue;
                    this.lowLink[i] = Math.min(this.lowLink[i], this.index[nextI]);
                    if (DFSTBuilder.this.myBackEdge != null) continue;
                    DFSTBuilder.this.myBackEdge = new Couple<Object>(DFSTBuilder.this.myAllNodes[nextI], DFSTBuilder.this.myAllNodes[i]);
                }
                this.frames.pop();
                this.topo.add(i);
                if (this.lowLink[i] != this.index[i]) continue;
                ArrayList<Object> scc = new ArrayList<Object>();
                do {
                    pushedI = this.nodesOnStack.popInt();
                    Object pushed = DFSTBuilder.this.myAllNodes[pushedI];
                    this.isOnStack[pushedI] = false;
                    scc.add(pushed);
                } while (pushedI != i);
                sccs.add(scc);
            }
        }

        private final class Frame {
            private final int nodeI;
            private final int[] out;
            private int nextUnexploredIndex;

            Frame(int nodeI) {
                this.nodeI = nodeI;
                Iterator<Object> outNodes = DFSTBuilder.this.myGraph.getOut(DFSTBuilder.this.myAllNodes[nodeI]);
                IntArrayList list = new IntArrayList();
                while (outNodes.hasNext()) {
                    Object node = outNodes.next();
                    list.add(Tarjan.this.nodeIndex.getInt(node));
                }
                this.out = list.toIntArray();
            }

            public String toString() {
                StringBuilder o = new StringBuilder();
                o.append(DFSTBuilder.this.myAllNodes[this.nodeI]).append(" -> [");
                for (int id : this.out) {
                    o.append(DFSTBuilder.this.myAllNodes[id]).append(", ");
                }
                return o.append(']').toString();
            }
        }
    }
}

