/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UnmodifiableHashMap<K, V>
implements Map<K, V> {
    @NotNull
    private final TObjectHashingStrategy<K> strategy;
    private final Object @NotNull [] data;
    private final K k1;
    private final K k2;
    private final K k3;
    private final V v1;
    private final V v2;
    private final V v3;
    private final int size;
    private Set<K> keySet;
    private Collection<V> values;

    @NotNull
    public static <K, V> UnmodifiableHashMap<K, V> empty() {
        return UnmodifiableHashMap.empty(ContainerUtil.canonicalStrategy());
    }

    @NotNull
    public static <K, V> UnmodifiableHashMap<K, V> empty(TObjectHashingStrategy<K> strategy) {
        return new UnmodifiableHashMap<Object, Object>(strategy, ArrayUtil.EMPTY_OBJECT_ARRAY, null, null, null, null, null, null);
    }

    @NotNull
    public static <K, V> UnmodifiableHashMap<K, V> fromMap(@NotNull Map<? extends K, ? extends V> map) {
        return UnmodifiableHashMap.fromMap(ContainerUtil.canonicalStrategy(), map);
    }

    @NotNull
    public static <K, V> UnmodifiableHashMap<K, V> fromMap(@NotNull TObjectHashingStrategy<K> strategy, @NotNull Map<? extends K, ? extends V> map) {
        if (map instanceof UnmodifiableHashMap && ((UnmodifiableHashMap)map).strategy == strategy) {
            return (UnmodifiableHashMap)map;
        }
        if (map.size() <= 3) {
            K k1 = null;
            K k2 = null;
            K k3 = null;
            V v1 = null;
            V v2 = null;
            V v3 = null;
            Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
            if (iterator.hasNext()) {
                Map.Entry<K, V> e = iterator.next();
                k1 = e.getKey();
                v1 = e.getValue();
                if (iterator.hasNext()) {
                    e = iterator.next();
                    k2 = e.getKey();
                    v2 = e.getValue();
                    if (iterator.hasNext()) {
                        e = iterator.next();
                        k3 = e.getKey();
                        v3 = e.getValue();
                        assert (!iterator.hasNext());
                    }
                }
            }
            return new UnmodifiableHashMap<Object, Object>((TObjectHashingStrategy<Object>)strategy, ArrayUtil.EMPTY_OBJECT_ARRAY, k1, v1, k2, v2, k3, v3);
        }
        Object[] newData = new Object[map.size() * 4];
        map.forEach((k, v) -> UnmodifiableHashMap.insert(strategy, newData, Objects.requireNonNull(k), v));
        return new UnmodifiableHashMap<Object, Object>(strategy, newData, null, null, null, null, null, null);
    }

    private UnmodifiableHashMap(@NotNull TObjectHashingStrategy<K> strategy, Object @NotNull [] data, @Nullable K k1, @Nullable V v1, @Nullable K k2, @Nullable V v2, @Nullable K k3, @Nullable V v3) {
        this.strategy = strategy;
        this.data = data;
        this.k1 = k1;
        this.k2 = k2;
        this.k3 = k3;
        this.v1 = v1;
        this.v2 = v2;
        this.v3 = v3;
        this.size = data.length / 4 + (k1 == null ? 0 : (k2 == null ? 1 : (k3 == null ? 2 : 3)));
    }

    @Contract(pure=true)
    @NotNull
    public UnmodifiableHashMap<K, V> without(@NotNull K key) {
        int pos;
        int n = pos = this.data.length == 0 ? -1 : UnmodifiableHashMap.tablePos(this.strategy, this.data, key);
        if (pos >= 0) {
            Object[] newData = new Object[(this.size - 1) * 4];
            for (int i = 0; i < this.data.length; i += 2) {
                Object k;
                if (i == pos || (k = this.data[i]) == null) continue;
                Object v = this.data[i + 1];
                UnmodifiableHashMap.insert(this.strategy, newData, k, v);
            }
            if (this.k1 != null) {
                UnmodifiableHashMap.insert(this.strategy, newData, this.k1, this.v1);
                if (this.k2 != null) {
                    UnmodifiableHashMap.insert(this.strategy, newData, this.k2, this.v2);
                    if (this.k3 != null) {
                        UnmodifiableHashMap.insert(this.strategy, newData, this.k3, this.v3);
                    }
                }
            }
            return new UnmodifiableHashMap<Object, Object>(this.strategy, newData, null, null, null, null, null, null);
        }
        if (this.k1 != null) {
            if (this.strategy.equals(this.k1, key)) {
                return new UnmodifiableHashMap<Object, Object>((TObjectHashingStrategy<Object>)this.strategy, this.data, this.k2, this.v2, this.k3, this.v3, null, null);
            }
            if (this.k2 != null) {
                if (this.strategy.equals(this.k2, key)) {
                    return new UnmodifiableHashMap<Object, Object>((TObjectHashingStrategy<Object>)this.strategy, this.data, this.k1, this.v1, this.k3, this.v3, null, null);
                }
                if (this.k3 != null && this.strategy.equals(this.k3, key)) {
                    return new UnmodifiableHashMap<Object, Object>((TObjectHashingStrategy<Object>)this.strategy, this.data, this.k1, this.v1, this.k2, this.v2, null, null);
                }
            }
        }
        return this;
    }

    @Contract(pure=true)
    @NotNull
    public UnmodifiableHashMap<K, V> with(@NotNull K key, @Nullable V value) {
        int pos;
        int n = pos = this.data.length == 0 ? -1 : UnmodifiableHashMap.tablePos(this.strategy, this.data, key);
        if (pos >= 0) {
            if (this.data[pos + 1] == value) {
                return this;
            }
            Object[] copy = (Object[])this.data.clone();
            copy[pos + 1] = value;
            return new UnmodifiableHashMap<K, V>(this.strategy, copy, this.k1, this.v1, this.k2, this.v2, this.k3, this.v3);
        }
        if (this.k1 == null) {
            return new UnmodifiableHashMap<Object, Object>((TObjectHashingStrategy<Object>)this.strategy, this.data, key, value, null, null, null, null);
        }
        if (this.strategy.equals(this.k1, key)) {
            return value == this.v1 ? this : new UnmodifiableHashMap<K, V>(this.strategy, this.data, this.k1, value, this.k2, this.v2, this.k3, this.v3);
        }
        if (this.k2 == null) {
            return new UnmodifiableHashMap<Object, Object>((TObjectHashingStrategy<Object>)this.strategy, this.data, this.k1, this.v1, key, value, null, null);
        }
        if (this.strategy.equals(this.k2, key)) {
            return value == this.v2 ? this : new UnmodifiableHashMap<K, V>(this.strategy, this.data, this.k1, this.v1, this.k2, value, this.k3, this.v3);
        }
        if (this.k3 == null) {
            return new UnmodifiableHashMap<K, V>(this.strategy, this.data, this.k1, this.v1, this.k2, this.v2, key, value);
        }
        if (this.strategy.equals(this.k3, key)) {
            return value == this.v3 ? this : new UnmodifiableHashMap<K, V>(this.strategy, this.data, this.k1, this.v1, this.k2, this.v2, this.k3, value);
        }
        Object[] newData = new Object[(this.size + 1) * 4];
        for (int i = 0; i < this.data.length; i += 2) {
            Object k = this.data[i];
            if (k == null) continue;
            Object v = this.data[i + 1];
            UnmodifiableHashMap.insert(this.strategy, newData, k, v);
        }
        UnmodifiableHashMap.insert(this.strategy, newData, this.k1, this.v1);
        UnmodifiableHashMap.insert(this.strategy, newData, this.k2, this.v2);
        UnmodifiableHashMap.insert(this.strategy, newData, this.k3, this.v3);
        UnmodifiableHashMap.insert(this.strategy, newData, key, value);
        return new UnmodifiableHashMap<Object, Object>(this.strategy, newData, null, null, null, null, null, null);
    }

    @NotNull
    public UnmodifiableHashMap<K, V> withAll(@NotNull Map<? extends K, ? extends V> map) {
        if (map.isEmpty()) {
            return this;
        }
        if (map.size() == 1) {
            Map.Entry<K, V> entry = map.entrySet().iterator().next();
            return this.with(entry.getKey(), entry.getValue());
        }
        THashMap newMap = new THashMap((Map)this, this.strategy);
        newMap.putAll(map);
        return UnmodifiableHashMap.fromMap(this.strategy, newMap);
    }

    private static <K> void insert(TObjectHashingStrategy<K> strategy, Object[] data, K k, Object v) {
        int insertPos = UnmodifiableHashMap.tablePos(strategy, data, k);
        assert ((insertPos ^= 0xFFFFFFFF) >= 0);
        data[insertPos] = k;
        data[insertPos + 1] = v;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        Object typedKey = key;
        if (this.data.length > 0 && UnmodifiableHashMap.tablePos(this.strategy, this.data, typedKey) >= 0) {
            return true;
        }
        if (this.k1 != null) {
            if (this.strategy.equals(this.k1, typedKey)) {
                return true;
            }
            if (this.k2 != null) {
                if (this.strategy.equals(this.k2, typedKey)) {
                    return true;
                }
                if (this.k3 != null) {
                    return this.strategy.equals(this.k3, typedKey);
                }
            }
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.k1 != null) {
            if (Objects.equals(this.v1, value)) {
                return true;
            }
            if (this.k2 != null) {
                if (Objects.equals(this.v2, value)) {
                    return true;
                }
                if (this.k3 != null && Objects.equals(this.v3, value)) {
                    return true;
                }
            }
        }
        for (int i = 0; i < this.data.length; i += 2) {
            if (this.data[i] == null || !Objects.equals(this.data[i + 1], value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        return this.getOrDefault(key, null);
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        if (key == null) {
            return defaultValue;
        }
        Object typedKey = key;
        if (this.k1 != null) {
            if (this.strategy.equals(this.k1, typedKey)) {
                return this.v1;
            }
            if (this.k2 != null) {
                if (this.strategy.equals(this.k2, typedKey)) {
                    return this.v2;
                }
                if (this.k3 != null && this.strategy.equals(this.k3, typedKey)) {
                    return this.v3;
                }
            }
        }
        if (this.data.length == 0) {
            return defaultValue;
        }
        int pos = UnmodifiableHashMap.tablePos(this.strategy, this.data, typedKey);
        V v = pos < 0 ? defaultValue : this.data[pos + 1];
        return v;
    }

    private static <K> int tablePos(TObjectHashingStrategy<K> strategy, Object[] data, K key) {
        int pos = Math.floorMod(strategy.computeHashCode(key), data.length / 2) * 2;
        Object candidate;
        while ((candidate = data[pos]) != null) {
            if (strategy.equals(candidate, key)) {
                return pos;
            }
            if ((pos += 2) != data.length) continue;
            pos = 0;
        }
        return ~pos;
    }

    @Override
    public int hashCode() {
        int h = 0;
        if (this.k1 != null) {
            h += this.strategy.computeHashCode(this.k1) ^ Objects.hashCode(this.v1);
            if (this.k2 != null) {
                h += this.strategy.computeHashCode(this.k2) ^ Objects.hashCode(this.v2);
                if (this.k3 != null) {
                    h += this.strategy.computeHashCode(this.k3) ^ Objects.hashCode(this.v3);
                }
            }
        }
        for (int i = 0; i < this.data.length; i += 2) {
            Object key = this.data[i];
            if (key == null) continue;
            h += this.strategy.computeHashCode(key) ^ Objects.hashCode(this.data[i + 1]);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Map)) {
            return false;
        }
        Map map = (Map)obj;
        if (this.size() != map.size()) {
            return false;
        }
        if (this.k1 != null) {
            if (!Objects.equals(map.get(this.k1), this.v1)) {
                return false;
            }
            if (this.k2 != null) {
                if (!Objects.equals(map.get(this.k2), this.v2)) {
                    return false;
                }
                if (this.k3 != null && !Objects.equals(map.get(this.k3), this.v3)) {
                    return false;
                }
            }
        }
        for (int i = 0; i < this.data.length; i += 2) {
            Object key = this.data[i];
            if (key == null || Objects.equals(map.get(key), this.data[i + 1])) continue;
            return false;
        }
        return true;
    }

    @Override
    @Deprecated
    public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void putAll(@NotNull Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        if (this.k1 != null) {
            if (this.k2 != null) {
                if (this.k3 != null) {
                    action.accept(this.k3, this.v3);
                }
                action.accept(this.k2, this.v2);
            }
            action.accept(this.k1, this.v1);
        }
        for (int i = 0; i < this.data.length; i += 2) {
            Object key = this.data[i];
            if (key == null) continue;
            action.accept(key, this.data[i + 1]);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        this.forEach((k, v) -> {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append(k).append('=').append(v);
        });
        return sb.append('}').toString();
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet<K>(){

                @Override
                @NotNull
                public Iterator<K> iterator() {
                    return new MyIterator<K>(){

                        @Override
                        K fieldElement(int offset) {
                            return offset == 0 ? UnmodifiableHashMap.this.k1 : (offset == 1 ? UnmodifiableHashMap.this.k2 : UnmodifiableHashMap.this.k3);
                        }

                        @Override
                        K tableElement(int offset) {
                            return UnmodifiableHashMap.this.data[offset];
                        }
                    };
                }

                @Override
                public void forEach(Consumer<? super K> action) {
                    if (UnmodifiableHashMap.this.k1 != null) {
                        if (UnmodifiableHashMap.this.k2 != null) {
                            if (UnmodifiableHashMap.this.k3 != null) {
                                action.accept(UnmodifiableHashMap.this.k3);
                            }
                            action.accept(UnmodifiableHashMap.this.k2);
                        }
                        action.accept(UnmodifiableHashMap.this.k1);
                    }
                    for (int i = 0; i < UnmodifiableHashMap.this.data.length; i += 2) {
                        Object key = UnmodifiableHashMap.this.data[i];
                        if (key == null) continue;
                        Object k = UnmodifiableHashMap.this.data[i];
                        action.accept(k);
                    }
                }

                @Override
                public boolean contains(Object o) {
                    return UnmodifiableHashMap.this.containsKey(o);
                }

                @Override
                public int size() {
                    return UnmodifiableHashMap.this.size();
                }
            };
        }
        return this.keySet;
    }

    @Override
    @NotNull
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new AbstractCollection<V>(){

                @Override
                @NotNull
                public Iterator<V> iterator() {
                    return new MyIterator<V>(){

                        @Override
                        V fieldElement(int offset) {
                            return offset == 0 ? UnmodifiableHashMap.this.v1 : (offset == 1 ? UnmodifiableHashMap.this.v2 : UnmodifiableHashMap.this.v3);
                        }

                        @Override
                        V tableElement(int offset) {
                            return UnmodifiableHashMap.this.data[offset + 1];
                        }
                    };
                }

                @Override
                public void forEach(Consumer<? super V> action) {
                    if (UnmodifiableHashMap.this.k1 != null) {
                        if (UnmodifiableHashMap.this.k2 != null) {
                            if (UnmodifiableHashMap.this.k3 != null) {
                                action.accept(UnmodifiableHashMap.this.v3);
                            }
                            action.accept(UnmodifiableHashMap.this.v2);
                        }
                        action.accept(UnmodifiableHashMap.this.v1);
                    }
                    for (int i = 0; i < UnmodifiableHashMap.this.data.length; i += 2) {
                        Object key = UnmodifiableHashMap.this.data[i];
                        if (key == null) continue;
                        Object v = UnmodifiableHashMap.this.data[i + 1];
                        action.accept(v);
                    }
                }

                @Override
                public boolean contains(Object o) {
                    return UnmodifiableHashMap.this.containsValue(o);
                }

                @Override
                public int size() {
                    return UnmodifiableHashMap.this.size();
                }
            };
        }
        return this.values;
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            @NotNull
            public Iterator<Map.Entry<K, V>> iterator() {
                return new MyIterator<Map.Entry<K, V>>(){

                    @Override
                    Map.Entry<K, V> fieldElement(int offset) {
                        return offset == 0 ? new AbstractMap.SimpleImmutableEntry<Object, Object>(UnmodifiableHashMap.this.k1, UnmodifiableHashMap.this.v1) : (offset == 1 ? new AbstractMap.SimpleImmutableEntry<Object, Object>(UnmodifiableHashMap.this.k2, UnmodifiableHashMap.this.v2) : new AbstractMap.SimpleImmutableEntry<Object, Object>(UnmodifiableHashMap.this.k3, UnmodifiableHashMap.this.v3));
                    }

                    @Override
                    Map.Entry<K, V> tableElement(int offset) {
                        return new AbstractMap.SimpleImmutableEntry<Object, Object>(UnmodifiableHashMap.this.data[offset], UnmodifiableHashMap.this.data[offset + 1]);
                    }
                };
            }

            @Override
            public int size() {
                return UnmodifiableHashMap.this.size();
            }
        };
    }

    private abstract class MyIterator<E>
    implements Iterator<E> {
        int pos;

        MyIterator() {
            if (UnmodifiableHashMap.this.k1 == null) {
                this.pos = -1;
                this.advance();
            } else {
                this.pos = UnmodifiableHashMap.this.k2 == null ? -1 : (UnmodifiableHashMap.this.k3 == null ? -2 : -3);
            }
        }

        @Override
        public boolean hasNext() {
            return this.pos < UnmodifiableHashMap.this.data.length;
        }

        private void advance() {
            this.pos = this.pos < 0 ? ++this.pos : (this.pos += 2);
            if (this.pos >= 0) {
                while (this.pos < UnmodifiableHashMap.this.data.length && UnmodifiableHashMap.this.data[this.pos] == null) {
                    ++this.pos;
                }
            }
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.pos < 0) {
                int offset = ~this.pos;
                this.advance();
                return this.fieldElement(offset);
            }
            int offset = this.pos;
            this.advance();
            return this.tableElement(offset);
        }

        abstract E fieldElement(int var1);

        abstract E tableElement(int var1);
    }
}

