/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.util.DeprecatedMethodException;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FactoryMap<K, V>
implements Map<K, V> {
    private Map<K, V> myMap;

    @Deprecated
    public FactoryMap() {
        DeprecatedMethodException.report("Use FactoryMap.create*() instead");
    }

    private FactoryMap(boolean safe) {
    }

    @NotNull
    protected Map<K, V> createMap() {
        return new THashMap();
    }

    @Nullable
    protected abstract V create(K var1);

    @Override
    public V get(Object key) {
        Object k;
        Map map = this.getMap();
        V value = map.get(k = FactoryMap.notNull(key));
        if (value == null) {
            RecursionGuard.StackStamp stamp = RecursionManager.markStack();
            value = this.create(key);
            if (stamp.mayCacheNow()) {
                Object v = FactoryMap.notNull(value);
                map.put(k, v);
            }
        }
        return FactoryMap.nullize(value);
    }

    private Map<K, V> getMap() {
        Map<K, V> map = this.myMap;
        if (map == null) {
            this.myMap = map = this.createMap();
        }
        return map;
    }

    private static <T> T FAKE_NULL() {
        return (T)ObjectUtils.NULL;
    }

    private static <T> T notNull(Object key) {
        return (T)(key == null ? FactoryMap.FAKE_NULL() : key);
    }

    @Nullable
    private static <T> T nullize(T value) {
        return value == FactoryMap.FAKE_NULL() ? null : (T)value;
    }

    @Override
    public final boolean containsKey(Object key) {
        return this.getMap().containsKey(FactoryMap.notNull(key));
    }

    @Override
    public V put(K key, V value) {
        Object k = FactoryMap.notNull(key);
        Object v = FactoryMap.notNull(value);
        v = this.getMap().put(k, v);
        return (V)FactoryMap.nullize(v);
    }

    @Override
    public V remove(Object key) {
        V v = this.getMap().remove(key);
        return FactoryMap.nullize(v);
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        Object nullKey;
        Set<K> ts = this.getMap().keySet();
        if (ts.contains(nullKey = FactoryMap.FAKE_NULL())) {
            HashSet<K> hashSet = new HashSet<K>(ts);
            hashSet.remove(nullKey);
            hashSet.add(null);
            return hashSet;
        }
        return ts;
    }

    public boolean removeValue(Object value) {
        Object t = FactoryMap.notNull(value);
        return this.getMap().values().remove(t);
    }

    @Override
    public void clear() {
        this.getMap().clear();
    }

    @Override
    public int size() {
        return this.getMap().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getMap().isEmpty();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getMap().containsValue(value);
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    @NotNull
    public Collection<V> values() {
        return ContainerUtil.map(this.getMap().values(), FactoryMap::nullize);
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        return ContainerUtil.map2Set(this.getMap().entrySet(), entry -> new AbstractMap.SimpleEntry(FactoryMap.nullize(entry.getKey()), FactoryMap.nullize(entry.getValue())));
    }

    public String toString() {
        return String.valueOf(this.myMap);
    }

    @NotNull
    public static <K, V> Map<K, V> create(final @NotNull Function<? super K, ? extends V> computeValue) {
        return new FactoryMap<K, V>(true){

            @Override
            @Nullable
            protected V create(K key) {
                return computeValue.fun(key);
            }
        };
    }

    @NotNull
    public static <K, V> Map<K, V> createMap(final @NotNull Function<? super K, ? extends V> computeValue, final @NotNull Supplier<? extends Map<K, V>> mapCreator) {
        return new FactoryMap<K, V>(true){

            @Override
            @Nullable
            protected V create(K key) {
                return computeValue.fun(key);
            }

            @Override
            @NotNull
            protected Map<K, V> createMap() {
                return (Map)mapCreator.get();
            }
        };
    }
}

