/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.jetbrains.annotations.NotNull;
import sun.misc.Unsafe;

public final class AtomicFieldUpdater<ContainingClass, FieldType> {
    private static final Unsafe unsafe = ReflectionUtil.getStaticFieldValue(Unsafe.class, Unsafe.class, "theUnsafe");
    private final long offset;

    @NotNull
    public static Unsafe getUnsafe() {
        return unsafe;
    }

    @NotNull
    public static <T, V> AtomicFieldUpdater<T, V> forFieldOfType(@NotNull Class<T> ownerClass, @NotNull Class<V> fieldType) {
        return new AtomicFieldUpdater<T, V>(ownerClass, fieldType);
    }

    @NotNull
    public static <T> AtomicFieldUpdater<T, Long> forLongFieldIn(@NotNull Class<T> ownerClass) {
        return new AtomicFieldUpdater<T, Long>(ownerClass, Long.TYPE);
    }

    @NotNull
    public static <T> AtomicFieldUpdater<T, Integer> forIntFieldIn(@NotNull Class<T> ownerClass) {
        return new AtomicFieldUpdater<T, Integer>(ownerClass, Integer.TYPE);
    }

    @NotNull
    public static <O, E> AtomicFieldUpdater<O, E> forField(@NotNull Field field) {
        return new AtomicFieldUpdater(field);
    }

    private AtomicFieldUpdater(@NotNull Class<ContainingClass> ownerClass, @NotNull Class<FieldType> fieldType) {
        this(ReflectionUtil.getTheOnlyVolatileInstanceFieldOfClass(ownerClass, fieldType));
    }

    private AtomicFieldUpdater(@NotNull Field field) {
        field.setAccessible(true);
        if (!Modifier.isVolatile(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) {
            throw new IllegalArgumentException(field + " must be volatile instance");
        }
        this.offset = unsafe.objectFieldOffset(field);
    }

    public boolean compareAndSet(@NotNull ContainingClass owner, FieldType expected, FieldType newValue) {
        return unsafe.compareAndSwapObject(owner, this.offset, expected, newValue);
    }

    public boolean compareAndSetLong(@NotNull ContainingClass owner, long expected, long newValue) {
        return unsafe.compareAndSwapLong(owner, this.offset, expected, newValue);
    }

    public boolean compareAndSetInt(@NotNull ContainingClass owner, int expected, int newValue) {
        return unsafe.compareAndSwapInt(owner, this.offset, expected, newValue);
    }

    public void set(@NotNull ContainingClass owner, FieldType newValue) {
        unsafe.putObjectVolatile(owner, this.offset, newValue);
    }

    public FieldType get(@NotNull ContainingClass owner) {
        return (FieldType)unsafe.getObjectVolatile(owner, this.offset);
    }

    static {
        if (unsafe == null) {
            throw new RuntimeException("Could not find 'theUnsafe' field in the " + Unsafe.class);
        }
    }
}

