/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.diagnostic.ThreadDumper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.LowMemoryWatcherManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.concurrency.AppDelayQueue;
import com.intellij.util.concurrency.CountingThreadFactory;
import com.intellij.util.concurrency.SchedulingWrapper;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public final class AppScheduledExecutorService
extends SchedulingWrapper {
    static final String POOLED_THREAD_PREFIX = "ApplicationImpl pooled thread ";
    @NotNull
    private final String myName;
    private final LowMemoryWatcherManager myLowMemoryWatcherManager;
    private final MyThreadFactory myCountingThreadFactory;

    @NotNull
    static ScheduledExecutorService getInstance() {
        return Holder.INSTANCE;
    }

    AppScheduledExecutorService(@NotNull String name) {
        super(new BackendThreadPoolExecutor(new MyThreadFactory()), new AppDelayQueue());
        this.myName = name;
        this.myCountingThreadFactory = (MyThreadFactory)((BackendThreadPoolExecutor)this.backendExecutorService).getThreadFactory();
        this.myLowMemoryWatcherManager = new LowMemoryWatcherManager(this);
    }

    public void setNewThreadListener(@NotNull Consumer<? super Thread> threadListener) {
        this.myCountingThreadFactory.setNewThreadListener(threadListener);
    }

    @Override
    @NotNull
    public List<Runnable> shutdownNow() {
        return AppScheduledExecutorService.error();
    }

    @Override
    public void shutdown() {
        AppScheduledExecutorService.error();
    }

    static List<Runnable> error() {
        throw new IncorrectOperationException("You must not call this method on the global app pool");
    }

    @Override
    void doShutdown() {
        super.doShutdown();
        ((BackendThreadPoolExecutor)this.backendExecutorService).superShutdown();
    }

    @Override
    @NotNull
    List<Runnable> doShutdownNow() {
        return ContainerUtil.concat(super.doShutdownNow(), ((BackendThreadPoolExecutor)this.backendExecutorService).superShutdownNow());
    }

    public void shutdownAppScheduledExecutorService() {
        Disposer.dispose(this.myLowMemoryWatcherManager);
        this.delayQueue.shutdown();
        this.doShutdown();
    }

    @NotNull
    public String statistics() {
        return this.myName + " threads created counter = " + this.myCountingThreadFactory.counter;
    }

    public String dumpQueue() {
        return this.delayQueue.toString();
    }

    public int getBackendPoolExecutorSize() {
        return ((BackendThreadPoolExecutor)this.backendExecutorService).getPoolSize();
    }

    void setBackendPoolCorePoolSize(int size) {
        ((BackendThreadPoolExecutor)this.backendExecutorService).superSetCorePoolSize(size);
    }

    @NotNull
    public Thread getPeriodicTasksThread() {
        return this.delayQueue.getThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void awaitQuiescence(long timeout, @NotNull TimeUnit unit) {
        HashSet workers;
        BackendThreadPoolExecutor executor = (BackendThreadPoolExecutor)this.backendExecutorService;
        executor.getKeepAliveTime(TimeUnit.NANOSECONDS);
        executor.superSetKeepAliveTime(1L, TimeUnit.NANOSECONDS);
        executor.superSetCorePoolSize(0);
        ReentrantLock mainLock = ReflectionUtil.getField(executor.getClass(), executor, ReentrantLock.class, "mainLock");
        mainLock.lock();
        try {
            Set workersField = ReflectionUtil.getField(executor.getClass(), executor, HashSet.class, "workers");
            workers = new HashSet(workersField);
        }
        finally {
            mainLock.unlock();
        }
        executor.superSetKeepAliveTime(1L, TimeUnit.SECONDS);
        for (Object worker : workers) {
            Thread thread = ReflectionUtil.getField(worker.getClass(), worker, Thread.class, "thread");
            try {
                thread.join(unit.toMillis(timeout));
            }
            catch (InterruptedException e) {
                String trace = "Thread leaked: " + thread + "; " + (Object)((Object)thread.getState()) + " (" + thread.isAlive() + ")\n--- its stacktrace:\n";
                for (StackTraceElement stackTraceElement : thread.getStackTrace()) {
                    trace = trace + " at " + stackTraceElement + "\n";
                }
                trace = trace + "---\n";
                System.err.println("Executor " + executor + " is still active after " + unit.toSeconds(timeout) + " seconds://///\nThread " + thread + " dump:\n" + trace + "all thread dump:\n" + ThreadDumper.dumpThreadsToString() + "\n/////");
                break;
            }
        }
    }

    static class BackendThreadPoolExecutor
    extends ThreadPoolExecutor {
        BackendThreadPoolExecutor(@NotNull ThreadFactory factory) {
            super(1, Integer.MAX_VALUE, 1L, TimeUnit.MINUTES, new SynchronousQueue<Runnable>(), factory);
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            if (t != null && !(t instanceof ProcessCanceledException)) {
                Logger.getInstance(SchedulingWrapper.class).error("Worker exited due to exception", t);
            }
        }

        private void superShutdown() {
            super.shutdown();
        }

        @NotNull
        private List<Runnable> superShutdownNow() {
            return super.shutdownNow();
        }

        @Override
        public void shutdown() {
            AppScheduledExecutorService.error();
        }

        @Override
        @NotNull
        public List<Runnable> shutdownNow() {
            return AppScheduledExecutorService.error();
        }

        @Override
        public void setCorePoolSize(int corePoolSize) {
            AppScheduledExecutorService.error();
        }

        private void superSetCorePoolSize(int corePoolSize) {
            super.setCorePoolSize(corePoolSize);
        }

        @Override
        public void allowCoreThreadTimeOut(boolean value) {
            AppScheduledExecutorService.error();
        }

        @Override
        public void setMaximumPoolSize(int maximumPoolSize) {
            AppScheduledExecutorService.error();
        }

        @Override
        public void setKeepAliveTime(long time, TimeUnit unit) {
            AppScheduledExecutorService.error();
        }

        void superSetKeepAliveTime(long time, TimeUnit unit) {
            super.setKeepAliveTime(time, unit);
        }

        @Override
        public void setThreadFactory(ThreadFactory threadFactory) {
            AppScheduledExecutorService.error();
        }
    }

    private static class MyThreadFactory
    extends CountingThreadFactory {
        private Consumer<? super Thread> newThreadListener;
        private final ThreadFactory myThreadFactory = Executors.privilegedThreadFactory();

        private MyThreadFactory() {
        }

        @Override
        @NotNull
        public Thread newThread(@NotNull Runnable r) {
            Thread thread = this.myThreadFactory.newThread(r);
            thread.setName(AppScheduledExecutorService.POOLED_THREAD_PREFIX + this.counter.incrementAndGet());
            thread.setPriority(4);
            Consumer<? super Thread> listener = this.newThreadListener;
            if (listener != null) {
                listener.accept(thread);
            }
            return thread;
        }

        void setNewThreadListener(@NotNull Consumer<? super Thread> threadListener) {
            if (this.newThreadListener != null) {
                throw new IllegalStateException("Listener was already set: " + this.newThreadListener);
            }
            this.newThreadListener = threadListener;
        }
    }

    private static class Holder {
        private static final AppScheduledExecutorService INSTANCE = new AppScheduledExecutorService("Global instance");

        private Holder() {
        }
    }
}

