/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.util.ReflectionUtil;
import java.lang.reflect.Field;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FieldAccessor<E, T> {
    private static final Logger LOG = Logger.getInstance(FieldAccessor.class);
    private Ref<Field> myFieldRef;
    private final Class<E> myClass;
    private final String myName;
    private final Class<T> myType;

    public FieldAccessor(@NotNull Class<E> aClass, @NotNull String name) {
        this(aClass, name, null);
    }

    public FieldAccessor(@NotNull Class<E> aClass, @NotNull String name, @Nullable Class<T> type) {
        this.myClass = aClass;
        this.myName = name;
        this.myType = type;
    }

    public boolean isAvailable() {
        if (this.myFieldRef == null) {
            try {
                this.myFieldRef = new Ref();
                this.myFieldRef.set(ReflectionUtil.findAssignableField(this.myClass, this.myType, this.myName));
                this.myFieldRef.get().setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                LOG.warn("Field not found: " + this.myClass.getName() + "." + this.myName);
            }
        }
        return this.myFieldRef.get() != null;
    }

    public T get(@Nullable E object) {
        if (!this.isAvailable()) {
            return null;
        }
        try {
            return (T)this.myFieldRef.get().get(object);
        }
        catch (IllegalAccessException e) {
            LOG.warn("Field not accessible: " + this.myClass.getName() + "." + this.myName);
            return null;
        }
    }

    public void set(@Nullable E object, @Nullable T value) {
        if (!this.isAvailable()) {
            return;
        }
        try {
            this.myFieldRef.get().set(object, value);
        }
        catch (IllegalAccessException e) {
            LOG.warn("Field not accessible: " + this.myClass.getName() + "." + this.myName);
        }
    }
}

