/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.ValueKey;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ValueMatcherImpl<T, T1>
implements ValueKey.BeforeIf<T>,
ValueKey.BeforeThen<T, T1> {
    @NotNull
    private final String myKey;
    @NotNull
    private State myState = State.NOT_MATCHED;
    private T myValue;

    ValueMatcherImpl(@NotNull String key) {
        this.myKey = key;
    }

    @Override
    @NotNull
    public <TT> ValueKey.BeforeThen<T, TT> ifEq(@NotNull ValueKey<TT> key) {
        switch (this.myState) {
            case FINISHED: {
                throw new IllegalStateException("Matching is already finished");
            }
            case IGNORING: 
            case MATCHING: 
            case SKIPPING: {
                throw new IllegalStateException("'then'/'thenGet'/'or' call is expected");
            }
            case MATCHED: {
                if (key.getName().equals(this.myKey)) {
                    throw new IllegalStateException("Key '" + key.getName() + "' already matched");
                }
                this.myState = State.SKIPPING;
                break;
            }
            case NOT_MATCHED: {
                this.myState = key.getName().equals(this.myKey) ? State.MATCHING : State.IGNORING;
            }
        }
        return this;
    }

    @Override
    public T get() {
        switch (this.myState) {
            case FINISHED: {
                throw new IllegalStateException("Matching is already finished");
            }
            case NOT_MATCHED: {
                this.myState = State.FINISHED;
                throw new NoSuchElementException("Requested key '" + this.myKey + "' is not matched");
            }
            case MATCHED: {
                this.myState = State.FINISHED;
                return this.myValue;
            }
        }
        throw new IllegalStateException("'then'/'thenGet'/'or' call is expected");
    }

    @Override
    @Nullable
    public T orNull() {
        switch (this.myState) {
            case FINISHED: {
                throw new IllegalStateException("Matching is already finished");
            }
            case MATCHED: 
            case NOT_MATCHED: {
                this.myState = State.FINISHED;
                return this.myValue;
            }
        }
        throw new IllegalStateException("'then'/'thenGet'/'or' call is expected");
    }

    @Override
    @NotNull
    public ValueKey.BeforeThen<T, T1> or(@NotNull ValueKey<T1> key) {
        switch (this.myState) {
            case FINISHED: {
                throw new IllegalStateException("Matching is already finished");
            }
            case MATCHED: 
            case NOT_MATCHED: {
                throw new IllegalStateException("'ifEq'/'get'/'orNull' call is expected");
            }
            case MATCHING: 
            case SKIPPING: {
                if (!key.getName().equals(this.myKey)) break;
                throw new IllegalStateException("Key '" + key.getName() + "' already matched");
            }
            case IGNORING: {
                if (!key.getName().equals(this.myKey)) break;
                this.myState = State.MATCHING;
            }
        }
        return this;
    }

    @Override
    @NotNull
    public ValueKey.BeforeIf<T> then(T1 value) {
        switch (this.myState) {
            case FINISHED: {
                throw new IllegalStateException("Matching is already finished");
            }
            case MATCHED: 
            case NOT_MATCHED: {
                throw new IllegalStateException("'ifEq'/'get'/'orNull' call is expected");
            }
            case SKIPPING: {
                this.myState = State.MATCHED;
                break;
            }
            case IGNORING: {
                this.myState = State.NOT_MATCHED;
                break;
            }
            case MATCHING: {
                this.myState = State.MATCHED;
                this.myValue = value;
            }
        }
        return this;
    }

    @Override
    @NotNull
    public ValueKey.BeforeIf<T> thenGet(@NotNull Supplier<? extends T1> fn) {
        switch (this.myState) {
            case FINISHED: {
                throw new IllegalStateException("Matching is already finished");
            }
            case MATCHED: 
            case NOT_MATCHED: {
                throw new IllegalStateException("'ifEq'/'get'/'orNull' call is expected");
            }
            case SKIPPING: {
                this.myState = State.MATCHED;
                break;
            }
            case IGNORING: {
                this.myState = State.NOT_MATCHED;
                break;
            }
            case MATCHING: {
                this.myState = State.MATCHED;
                this.myValue = fn.get();
            }
        }
        return this;
    }

    private static enum State {
        NOT_MATCHED,
        IGNORING,
        SKIPPING,
        MATCHING,
        MATCHED,
        FINISHED;

    }
}

