/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.ExceptionWithAttachments;
import com.intellij.openapi.util.objectTree.ThrowableInterner;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TraceableDisposable {
    private final Throwable CREATE_TRACE;
    private Throwable KILL_TRACE;

    public TraceableDisposable(boolean debug) {
        this.CREATE_TRACE = debug ? ThrowableInterner.intern(new Throwable()) : null;
    }

    public void kill(@NonNls @Nullable String msg) {
        if (this.CREATE_TRACE != null) {
            this.KILL_TRACE = ThrowableInterner.intern(new Throwable(msg));
        }
    }

    public void killExceptionally(@NotNull Throwable throwable) {
        if (this.CREATE_TRACE != null) {
            this.KILL_TRACE = throwable;
        }
    }

    public void throwObjectNotDisposedError(@NonNls @NotNull String msg) {
        throw new ObjectNotDisposedException(msg);
    }

    public void throwDisposalError(@NonNls String msg) throws RuntimeException {
        throw new DisposalException(msg);
    }

    @NotNull
    public String getStackTrace() {
        StringWriter s = new StringWriter();
        PrintWriter out = new PrintWriter(s);
        if (this.CREATE_TRACE != null) {
            out.println("--------------Creation trace: ");
            this.CREATE_TRACE.printStackTrace(out);
        }
        if (this.KILL_TRACE != null) {
            out.println("--------------Kill trace: ");
            this.KILL_TRACE.printStackTrace(out);
        }
        out.println("-------------Own trace:");
        new DisposalException("" + System.identityHashCode(this)).printStackTrace(out);
        out.flush();
        return s.toString();
    }

    private class DisposalException
    extends RuntimeException
    implements ExceptionWithAttachments {
        private DisposalException(String message) {
            super(message);
        }

        @Override
        public Attachment @NotNull [] getAttachments() {
            SmartList<Attachment> answer = new SmartList<Attachment>();
            if (TraceableDisposable.this.CREATE_TRACE != null) {
                answer.add(new Attachment("creation", TraceableDisposable.this.CREATE_TRACE));
            }
            if (TraceableDisposable.this.KILL_TRACE != null) {
                answer.add(new Attachment("kill", TraceableDisposable.this.KILL_TRACE));
            }
            return answer.toArray(Attachment.EMPTY_ARRAY);
        }
    }

    private final class ObjectNotDisposedException
    extends RuntimeException
    implements ExceptionWithAttachments {
        ObjectNotDisposedException(String msg) {
            super(msg);
            TraceableDisposable.this.KILL_TRACE = ThrowableInterner.intern(new Throwable(msg));
        }

        @Override
        public Attachment @NotNull [] getAttachments() {
            return new Attachment[]{new Attachment("kill", TraceableDisposable.this.KILL_TRACE)};
        }

        @Override
        public void printStackTrace(@NotNull PrintStream s) {
            PrintWriter writer = new PrintWriter(s);
            this.printStackTrace(writer);
            writer.flush();
        }

        @Override
        public void printStackTrace(PrintWriter s) {
            ArrayList<StackTraceElement> stack = new ArrayList<StackTraceElement>(Arrays.asList(TraceableDisposable.this.CREATE_TRACE.getStackTrace()));
            stack.remove(0);
            s.write(ObjectNotDisposedException.class.getCanonicalName() + ": See stack trace responsible for creation of unreleased object below \n\tat " + StringUtil.join(stack, "\n\tat "));
        }
    }
}

