/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NullableLazyValue<T> {
    private boolean myComputed;
    @Nullable
    private T myValue;

    @Nullable
    protected abstract T compute();

    @Nullable
    public T getValue() {
        T value = this.myValue;
        if (!this.myComputed) {
            RecursionGuard.StackStamp stamp = RecursionManager.markStack();
            value = this.compute();
            if (stamp.mayCacheNow()) {
                this.myValue = value;
                this.myComputed = true;
            }
        }
        return value;
    }

    @NotNull
    public static <T> NullableLazyValue<T> createValue(final @NotNull Factory<? extends T> value) {
        return new NullableLazyValue<T>(){

            @Override
            @Nullable
            protected T compute() {
                return value.create();
            }
        };
    }
}

