/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SafeJdomFactory;
import com.intellij.openapi.util.SafeStAXStreamBuilder;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.io.URLUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.CharSequenceReader;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.ClosedFileSystemException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.JDOMInterner;
import org.jdom.Namespace;
import org.jdom.Parent;
import org.jdom.Text;
import org.jdom.Verifier;
import org.jdom.filter.Filter;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JDOMUtil {
    private static final String X = "x";
    private static final String Y = "y";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    public static final Pattern XPOINTER_PATTERN = Pattern.compile("xpointer\\((.*)\\)");
    public static final Namespace XINCLUDE_NAMESPACE = Namespace.getNamespace((String)"xi", (String)"http://www.w3.org/2001/XInclude");
    public static final Pattern CHILDREN_PATTERN = Pattern.compile("/([^/]*)(/[^/]*)?/\\*");
    private static final String XML_INPUT_FACTORY_KEY = "javax.xml.stream.XMLInputFactory";
    private static final String XML_INPUT_FACTORY_IMPL = "com.sun.xml.internal.stream.XMLInputFactoryImpl";
    private static volatile XMLInputFactory XML_INPUT_FACTORY;
    private static final EmptyTextFilter CONTENT_FILTER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static XMLInputFactory getXmlInputFactory() {
        XMLInputFactory factory = XML_INPUT_FACTORY;
        if (factory != null) {
            return factory;
        }
        Class<JDOMUtil> clazz = JDOMUtil.class;
        synchronized (JDOMUtil.class) {
            factory = XML_INPUT_FACTORY;
            if (factory != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return factory;
            }
            String property = System.setProperty(XML_INPUT_FACTORY_KEY, XML_INPUT_FACTORY_IMPL);
            try {
                factory = XMLInputFactory.newFactory();
            }
            finally {
                if (property != null) {
                    System.setProperty(XML_INPUT_FACTORY_KEY, property);
                } else {
                    System.clearProperty(XML_INPUT_FACTORY_KEY);
                }
            }
            if (!SystemInfo.isIbmJvm) {
                try {
                    factory.setProperty("http://java.sun.com/xml/stream/properties/report-cdata-event", true);
                }
                catch (Exception e) {
                    JDOMUtil.getLogger().error("cannot set \"report-cdata-event\" property for XMLInputFactory", e);
                }
            }
            factory.setProperty("javax.xml.stream.isCoalescing", true);
            factory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            factory.setProperty("javax.xml.stream.supportDTD", false);
            XML_INPUT_FACTORY = factory;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return factory;
        }
    }

    private JDOMUtil() {
    }

    @NotNull
    public static List<Element> getChildren(@Nullable Element parent) {
        return parent == null ? Collections.emptyList() : parent.getChildren();
    }

    @NotNull
    public static List<Element> getChildren(@Nullable Element parent, @NotNull String name) {
        if (parent != null) {
            return parent.getChildren(name);
        }
        return Collections.emptyList();
    }

    private static Logger getLogger() {
        return LoggerHolder.ourLogger;
    }

    public static boolean areElementsEqual(@Nullable Element e1, @Nullable Element e2) {
        return JDOMUtil.areElementsEqual(e1, e2, false);
    }

    public static boolean areElementsEqual(@Nullable Element e1, @Nullable Element e2, boolean ignoreEmptyAttrValues) {
        if (e1 == null && e2 == null) {
            return true;
        }
        if (e1 == null || e2 == null) {
            return false;
        }
        return Objects.equals(e1.getName(), e2.getName()) && JDOMUtil.isAttributesEqual(JDOMUtil.getAttributes(e1), JDOMUtil.getAttributes(e2), ignoreEmptyAttrValues) && JDOMUtil.areElementContentsEqual(e1, e2, ignoreEmptyAttrValues);
    }

    public static int hashCode(@Nullable Element e, boolean ignoreEmptyAttrValues) {
        if (e == null) {
            return 0;
        }
        int hashCode = e.getName().hashCode();
        for (Attribute attribute : JDOMUtil.getAttributes(e)) {
            String value = attribute.getValue();
            if (ignoreEmptyAttrValues && (value == null || value.isEmpty())) continue;
            hashCode = hashCode * 31 * 31 + attribute.getName().hashCode() * 31 + value.hashCode();
        }
        for (Content content : e.getContent((Filter)CONTENT_FILTER)) {
            int contentHash = content instanceof Element ? JDOMUtil.hashCode((Element)content, ignoreEmptyAttrValues) : e.getValue().hashCode();
            hashCode = hashCode * 31 + contentHash;
        }
        return hashCode;
    }

    public static boolean areElementContentsEqual(@NotNull Element e1, @NotNull Element e2, boolean ignoreEmptyAttrValues) {
        return JDOMUtil.contentListsEqual(e1.getContent((Filter)CONTENT_FILTER), e2.getContent((Filter)CONTENT_FILTER), ignoreEmptyAttrValues);
    }

    @Deprecated
    public static Element @NotNull [] getElements(@NotNull Element m) {
        List list = m.getChildren();
        return list.toArray(new Element[0]);
    }

    @NotNull
    public static String legalizeText(@NotNull String str) {
        return JDOMUtil.legalizeChars(str).toString();
    }

    @NotNull
    public static CharSequence legalizeChars(@NotNull CharSequence str) {
        StringBuilder result = new StringBuilder(str.length());
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            JDOMUtil.appendLegalized(result, str.charAt(i));
        }
        return result;
    }

    private static void appendLegalized(@NotNull StringBuilder sb, char each) {
        if (each == '<' || each == '>') {
            sb.append(each == '<' ? "&lt;" : "&gt;");
        } else if (!Verifier.isXMLCharacter((int)each)) {
            sb.append("0x").append(StringUtil.toUpperCase(Long.toHexString(each)));
        } else {
            sb.append(each);
        }
    }

    private static boolean contentListsEqual(List<Content> c1, List<Content> c2, boolean ignoreEmptyAttrValues) {
        if (c1 == null && c2 == null) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        ListIterator<Content> l1 = c1.listIterator();
        ListIterator<Content> l2 = c2.listIterator();
        while (l1.hasNext() && l2.hasNext()) {
            if (JDOMUtil.contentsEqual((Content)l1.next(), (Content)l2.next(), ignoreEmptyAttrValues)) continue;
            return false;
        }
        return l1.hasNext() == l2.hasNext();
    }

    private static boolean contentsEqual(Content c1, Content c2, boolean ignoreEmptyAttrValues) {
        if (!(c1 instanceof Element) && !(c2 instanceof Element)) {
            return c1.getValue().equals(c2.getValue());
        }
        return c1 instanceof Element && c2 instanceof Element && JDOMUtil.areElementsEqual((Element)c1, (Element)c2, ignoreEmptyAttrValues);
    }

    private static boolean isAttributesEqual(@NotNull List<? extends Attribute> l1, @NotNull List<? extends Attribute> l2, boolean ignoreEmptyAttrValues) {
        if (ignoreEmptyAttrValues) {
            l1 = JDOMUtil.getNotEmptyAttributes(l1);
            l2 = JDOMUtil.getNotEmptyAttributes(l2);
        }
        if (l1.size() != l2.size()) {
            return false;
        }
        for (int i = 0; i < l1.size(); ++i) {
            if (JDOMUtil.attributesEqual(l1.get(i), l2.get(i))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static List<? extends Attribute> getNotEmptyAttributes(@NotNull List<? extends Attribute> list) {
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Attribute> result = null;
        for (Attribute attribute : list) {
            String s = attribute.getValue();
            if (s == null || s.isEmpty()) continue;
            if (result == null) {
                result = new ArrayList<Attribute>(list.size());
            }
            result.add(attribute);
        }
        return result == null ? Collections.emptyList() : result;
    }

    private static boolean attributesEqual(@NotNull Attribute a1, @NotNull Attribute a2) {
        return a1.getName().equals(a2.getName()) && a1.getValue().equals(a2.getValue());
    }

    @NotNull
    private static Document loadDocumentUsingStaX(@NotNull Reader reader) throws JDOMException, IOException {
        try {
            Document document;
            XMLStreamReader xmlStreamReader = JDOMUtil.getXmlInputFactory().createXMLStreamReader(reader);
            try {
                document = SafeStAXStreamBuilder.buildDocument(xmlStreamReader, true);
            }
            catch (Throwable throwable) {
                try {
                    xmlStreamReader.close();
                    throw throwable;
                }
                catch (XMLStreamException e) {
                    throw new JDOMException(e.getMessage(), (Throwable)e);
                }
            }
            xmlStreamReader.close();
            return document;
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static Element loadUsingStaX(@NotNull Reader reader, @Nullable SafeJdomFactory factory) throws JDOMException, IOException {
        try {
            Element element;
            XMLStreamReader xmlStreamReader = JDOMUtil.getXmlInputFactory().createXMLStreamReader(reader);
            try {
                element = SafeStAXStreamBuilder.build(xmlStreamReader, true, factory == null ? SafeStAXStreamBuilder.FACTORY : factory);
            }
            catch (Throwable throwable) {
                try {
                    xmlStreamReader.close();
                    throw throwable;
                }
                catch (XMLStreamException e) {
                    throw new JDOMException(e.getMessage(), (Throwable)e);
                }
            }
            xmlStreamReader.close();
            return element;
        }
        finally {
            reader.close();
        }
    }

    @Deprecated
    @NotNull
    public static Document loadDocument(@NotNull CharSequence seq) throws IOException, JDOMException {
        return JDOMUtil.loadDocument(new CharSequenceReader(seq));
    }

    @NotNull
    public static Element load(@NotNull CharSequence seq) throws IOException, JDOMException {
        return JDOMUtil.load(new CharSequenceReader(seq));
    }

    @Deprecated
    @NotNull
    public static Document loadDocument(@NotNull Reader reader) throws IOException, JDOMException {
        return JDOMUtil.loadDocumentUsingStaX(reader);
    }

    @NotNull
    public static Document loadDocument(@NotNull File file) throws JDOMException, IOException {
        return JDOMUtil.loadDocumentUsingStaX(new InputStreamReader(CharsetToolkit.inputStreamSkippingBOM(new BufferedInputStream(new FileInputStream(file))), StandardCharsets.UTF_8));
    }

    @NotNull
    public static Element load(@NotNull File file) throws JDOMException, IOException {
        return JDOMUtil.load(file, null);
    }

    @NotNull
    public static Element load(@NotNull Path file) throws JDOMException, IOException {
        try {
            return JDOMUtil.loadUsingStaX(new InputStreamReader(CharsetToolkit.inputStreamSkippingBOM(new BufferedInputStream(Files.newInputStream(file, new OpenOption[0]))), StandardCharsets.UTF_8), null);
        }
        catch (ClosedFileSystemException e) {
            throw new IOException("Cannot read file from closed file system: " + file, e);
        }
    }

    @ApiStatus.Internal
    @NotNull
    public static Element load(@NotNull File file, @Nullable SafeJdomFactory factory) throws JDOMException, IOException {
        return JDOMUtil.loadUsingStaX(new InputStreamReader(CharsetToolkit.inputStreamSkippingBOM(new BufferedInputStream(new FileInputStream(file))), StandardCharsets.UTF_8), factory);
    }

    @ApiStatus.Internal
    @NotNull
    public static Element load(@NotNull Path file, @Nullable SafeJdomFactory factory) throws JDOMException, IOException {
        try {
            return JDOMUtil.loadUsingStaX(new InputStreamReader(CharsetToolkit.inputStreamSkippingBOM(new BufferedInputStream(Files.newInputStream(file, new OpenOption[0]))), StandardCharsets.UTF_8), factory);
        }
        catch (ClosedFileSystemException e) {
            throw new IOException("Cannot read file from closed file system: " + file, e);
        }
    }

    @Deprecated
    @NotNull
    public static Document loadDocument(@NotNull InputStream stream) throws JDOMException, IOException {
        return JDOMUtil.loadDocumentUsingStaX(new InputStreamReader(stream, StandardCharsets.UTF_8));
    }

    @Contract(value="null -> null; !null -> !null")
    public static Element load(Reader reader) throws JDOMException, IOException {
        return reader == null ? null : JDOMUtil.loadUsingStaX(reader, null);
    }

    @Contract(value="null -> null; !null -> !null")
    public static Element load(InputStream stream) throws JDOMException, IOException {
        return stream == null ? null : JDOMUtil.load(stream, null);
    }

    @ApiStatus.Internal
    @NotNull
    public static Element load(@NotNull InputStream stream, @Nullable SafeJdomFactory factory) throws JDOMException, IOException {
        return JDOMUtil.loadUsingStaX(new InputStreamReader(stream, StandardCharsets.UTF_8), factory);
    }

    @NotNull
    public static Element load(@NotNull Class<?> clazz, @NotNull String resource) throws JDOMException, IOException {
        InputStream stream = clazz.getResourceAsStream(resource);
        if (stream == null) {
            throw new FileNotFoundException(resource);
        }
        return JDOMUtil.load(stream);
    }

    @Deprecated
    @NotNull
    public static Document loadDocument(@NotNull URL url) throws JDOMException, IOException {
        return JDOMUtil.loadDocument(URLUtil.openStream(url));
    }

    @NotNull
    public static Element load(@NotNull URL url) throws JDOMException, IOException {
        return JDOMUtil.load(URLUtil.openStream(url));
    }

    @Deprecated
    @NotNull
    public static Document loadResourceDocument(@NotNull URL url) throws JDOMException, IOException {
        return JDOMUtil.loadDocument(URLUtil.openResourceStream(url));
    }

    @NotNull
    public static Element loadResource(@NotNull URL url) throws JDOMException, IOException {
        return JDOMUtil.load(URLUtil.openResourceStream(url));
    }

    public static void writeDocument(@NotNull Document document, @NotNull String filePath, String lineSeparator) throws IOException {
        try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(filePath));){
            JDOMUtil.writeDocument(document, stream, lineSeparator);
        }
    }

    public static void writeDocument(@NotNull Document document, @NotNull File file, String lineSeparator) throws IOException {
        JDOMUtil.write((Parent)document, file, lineSeparator);
    }

    public static void write(@NotNull Element element, @NotNull File file) throws IOException {
        JDOMUtil.write(element, file, "\n");
    }

    public static void write(@NotNull Element element, @NotNull File file, @Nullable String lineSeparator) throws IOException {
        FileUtil.createParentDirs(file);
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));){
            JDOMUtil.writeElement(element, (Writer)writer, JDOMUtil.createOutputter(lineSeparator));
        }
    }

    public static void write(@NotNull Element element, @NotNull Path file) throws IOException {
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);){
            JDOMUtil.writeElement(element, (Writer)writer, JDOMUtil.createOutputter("\n"));
        }
    }

    public static void write(@NotNull Parent element, @NotNull File file) throws IOException {
        JDOMUtil.write(element, file, "\n");
    }

    public static void write(@NotNull Parent element, @NotNull File file, @NotNull String lineSeparator) throws IOException {
        FileUtil.createParentDirs(file);
        try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(file));){
            JDOMUtil.write(element, stream, lineSeparator);
        }
    }

    public static void writeDocument(@NotNull Document document, @NotNull OutputStream stream, String lineSeparator) throws IOException {
        JDOMUtil.write((Parent)document, stream, lineSeparator);
    }

    public static void write(@NotNull Parent element, @NotNull OutputStream stream, @NotNull String lineSeparator) throws IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter(stream, StandardCharsets.UTF_8);){
            if (element instanceof Document) {
                JDOMUtil.writeDocument((Document)element, writer, lineSeparator);
            } else {
                JDOMUtil.writeElement((Element)element, (Writer)writer, lineSeparator);
            }
        }
    }

    @NotNull
    public static String writeDocument(@NotNull Document document, String lineSeparator) {
        try {
            StringWriter writer = new StringWriter();
            JDOMUtil.writeDocument(document, writer, lineSeparator);
            return writer.toString();
        }
        catch (IOException ignored) {
            return "";
        }
    }

    @NotNull
    public static String write(@NotNull Element element) {
        return JDOMUtil.writeElement(element);
    }

    @NotNull
    public static String write(@NotNull Parent element, String lineSeparator) {
        try {
            StringWriter writer = new StringWriter();
            JDOMUtil.write(element, writer, lineSeparator);
            return writer.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void write(Parent element, Writer writer, String lineSeparator) throws IOException {
        if (element instanceof Element) {
            JDOMUtil.writeElement((Element)element, writer, lineSeparator);
        } else if (element instanceof Document) {
            JDOMUtil.writeDocument((Document)element, writer, lineSeparator);
        }
    }

    public static void writeElement(@NotNull Element element, Writer writer, String lineSeparator) throws IOException {
        JDOMUtil.writeElement(element, writer, JDOMUtil.createOutputter(lineSeparator));
    }

    public static void writeElement(@NotNull Element element, @NotNull Writer writer, @NotNull XMLOutputter xmlOutputter) throws IOException {
        try {
            xmlOutputter.output(element, writer);
        }
        catch (NullPointerException ex) {
            JDOMUtil.getLogger().error(ex);
            JDOMUtil.printDiagnostics(element, "");
        }
    }

    @NotNull
    public static String writeElement(@NotNull Element element) {
        return JDOMUtil.writeElement(element, "\n");
    }

    @NotNull
    public static String writeElement(@NotNull Element element, String lineSeparator) {
        try {
            StringWriter writer = new StringWriter();
            JDOMUtil.writeElement(element, (Writer)writer, lineSeparator);
            return writer.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public static String writeChildren(@NotNull Element element, @NotNull String lineSeparator) throws IOException {
        StringWriter writer = new StringWriter();
        for (Element child : element.getChildren()) {
            JDOMUtil.writeElement(child, (Writer)writer, lineSeparator);
            writer.append(lineSeparator);
        }
        return writer.toString();
    }

    public static void writeDocument(@NotNull Document document, @NotNull Writer writer, String lineSeparator) throws IOException {
        XMLOutputter xmlOutputter = JDOMUtil.createOutputter(lineSeparator);
        try {
            xmlOutputter.output(document, writer);
        }
        catch (NullPointerException ex) {
            JDOMUtil.getLogger().error(ex);
            JDOMUtil.printDiagnostics(document.getRootElement(), "");
        }
    }

    @NotNull
    public static Format createFormat(@Nullable String lineSeparator) {
        return Format.getCompactFormat().setIndent("  ").setTextMode(Format.TextMode.TRIM).setEncoding("UTF-8").setOmitEncoding(false).setOmitDeclaration(false).setLineSeparator(lineSeparator);
    }

    @NotNull
    public static XMLOutputter createOutputter(String lineSeparator) {
        return new MyXMLOutputter(JDOMUtil.createFormat(lineSeparator));
    }

    @Nullable
    private static String escapeChar(char c, boolean escapeApostrophes, boolean escapeSpaces, boolean escapeLineEnds) {
        switch (c) {
            case '\n': {
                return escapeLineEnds ? "&#10;" : null;
            }
            case '\r': {
                return escapeLineEnds ? "&#13;" : null;
            }
            case '\t': {
                return escapeLineEnds ? "&#9;" : null;
            }
            case ' ': {
                return escapeSpaces ? "&#20" : null;
            }
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
            case '\"': {
                return "&quot;";
            }
            case '\'': {
                return escapeApostrophes ? "&apos;" : null;
            }
            case '&': {
                return "&amp;";
            }
        }
        return null;
    }

    @NotNull
    public static String escapeText(@NotNull String text) {
        return JDOMUtil.escapeText(text, false, false);
    }

    @NotNull
    public static String escapeText(@NotNull String text, boolean escapeSpaces, boolean escapeLineEnds) {
        return JDOMUtil.escapeText(text, false, escapeSpaces, escapeLineEnds);
    }

    @NotNull
    public static String escapeText(@NotNull String text, boolean escapeApostrophes, boolean escapeSpaces, boolean escapeLineEnds) {
        StringBuilder buffer = null;
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            String quotation = JDOMUtil.escapeChar(ch, escapeApostrophes, escapeSpaces, escapeLineEnds);
            buffer = XmlStringUtil.appendEscapedSymbol(text, buffer, i, quotation, ch);
        }
        return buffer == null ? text : buffer.toString();
    }

    private static void printDiagnostics(@NotNull Element element, String prefix) {
        ElementInfo info = JDOMUtil.getElementInfo(element);
        prefix = prefix + "/" + info.name;
        if (info.hasNullAttributes) {
            System.err.println(prefix);
        }
        for (Element child : element.getChildren()) {
            JDOMUtil.printDiagnostics(child, prefix);
        }
    }

    @NotNull
    private static ElementInfo getElementInfo(@NotNull Element element) {
        boolean hasNullAttributes = false;
        StringBuilder buf = new StringBuilder(element.getName());
        List<Attribute> attributes = JDOMUtil.getAttributes(element);
        int length = attributes.size();
        if (length > 0) {
            buf.append("[");
            for (int idx = 0; idx < length; ++idx) {
                Attribute attr = attributes.get(idx);
                if (idx != 0) {
                    buf.append(";");
                }
                buf.append(attr.getName());
                buf.append("=");
                buf.append(attr.getValue());
                if (attr.getValue() != null) continue;
                hasNullAttributes = true;
            }
            buf.append("]");
        }
        return new ElementInfo(buf, hasNullAttributes);
    }

    public static void updateFileSet(File @NotNull [] oldFiles, String @NotNull [] newFilePaths, Document @NotNull [] newFileDocuments, String lineSeparator) throws IOException {
        JDOMUtil.getLogger().assertTrue(newFilePaths.length == newFileDocuments.length);
        for (String newFilePath : newFilePaths) {
            File file = new File(newFilePath);
            if (!file.exists() || file.canWrite()) continue;
            throw new IOException("File \"" + newFilePath + "\" is not writeable");
        }
        for (File file : oldFiles) {
            if (!file.exists() || file.canWrite()) continue;
            throw new IOException("File \"" + file.getAbsolutePath() + "\" is not writeable");
        }
        ArrayList<String> writtenFilesPaths = new ArrayList<String>();
        for (int i = 0; i < newFilePaths.length; ++i) {
            String newFilePath = newFilePaths[i];
            JDOMUtil.writeDocument(newFileDocuments[i], newFilePath, lineSeparator);
            writtenFilesPaths.add(newFilePath);
        }
        block3: for (File oldFile : oldFiles) {
            String oldFilePath = oldFile.getAbsolutePath();
            for (String writtenFilesPath : writtenFilesPaths) {
                if (!oldFilePath.equals(writtenFilesPath)) continue;
                continue block3;
            }
            boolean result = oldFile.delete();
            if (result) continue;
            throw new IOException("File \"" + oldFilePath + "\" was not deleted");
        }
    }

    public static String getValue(Object node) {
        if (node instanceof Content) {
            Content content = (Content)node;
            return content.getValue();
        }
        if (node instanceof Attribute) {
            Attribute attribute = (Attribute)node;
            return attribute.getValue();
        }
        throw new IllegalArgumentException("Wrong node: " + node);
    }

    public static boolean isEmpty(@Nullable Element element) {
        return element == null || !element.hasAttributes() && element.getContent().isEmpty();
    }

    public static boolean isEmpty(@Nullable Element element, int attributeCount) {
        return element == null || JDOMUtil.getAttributes(element).size() == attributeCount && element.getContent().isEmpty();
    }

    @NotNull
    public static List<Attribute> getAttributes(@NotNull Element e) {
        return e.hasAttributes() ? e.getAttributes() : Collections.emptyList();
    }

    @Contract(value="_, !null -> !null; !null, _ -> !null")
    @Nullable
    public static Element merge(@Nullable Element to, @Nullable Element from) {
        if (from == null) {
            return to;
        }
        if (to == null) {
            return from;
        }
        Iterator<Object> iterator = from.getChildren().iterator();
        while (iterator.hasNext()) {
            Element configuration = (Element)iterator.next();
            iterator.remove();
            to.addContent(configuration);
        }
        iterator = JDOMUtil.getAttributes(from).iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            iterator.remove();
            to.setAttribute(attribute);
        }
        return to;
    }

    @NotNull
    public static Element deepMerge(@NotNull Element to, @NotNull Element from) {
        Iterator<Object> iterator = from.getChildren().iterator();
        while (iterator.hasNext()) {
            Element child = (Element)iterator.next();
            iterator.remove();
            Element existingChild = to.getChild(child.getName());
            if (existingChild != null && JDOMUtil.isEmpty(existingChild)) {
                to.removeChild(child.getName());
                existingChild = null;
            }
            if (existingChild == null || existingChild.getChildren().isEmpty() || !JDOMUtil.isAttributesEqual(JDOMUtil.getAttributes(existingChild), JDOMUtil.getAttributes(child), false)) {
                to.addContent(child);
                continue;
            }
            JDOMUtil.deepMerge(existingChild, child);
        }
        iterator = JDOMUtil.getAttributes(from).iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            iterator.remove();
            to.setAttribute(attribute);
        }
        return to;
    }

    @Nullable
    public static Element reduceChildren(@NotNull String name, @NotNull Element parent) {
        List children = parent.getChildren(name);
        Iterator it = children.iterator();
        if (!it.hasNext()) {
            return null;
        }
        Element accumulator = (Element)it.next();
        while (it.hasNext()) {
            JDOMUtil.merge(accumulator, (Element)it.next());
            it.remove();
        }
        return accumulator;
    }

    @NotNull
    public static Element internElement(@NotNull Element element) {
        return JDOMInterner.INSTANCE.internElement(element);
    }

    @NotNull
    public static String removeControlChars(@NotNull String text) {
        StringBuilder result = null;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (!Verifier.isXMLCharacter((int)c)) {
                if (result != null) continue;
                result = new StringBuilder(text.length());
                result.append(text, 0, i);
                continue;
            }
            if (result == null) continue;
            result.append(c);
        }
        return result == null ? text : result.toString();
    }

    @Nullable
    public static Point getLocation(@Nullable Element element) {
        return element == null ? null : JDOMUtil.getLocation(element, X, Y);
    }

    @Nullable
    public static Point getLocation(@NotNull Element element, @NotNull String x, @NotNull String y) {
        String sX = element.getAttributeValue(x);
        if (sX == null) {
            return null;
        }
        String sY = element.getAttributeValue(y);
        if (sY == null) {
            return null;
        }
        try {
            return new Point(Integer.parseInt(sX), Integer.parseInt(sY));
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    @NotNull
    public static Element setLocation(@NotNull Element element, @NotNull Point location) {
        return JDOMUtil.setLocation(element, X, Y, location);
    }

    @NotNull
    public static Element setLocation(@NotNull Element element, @NotNull String x, @NotNull String y, @NotNull Point location) {
        return element.setAttribute(x, Integer.toString(location.x)).setAttribute(y, Integer.toString(location.y));
    }

    @Nullable
    public static Dimension getSize(@Nullable Element element) {
        return element == null ? null : JDOMUtil.getSize(element, WIDTH, HEIGHT);
    }

    @Nullable
    public static Dimension getSize(@NotNull Element element, @NotNull String width, @NotNull String height) {
        String sWidth = element.getAttributeValue(width);
        if (sWidth == null) {
            return null;
        }
        String sHeight = element.getAttributeValue(height);
        if (sHeight == null) {
            return null;
        }
        try {
            int iWidth = Integer.parseInt(sWidth);
            if (iWidth <= 0) {
                return null;
            }
            int iHeight = Integer.parseInt(sHeight);
            if (iHeight <= 0) {
                return null;
            }
            return new Dimension(iWidth, iHeight);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    @NotNull
    public static Element setSize(@NotNull Element element, @NotNull Dimension size) {
        return JDOMUtil.setSize(element, WIDTH, HEIGHT, size);
    }

    @NotNull
    public static Element setSize(@NotNull Element element, @NotNull String width, @NotNull String height, @NotNull Dimension size) {
        return element.setAttribute(width, Integer.toString(size.width)).setAttribute(height, Integer.toString(size.height));
    }

    @Nullable
    public static Rectangle getBounds(@Nullable Element element) {
        return element == null ? null : JDOMUtil.getBounds(element, X, Y, WIDTH, HEIGHT);
    }

    @Nullable
    public static Rectangle getBounds(@NotNull Element element, @NotNull String x, @NotNull String y, @NotNull String width, @NotNull String height) {
        String sX = element.getAttributeValue(x);
        if (sX == null) {
            return null;
        }
        String sY = element.getAttributeValue(y);
        if (sY == null) {
            return null;
        }
        String sWidth = element.getAttributeValue(width);
        if (sWidth == null) {
            return null;
        }
        String sHeight = element.getAttributeValue(height);
        if (sHeight == null) {
            return null;
        }
        try {
            int iWidth = Integer.parseInt(sWidth);
            if (iWidth <= 0) {
                return null;
            }
            int iHeight = Integer.parseInt(sHeight);
            if (iHeight <= 0) {
                return null;
            }
            return new Rectangle(Integer.parseInt(sX), Integer.parseInt(sY), iWidth, iHeight);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    @NotNull
    public static Element setBounds(@NotNull Element element, @NotNull Rectangle bounds) {
        return JDOMUtil.setBounds(element, X, Y, WIDTH, HEIGHT, bounds);
    }

    @NotNull
    public static Element setBounds(@NotNull Element element, @NotNull String x, @NotNull String y, @NotNull String width, @NotNull String height, @NotNull Rectangle bounds) {
        return element.setAttribute(x, Integer.toString(bounds.x)).setAttribute(y, Integer.toString(bounds.y)).setAttribute(width, Integer.toString(bounds.width)).setAttribute(height, Integer.toString(bounds.height));
    }

    public static void copyMissingContent(@NotNull Element source, @NotNull Element target) {
        Element targetClone = target.clone();
        for (Attribute attribute : source.getAttributes()) {
            if (JDOMUtil.hasAttribute(targetClone, attribute.getName())) continue;
            target.setAttribute(attribute.clone());
        }
        for (Content content : source.getContent()) {
            if (JDOMUtil.hasContent(targetClone, content)) continue;
            target.addContent(content.clone());
        }
    }

    private static boolean hasAttribute(@NotNull Element element, @NotNull String name) {
        return element.getAttribute(name) != null;
    }

    private static boolean hasContent(@NotNull Element element, @NotNull Content content) {
        if (content instanceof Element) {
            return !element.getChildren(((Element)content).getName()).isEmpty();
        }
        return false;
    }

    static {
        CONTENT_FILTER = new EmptyTextFilter();
    }

    private static class ElementInfo {
        @NotNull
        final CharSequence name;
        final boolean hasNullAttributes;

        private ElementInfo(@NotNull CharSequence name, boolean attributes) {
            this.name = name;
            this.hasNullAttributes = attributes;
        }
    }

    public static interface ElementOutputFilter {
        public boolean accept(@NotNull Element var1, int var2);
    }

    private static final class MyXMLOutputter
    extends XMLOutputter {
        MyXMLOutputter(@NotNull Format format) {
            super(format);
        }

        @NotNull
        public String escapeAttributeEntities(@NotNull String str) {
            return JDOMUtil.escapeText(str, false, true);
        }

        @NotNull
        public String escapeElementEntities(@NotNull String str) {
            return JDOMUtil.escapeText(str, false, false);
        }
    }

    private static final class EmptyTextFilter
    implements Filter<Content> {
        private EmptyTextFilter() {
        }

        public boolean matches(Object obj) {
            return !(obj instanceof Text) || !CharArrayUtil.containsOnlyWhiteSpaces(((Text)obj).getText());
        }
    }

    private static class LoggerHolder {
        private static final Logger ourLogger = Logger.getInstance(JDOMUtil.class);

        private LoggerHolder() {
        }
    }
}

