/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.rmi;

import com.intellij.execution.rmi.RemoteDeadHand;
import com.intellij.execution.rmi.ssl.SslKeyStore;
import com.intellij.execution.rmi.ssl.SslSocketFactory;
import com.intellij.execution.rmi.ssl.SslTrustStore;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.Remote;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.ExportException;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.security.Security;
import java.util.Hashtable;
import java.util.Random;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteServer {
    public static final String SERVER_HOSTNAME = "java.rmi.server.hostname";
    private static Remote ourRemote;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void start(Remote remote) throws Exception {
        Registry registry;
        int port;
        RemoteServer.setupRMI();
        RemoteServer.banJNDI();
        RemoteServer.setupSSL();
        if (ourRemote != null) {
            throw new AssertionError((Object)"Already started");
        }
        ourRemote = remote;
        Random random = new Random();
        while (true) {
            if ((port = random.nextInt(65535)) < 4000) {
                continue;
            }
            try {
                registry = LocateRegistry.createRegistry(port);
            }
            catch (ExportException exportException) {
                continue;
            }
            break;
        }
        try {
            Remote stub = UnicastRemoteObject.exportObject(ourRemote, 0);
            String name = remote.getClass().getSimpleName() + Integer.toHexString(stub.hashCode());
            registry.bind(name, stub);
            String id = port + "/" + name;
            System.out.println("Port/ID: " + id);
            long waitTime = 20000L;
            Object lock = new Object();
            while (true) {
                Object object = lock;
                synchronized (object) {
                    lock.wait(waitTime);
                }
                RemoteDeadHand deadHand = (RemoteDeadHand)registry.lookup("_DEAD_HAND_");
                waitTime = deadHand.ping(id);
            }
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            System.exit(1);
            return;
        }
    }

    public static void setupRMI() {
        if (System.getProperty(SERVER_HOSTNAME) == null) {
            System.setProperty(SERVER_HOSTNAME, RemoteServer.getLoopbackAddress());
        }
        System.setProperty("java.rmi.server.disableHttp", "true");
        if (RMISocketFactory.getSocketFactory() != null) {
            return;
        }
        try {
            RMISocketFactory.setSocketFactory(new RMISocketFactory(){
                final InetAddress loopbackAddress = InetAddress.getByName(RemoteServer.access$000());

                @Override
                public Socket createSocket(String host, int port) throws IOException {
                    return new Socket(host, port);
                }

                @Override
                public ServerSocket createServerSocket(int port) throws IOException {
                    return new ServerSocket(port, 0, this.loopbackAddress);
                }
            });
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static void banJNDI() {
        if (System.getProperty("java.naming.factory.initial") == null) {
            System.setProperty("java.naming.factory.initial", "com.intellij.execution.rmi.RemoteServer$Jndi");
        }
    }

    private static void setupSSL() {
        boolean caCert = System.getProperty("sslCaCertPath") != null;
        boolean clientCert = System.getProperty("sslClientCertPath") != null;
        boolean clientKey = System.getProperty("sslClientKeyPath") != null;
        boolean useFactory = "true".equals(System.getProperty("sslUseFactory"));
        if (useFactory) {
            if (caCert || clientCert && clientKey) {
                Security.setProperty("ssl.SocketFactory.provider", SslSocketFactory.class.getName());
            }
        } else {
            if (caCert) {
                SslTrustStore.setDefault();
            }
            if (clientCert && clientKey) {
                SslKeyStore.setDefault();
            }
        }
    }

    @NotNull
    private static String getLoopbackAddress() {
        boolean ipv6 = false;
        try {
            ipv6 = InetAddress.getByName(null) instanceof Inet6Address;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ipv6 ? "::1" : "127.0.0.1";
    }

    static /* synthetic */ String access$000() {
        return RemoteServer.getLoopbackAddress();
    }

    static {
        System.setProperty("apple.awt.UIElement", "true");
    }

    public static class Jndi
    implements InitialContextFactory,
    InvocationHandler {
        @Override
        @NotNull
        public Context getInitialContext(Hashtable<?, ?> environment) {
            return (Context)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Context.class}, (InvocationHandler)this);
        }

        @Override
        @Nullable
        public Object invoke(Object proxy, @NotNull Method method, Object[] args) throws Throwable {
            if (Object.class.equals(method.getDeclaringClass())) {
                return method.invoke((Object)this, args);
            }
            throw new NamingException("JNDI service is disabled");
        }
    }
}

