/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.util;

import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.util.SystemProperties;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public abstract class SaveFileListener
implements ActionListener {
    private final JPanel myContentPanel;
    private final TextFieldWithBrowseButton myTextField;
    private final String myDialogTitle;
    private final String myExtension;

    public SaveFileListener(JPanel contentPanel2, TextFieldWithBrowseButton textField, String dialogTitle, String extension) {
        this.myContentPanel = contentPanel2;
        this.myTextField = textField;
        this.myDialogTitle = dialogTitle;
        this.myExtension = extension;
    }

    @Nullable
    protected abstract String getDefaultLocation();

    @Override
    public void actionPerformed(ActionEvent e) {
        VirtualFileWrapper result2;
        File file2;
        String path2 = this.myTextField.getText().trim();
        if (path2.isEmpty()) {
            String defaultLocation = this.getDefaultLocation();
            String string = path2 = defaultLocation != null && !defaultLocation.isEmpty() ? defaultLocation : SystemProperties.getUserHome();
        }
        if (!(file2 = new File(path2)).exists()) {
            path2 = SystemProperties.getUserHome();
        }
        FileSaverDescriptor descriptor2 = new FileSaverDescriptor(this.myDialogTitle, "Save as *." + this.myExtension, new String[]{this.myExtension});
        FileSaverDialog saveFileDialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor2, (Component)this.myContentPanel);
        VirtualFile vf = LocalFileSystem.getInstance().findFileByIoFile(file2.exists() ? file2 : new File(path2));
        if (vf == null) {
            vf = VfsUtil.getUserHomeDir();
        }
        if ((result2 = saveFileDialog.save(vf, null)) == null || result2.getFile() == null) {
            return;
        }
        this.myTextField.setText(result2.getFile().getPath());
    }
}

