/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.sdk;

import com.android.SdkConstants;
import com.android.internal.util.Preconditions;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.OptionalLibrary;
import com.android.tools.idea.rendering.multi.CompatibilityRenderTarget;
import com.android.tools.idea.util.StudioPathManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StudioEmbeddedRenderTarget
implements IAndroidTarget {
    private static final Logger LOG = Logger.getInstance(StudioEmbeddedRenderTarget.class);
    private static final String ONLY_FOR_RENDERING_ERROR = "This target is only for rendering";
    private static final String FRAMEWORK_RES_JAR = "framework_res.jar";
    @Nullable
    private final String myBasePath = StudioEmbeddedRenderTarget.getEmbeddedLayoutLibPath();
    private static StudioEmbeddedRenderTarget ourStudioEmbeddedTarget;
    private static boolean ourDisableEmbeddedTargetForTesting;

    @VisibleForTesting
    public static void setDisableEmbeddedTarget(boolean value2) {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        ourDisableEmbeddedTargetForTesting = value2;
    }

    public static CompatibilityRenderTarget getCompatibilityTarget(@NotNull IAndroidTarget target) {
        if (ourDisableEmbeddedTargetForTesting) {
            return new CompatibilityRenderTarget(target, target.getVersion().getApiLevel(), target);
        }
        int api = target.getVersion().getApiLevel();
        if (target instanceof CompatibilityRenderTarget) {
            CompatibilityRenderTarget compatRenderTarget = (CompatibilityRenderTarget)target;
            target = compatRenderTarget.getRealTarget();
        }
        return new CompatibilityRenderTarget(StudioEmbeddedRenderTarget.getInstance(), api, target);
    }

    @VisibleForTesting
    public static StudioEmbeddedRenderTarget getInstance() {
        if (ourStudioEmbeddedTarget == null) {
            ourStudioEmbeddedTarget = new StudioEmbeddedRenderTarget();
        }
        return ourStudioEmbeddedTarget;
    }

    private StudioEmbeddedRenderTarget() {
    }

    @Nullable
    public static String getEmbeddedLayoutLibPath() {
        String homePath = FileUtil.toSystemIndependentName((String)PathManager.getHomePath());
        String[] paths = new String[]{FileUtil.join((String[])new String[]{homePath, "plugins/android/lib/layoutlib/"}), StudioPathManager.isRunningFromSources() ? FileUtil.join((String[])new String[]{StudioPathManager.getSourcesRoot(), "prebuilts/studio/layoutlib/"}) : null, FileUtil.join((String[])new String[]{homePath, "community/android/tools-base/layoutlib/"}), FileUtil.join((String[])new String[]{homePath, "android/tools-base/layoutlib/"})};
        StringBuilder notFoundPaths = new StringBuilder();
        for (String path2 : paths) {
            if (path2 == null) continue;
            VirtualFile root2 = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)path2));
            if (root2 != null) {
                File rootFile = VfsUtilCore.virtualToIoFile((VirtualFile)root2);
                if (!rootFile.exists() || !rootFile.isDirectory()) continue;
                LOG.debug("Embedded layoutlib found at " + path2);
                return rootFile.getAbsolutePath() + File.separator;
            }
            notFoundPaths.append(path2).append('\n');
        }
        LOG.error("Unable to find embedded layoutlib in paths:\n" + notFoundPaths.toString());
        return null;
    }

    @NotNull
    public String getLocation() {
        Preconditions.checkState((this.myBasePath != null ? 1 : 0) != 0, (String)"Embedded layoutlib not found");
        return this.myBasePath;
    }

    public String getVendor() {
        return "Android Open Source Project";
    }

    @NotNull
    public AndroidVersion getVersion() {
        throw new UnsupportedOperationException("This target can only be used as a CompatibilityRenderTarget delegate");
    }

    public String getVersionName() {
        throw new UnsupportedOperationException("This target can only be used as a CompatibilityRenderTarget delegate");
    }

    public int getRevision() {
        return 1;
    }

    public boolean isPlatform() {
        return true;
    }

    public IAndroidTarget getParent() {
        return null;
    }

    @NotNull
    public String getPath(int pathId) {
        switch (pathId) {
            case 7: {
                return this.getLocation() + SdkConstants.OS_PLATFORM_DATA_FOLDER;
            }
            case 11: {
                return this.getLocation() + SdkConstants.OS_PLATFORM_DATA_FOLDER + FRAMEWORK_RES_JAR;
            }
            case 12: {
                return this.getLocation() + SdkConstants.OS_PLATFORM_FONTS_FOLDER;
            }
        }
        assert (false) : this.getClass().getSimpleName() + " does not support path of type " + pathId;
        return this.getLocation();
    }

    public BuildToolInfo getBuildToolInfo() {
        return null;
    }

    @NotNull
    public List<String> getBootClasspath() {
        return ImmutableList.of((Object)this.getPath(1));
    }

    public boolean hasRenderingLibrary() {
        return true;
    }

    public String getName() {
        throw new UnsupportedOperationException(ONLY_FOR_RENDERING_ERROR);
    }

    public String getFullName() {
        return this.getName();
    }

    public String getClasspathName() {
        return this.getName();
    }

    public String getShortClasspathName() {
        return this.getName();
    }

    @NotNull
    public List<OptionalLibrary> getOptionalLibraries() {
        throw new UnsupportedOperationException(ONLY_FOR_RENDERING_ERROR);
    }

    @NotNull
    public List<OptionalLibrary> getAdditionalLibraries() {
        throw new UnsupportedOperationException(ONLY_FOR_RENDERING_ERROR);
    }

    @NotNull
    public File[] getSkins() {
        throw new UnsupportedOperationException(ONLY_FOR_RENDERING_ERROR);
    }

    @Nullable
    public File getDefaultSkin() {
        throw new UnsupportedOperationException(ONLY_FOR_RENDERING_ERROR);
    }

    public String[] getPlatformLibraries() {
        throw new UnsupportedOperationException(ONLY_FOR_RENDERING_ERROR);
    }

    public String getProperty(String name) {
        throw new UnsupportedOperationException(ONLY_FOR_RENDERING_ERROR);
    }

    public Map<String, String> getProperties() {
        throw new UnsupportedOperationException(ONLY_FOR_RENDERING_ERROR);
    }

    public boolean canRunOn(IAndroidTarget target) {
        throw new UnsupportedOperationException(ONLY_FOR_RENDERING_ERROR);
    }

    public String hashString() {
        return "studio-embedded-render-target";
    }

    public int compareTo(IAndroidTarget o) {
        throw new UnsupportedOperationException(ONLY_FOR_RENDERING_ERROR);
    }

    static {
        ourDisableEmbeddedTargetForTesting = false;
    }
}

