/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.resourceManagers;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourcesUtil;
import com.android.ide.common.resources.SingleNamespaceResourceRepository;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.attrs.AttributeDefinitionsImpl;
import org.jetbrains.android.dom.resources.Attr;
import org.jetbrains.android.dom.resources.DeclareStyleable;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.dom.resources.Resources;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.android.resourceManagers.FrameworkResourceManager;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalResourceManager
extends ResourceManager {
    private final AndroidFacet myFacet;
    private final Object myAttrDefsLock = new Object();
    private AttributeDefinitions myAttrDefs;

    @Nullable
    public static LocalResourceManager getInstance(@NotNull Module module2) {
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
        return facet2 != null ? ModuleResourceManagers.getInstance(facet2).getLocalResourceManager() : null;
    }

    @Nullable
    public static LocalResourceManager getInstance(@NotNull PsiElement element2) {
        AndroidFacet facet2 = AndroidFacet.getInstance((PsiElement)element2);
        return facet2 != null ? ModuleResourceManagers.getInstance(facet2).getLocalResourceManager() : null;
    }

    public LocalResourceManager(@NotNull AndroidFacet facet2) {
        super(facet2.getModule().getProject());
        this.myFacet = facet2;
    }

    public AndroidFacet getFacet() {
        return this.myFacet;
    }

    @Override
    public boolean isResourceDir(@NotNull VirtualFile dir) {
        for (VirtualFile resDir : ResourceFolderManager.getInstance(this.myFacet).getFolders()) {
            if (!dir.equals(resDir)) continue;
            return true;
        }
        for (VirtualFile resDir : AndroidRootUtil.getResourceOverlayDirs(this.myFacet)) {
            if (!dir.equals(resDir)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public AttributeDefinitions getAttributeDefinitions() {
        Object object = this.myAttrDefsLock;
        synchronized (object) {
            if (this.myAttrDefs == null) {
                FrameworkResourceManager frameworkResourceManager = ModuleResourceManagers.getInstance(this.myFacet).getFrameworkResourceManager();
                AttributeDefinitions frameworkAttributes = frameworkResourceManager == null ? null : ((ResourceManager)frameworkResourceManager).getAttributeDefinitions();
                this.myAttrDefs = AttributeDefinitionsImpl.create(frameworkAttributes, this.getResourceRepository());
            }
            return this.myAttrDefs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateAttributeDefinitions() {
        Object object = this.myAttrDefsLock;
        synchronized (object) {
            this.myAttrDefs = null;
        }
    }

    @NotNull
    public List<Attr> findAttrs(@NotNull ResourceNamespace namespace, @NotNull String name) {
        ArrayList<Attr> list = new ArrayList<Attr>();
        List<Resources> rootElements = this.loadPsiForFilesContainingResource(namespace, ResourceType.ATTR, name);
        for (Resources root2 : rootElements) {
            for (Attr attr : root2.getAttrs()) {
                ResourceReference resourceReference = (ResourceReference)attr.getName().getValue();
                if (resourceReference == null || !name.equals(resourceReference.getName())) continue;
                list.add(attr);
            }
            for (DeclareStyleable styleable : root2.getDeclareStyleables()) {
                for (Attr attr : styleable.getAttrs()) {
                    ResourceReference resourceReference = (ResourceReference)attr.getName().getValue();
                    if (resourceReference == null || !name.equals(resourceReference.getName())) continue;
                    list.add(attr);
                }
            }
        }
        return list;
    }

    public List<DeclareStyleable> findStyleables(@NotNull ResourceNamespace namespace, @NotNull String name) {
        ArrayList<DeclareStyleable> list = new ArrayList<DeclareStyleable>();
        List<Resources> rootElements = this.loadPsiForFilesContainingResource(namespace, ResourceType.STYLEABLE, name);
        for (Resources root2 : rootElements) {
            for (DeclareStyleable styleable : root2.getDeclareStyleables()) {
                if (!name.equals(styleable.getName().getValue())) continue;
                list.add(styleable);
            }
        }
        return list;
    }

    public List<Attr> findStyleableAttributesByFieldName(@NotNull ResourceNamespace namespace, @NotNull String fieldName) {
        int prev;
        int index2 = fieldName.lastIndexOf(95);
        while (index2 >= 0 && (prev = fieldName.lastIndexOf(95, index2 - 1)) != -1 && !Character.isUpperCase(fieldName.charAt(prev + 1))) {
            index2 = prev;
        }
        if (index2 < 0) {
            return Collections.emptyList();
        }
        String styleableName = fieldName.substring(0, index2);
        String attrName = fieldName.substring(index2 + 1);
        ArrayList<Attr> list = new ArrayList<Attr>();
        List<Resources> rootElements = this.loadPsiForFilesContainingResource(namespace, ResourceType.STYLEABLE, styleableName);
        for (Resources root2 : rootElements) {
            for (DeclareStyleable styleable : root2.getDeclareStyleables()) {
                if (!styleableName.equals(styleable.getName().getValue())) continue;
                for (Attr attr : styleable.getAttrs()) {
                    ResourceReference resourceReference = (ResourceReference)attr.getName().getValue();
                    if (resourceReference == null || !ResourcesUtil.resourceNameToFieldName((String)resourceReference.getQualifiedName()).equals(attrName) && !resourceReference.getName().equals(attrName)) continue;
                    list.add(attr);
                }
            }
        }
        return list;
    }

    @NotNull
    private List<Resources> loadPsiForFilesContainingResource(@NotNull ResourceNamespace namespace, @NotNull ResourceType resourceType, @NotNull String name) {
        return this.getResourceRepository().getResources(namespace, resourceType, name).stream().map(item -> IdeResourcesUtil.getSourceAsVirtualFile(item)).filter(file2 -> Objects.nonNull(file2)).distinct().map(file2 -> AndroidUtils.loadDomElement(this.myProject, file2, Resources.class)).filter(res -> Objects.nonNull(res)).collect(Collectors.toList());
    }

    @NotNull
    public List<PsiElement> findResourcesByField(@NotNull PsiField field2) {
        String type = IdeResourcesUtil.getResourceClassName(field2);
        if (type == null) {
            return Collections.emptyList();
        }
        String fieldName = field2.getName();
        if (fieldName == null) {
            return Collections.emptyList();
        }
        ResourceRepositoryManager repositoryManager = ResourceRepositoryManager.getInstance((PsiElement)field2);
        if (repositoryManager == null) {
            return Collections.emptyList();
        }
        ResourceNamespace namespace = repositoryManager.getNamespace();
        return this.findResourcesByFieldName(namespace, type, fieldName);
    }

    @NotNull
    public List<PsiElement> findResourcesByFieldName(@NotNull ResourceNamespace namespace, @NotNull String resClassName, @NotNull String fieldName) {
        ArrayList<PsiElement> targets;
        block7: {
            block6: {
                ResourceFolderType folderType;
                targets = new ArrayList<PsiElement>();
                if (resClassName.equals(ResourceType.ID.getName())) {
                    targets.addAll(this.findIdDeclarations(namespace, fieldName));
                }
                if ((folderType = ResourceFolderType.getTypeByName((String)resClassName)) != null) {
                    targets.addAll(this.findResourceFiles(namespace, folderType, fieldName, false, true));
                }
                for (ResourceElement element2 : this.findValueResources(namespace, resClassName, fieldName, false)) {
                    targets.add((PsiElement)element2.getName().getXmlAttributeValue());
                }
                if (!resClassName.equals(ResourceType.ATTR.getName())) break block6;
                for (Attr attr : this.findAttrs(namespace, fieldName)) {
                    targets.add((PsiElement)attr.getName().getXmlAttributeValue());
                }
                break block7;
            }
            if (!resClassName.equals(ResourceType.STYLEABLE.getName())) break block7;
            for (DeclareStyleable styleable : this.findStyleables(namespace, fieldName)) {
                targets.add((PsiElement)styleable.getName().getXmlAttributeValue());
            }
            for (Attr attr : this.findStyleableAttributesByFieldName(namespace, fieldName)) {
                targets.add((PsiElement)attr.getName().getXmlAttributeValue());
            }
        }
        return targets;
    }

    @NotNull
    public Collection<PsiFile> findResourceFiles(@NotNull ResourceNamespace namespace, @NotNull ResourceFolderType resourceFolderType) {
        return this.findResourceFiles(namespace, resourceFolderType, null, true, true);
    }

    @NotNull
    public Collection<PsiFile> findResourceFiles(@NotNull ResourceNamespace namespace, @NotNull ResourceFolderType resourceFolderType, @Nullable String nameToLookFor, boolean distinguishDelimitersInName, boolean withDependencies) {
        LinkedHashSet<PsiFile> result2 = new LinkedHashSet<PsiFile>();
        LocalResourceRepository repository = withDependencies ? ResourceRepositoryManager.getAppResources(this.myFacet) : ResourceRepositoryManager.getModuleResources(this.myFacet);
        Collection repositories = repository.getLeafResourceRepositories();
        if (resourceFolderType == ResourceFolderType.VALUES) {
            for (ResourceType resourceType : FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)resourceFolderType)) {
                this.findResourceFiles(repositories, namespace, resourceType, resourceFolderType, nameToLookFor, distinguishDelimitersInName, result2);
            }
        } else {
            ResourceType resourceType = FolderTypeRelationship.getNonIdRelatedResourceType((ResourceFolderType)resourceFolderType);
            this.findResourceFiles(repositories, namespace, resourceType, resourceFolderType, nameToLookFor, distinguishDelimitersInName, result2);
        }
        return result2;
    }

    private void findResourceFiles(@NotNull Collection<SingleNamespaceResourceRepository> repositories, @NotNull ResourceNamespace namespace, @NotNull ResourceType resourceType, @NotNull ResourceFolderType resourceFolderType, @Nullable String nameToLookFor, boolean distinguishDelimitersInName, @NotNull Set<PsiFile> result2) {
        for (ResourceRepository resourceRepository : repositories) {
            List items2;
            if (nameToLookFor == null) {
                Collection items22 = resourceRepository.getResources(namespace, resourceType).values();
            } else {
                items2 = distinguishDelimitersInName ? resourceRepository.getResources(namespace, resourceType, nameToLookFor) : resourceRepository.getResources(namespace, resourceType, item -> AndroidUtils.equal(nameToLookFor, item.getName(), false));
            }
            for (ResourceItem item2 : items2) {
                PsiFile file2;
                VirtualFile resFile = IdeResourcesUtil.getSourceAsVirtualFile(item2);
                if (resFile == null || ResourceFolderType.getFolderType((String)resFile.getParent().getName()) != resourceFolderType || (file2 = AndroidPsiUtils.getPsiFileSafely((Project)this.myProject, (VirtualFile)resFile)) == null) continue;
                result2.add(file2);
            }
        }
    }

    @Override
    @NotNull
    protected Collection<SingleNamespaceResourceRepository> getLeafResourceRepositories() {
        return this.getResourceRepository().getLeafResourceRepositories();
    }

    @Override
    @NotNull
    protected List<ResourceItem> getResources(@NotNull ResourceNamespace namespace, @NotNull ResourceType resourceType, @NotNull String resName) {
        return this.getResourceRepository().getResources(namespace, resourceType, resName);
    }

    @NotNull
    private ResourceRepository getResourceRepository() {
        return ResourceRepositoryManager.getAppResources(this.myFacet);
    }
}

