/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.repository.io.FileOpUtils;
import com.android.tools.idea.gradle.repositories.RepositoryUrlManager;
import com.android.tools.idea.projectsystem.GoogleMavenArtifactId;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.ui.GuiTestingService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.PathUtil;
import com.intellij.util.net.HttpConfigurable;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.jar.JarFile;
import org.jetbrains.android.refactoring.AppCompatStyleMigration;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppCompatPublicDotTxtLookup {
    private static final String BASE_URL = "https://maven.google.com/com/android/support/appcompat-v7/%1$s/appcompat-v7-%2$s.aar";
    private static final String ANDROIDX_BASE_URL = "https://maven.google.com/androidx/appcompat/appcompat/%1$s/appcompat-%2$s.aar";
    private static final Splitter PUBLIC_TXT_SPLITTER = Splitter.on((char)' ').trimResults();
    private static final String RELATIVE_URI_PATH = "com/android/support/appcompat-v7/%1$s/public.txt";
    private static final String ANDROIDX_RELATIVE_URI_PATH = "androidx/appcompat/appcompat/%1$s/public.txt";
    private static final String RELATIVE_FILE_PATH = "com/android/support/appcompat-v7/%1$s/public.txt".replace('/', File.separatorChar);
    private static final String ANDROIDX_RELATIVE_FILE_PATH = "androidx/appcompat/appcompat/%1$s/public.txt".replace('/', File.separatorChar);

    static AppCompatPublicDotTxtLookup getInstance() {
        return LookupCreator.INSTANCE;
    }

    @VisibleForTesting
    AppCompatPublicDotTxtLookup() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    AppCompatStyleMigration createAppCompatStyleMigration(@NotNull GoogleMavenArtifactId artifactId, @NotNull String appCompatVersion) {
        HashSet attrSet = Sets.newHashSetWithExpectedSize((int)250);
        HashSet styleSet = Sets.newHashSetWithExpectedSize((int)200);
        try (BufferedReader reader = this.findAppCompatPublicTxt(artifactId, appCompatVersion);){
            String line2;
            while ((line2 = reader.readLine()) != null) {
                List splitList = PUBLIC_TXT_SPLITTER.splitToList((CharSequence)line2);
                if (splitList.size() != 2) continue;
                String key = (String)splitList.get(0);
                String value2 = (String)splitList.get(1);
                if ("attr".equals(key)) {
                    attrSet.add(value2);
                    continue;
                }
                if (!"style".equals(key)) continue;
                if (value2.contains("_")) {
                    value2 = value2.replace('_', '.');
                }
                styleSet.add(value2);
            }
            AppCompatStyleMigration appCompatStyleMigration = new AppCompatStyleMigration(attrSet, styleSet);
            return appCompatStyleMigration;
        }
        catch (IOException e) {
            Logger.getInstance(AppCompatPublicDotTxtLookup.class).warn((Throwable)e);
            return new AppCompatStyleMigration(Collections.emptySet(), Collections.emptySet());
        }
    }

    private File getCacheDir() {
        if (ApplicationManager.getApplication().isUnitTestMode() || GuiTestingService.getInstance().isGuiTestingMode()) {
            return null;
        }
        return new File(PathUtil.getCanonicalPath((String)PathManager.getSystemPath()), "maven.google");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static JarFile findRemoteAppCompatAar(@NotNull GoogleMavenArtifactId artifactId, @NotNull String appCompatVersion) throws IOException {
        JarFile jarFile;
        URLConnection ucon = null;
        BufferedInputStream is = null;
        try {
            String url = String.format(artifactId.isAndroidxLibrary() ? ANDROIDX_BASE_URL : BASE_URL, appCompatVersion, appCompatVersion);
            ucon = HttpConfigurable.getInstance().openConnection(url);
            is = new BufferedInputStream(ucon.getInputStream());
            Path tmpPath = Files.createTempFile("aar_appcompat_cache", null, new FileAttribute[0]);
            tmpPath.toFile().deleteOnExit();
            Files.copy(is, tmpPath, StandardCopyOption.REPLACE_EXISTING);
            jarFile = new JarFile(tmpPath.toFile());
        }
        catch (Throwable throwable) {
            Closeables.closeQuietly(is);
            if (ucon instanceof HttpURLConnection) {
                ((HttpURLConnection)ucon).disconnect();
            }
            throw throwable;
        }
        Closeables.closeQuietly((InputStream)is);
        if (ucon instanceof HttpURLConnection) {
            ((HttpURLConnection)ucon).disconnect();
        }
        return jarFile;
    }

    @Nullable
    private static JarFile findLocalAppCompatAar(@NotNull GoogleMavenArtifactId artifactId, @NotNull String appCompatVersion) throws IOException {
        AndroidSdkData sdkData = AndroidSdks.getInstance().tryToChooseAndroidSdk();
        if (sdkData == null) {
            return null;
        }
        GradleCoordinate coordinate = artifactId.getCoordinate(appCompatVersion);
        File appCompatAarFile = RepositoryUrlManager.get().getArchiveForCoordinate(coordinate, sdkData.getLocation(), FileOpUtils.create());
        if (appCompatAarFile == null || !appCompatAarFile.exists()) {
            return null;
        }
        return new JarFile(appCompatAarFile);
    }

    /*
     * Loose catch block
     */
    private static byte[] findEntryRemote(@NotNull GoogleMavenArtifactId artifactId, @NotNull String appCompatVersion) throws IOException {
        JarFile jarFile = AppCompatPublicDotTxtLookup.findLocalAppCompatAar(artifactId, appCompatVersion);
        if (jarFile == null) {
            jarFile = AppCompatPublicDotTxtLookup.findRemoteAppCompatAar(artifactId, appCompatVersion);
        }
        try {
            try (InputStream is = jarFile.getInputStream(jarFile.getEntry("public.txt"));){
                byte[] byArray = ByteStreams.toByteArray((InputStream)is);
                return byArray;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            jarFile.close();
        }
    }

    @NotNull
    private synchronized BufferedReader findAppCompatPublicTxt(@NotNull GoogleMavenArtifactId artifactId, @NotNull String appCompatVersion) throws IOException {
        if (this.getCacheDir() != null) {
            File file2 = new File(this.getCacheDir(), String.format(artifactId.isAndroidxLibrary() ? ANDROIDX_RELATIVE_FILE_PATH : RELATIVE_FILE_PATH, appCompatVersion));
            if (file2.exists()) {
                return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file2), StandardCharsets.UTF_8));
            }
            try {
                byte[] bytes = AppCompatPublicDotTxtLookup.findEntryRemote(artifactId, appCompatVersion);
                ByteArrayInputStream in = new ByteArrayInputStream(bytes);
                if (file2.getParentFile().mkdirs()) {
                    in.mark(Integer.MAX_VALUE);
                    Files.copy(in, file2.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    in.reset();
                }
                return new BufferedReader(new InputStreamReader((InputStream)in, StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                Logger.getInstance(AppCompatPublicDotTxtLookup.class).warn((Throwable)e);
                return AppCompatPublicDotTxtLookup.getPublicTxtAsResource();
            }
        }
        return AppCompatPublicDotTxtLookup.getPublicTxtAsResource();
    }

    @NotNull
    private static BufferedReader getPublicTxtAsResource() {
        InputStream is = AppCompatPublicDotTxtLookup.class.getResourceAsStream("/migrateToAppCompat/public.txt");
        if (is == null) {
            throw new AssertionError((Object)"Missing resource migrateToAppCompat/public.txt");
        }
        return new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
    }

    private static final class LookupCreator {
        static final AppCompatPublicDotTxtLookup INSTANCE = new AppCompatPublicDotTxtLookup();

        private LookupCreator() {
        }
    }
}

