/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AndroidBaseXmlRefactoringAction
extends BaseRefactoringAction {
    AndroidBaseXmlRefactoringAction() {
    }

    protected boolean isAvailableOnElementInEditorAndFile(@NotNull PsiElement element2, @NotNull Editor editor2, @NotNull PsiFile file2, @NotNull DataContext context) {
        XmlTag[] tags2 = AndroidBaseXmlRefactoringAction.getXmlTagsFromExternalContext(context);
        if (tags2.length > 0) {
            return AndroidFacet.getInstance((PsiElement)tags2[0]) != null && this.isEnabledForTags(tags2);
        }
        TextRange range = AndroidBaseXmlRefactoringAction.getNonEmptySelectionRange(editor2);
        if (range != null) {
            Pair<PsiElement, PsiElement> psiRange = AndroidBaseXmlRefactoringAction.getExtractableRange(file2, range.getStartOffset(), range.getEndOffset());
            return psiRange != null && this.isEnabledForPsiRange((PsiElement)psiRange.getFirst(), (PsiElement)psiRange.getSecond());
        }
        if (element2 == null || AndroidFacet.getInstance((PsiElement)element2) == null || PsiTreeUtil.getParentOfType((PsiElement)element2, XmlText.class) != null) {
            return false;
        }
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element2, XmlTag.class);
        return tag != null && this.isEnabledForTags(new XmlTag[]{tag});
    }

    @Nullable
    private static TextRange getNonEmptySelectionRange(Editor editor2) {
        int end;
        int start2;
        SelectionModel model2;
        if (editor2 != null && (model2 = editor2.getSelectionModel()).hasSelection() && (start2 = model2.getSelectionStart()) < (end = model2.getSelectionEnd())) {
            return TextRange.create((int)start2, (int)end);
        }
        return null;
    }

    @Nullable
    private static Pair<PsiElement, PsiElement> getExtractableRange(PsiFile file2, int start2, int end) {
        PsiElement e;
        PsiElement parent;
        PsiElement startElement = file2.findElementAt(start2);
        PsiElement psiElement = parent = startElement != null ? startElement.getParent() : null;
        while (parent != null && !(parent instanceof PsiFile) && parent.getTextRange().getStartOffset() == startElement.getTextRange().getStartOffset()) {
            startElement = parent;
            parent = parent.getParent();
        }
        PsiElement endElement = file2.findElementAt(end - 1);
        PsiElement psiElement2 = parent = endElement != null ? endElement.getParent() : null;
        while (parent != null && !(parent instanceof PsiFile) && parent.getTextRange().getEndOffset() == endElement.getTextRange().getEndOffset()) {
            endElement = parent;
            parent = parent.getParent();
        }
        if (startElement == null || endElement == null) {
            return null;
        }
        PsiElement commonParent = startElement.getParent();
        if (commonParent == null || !(commonParent instanceof XmlTag) || commonParent != endElement.getParent()) {
            return null;
        }
        boolean containTag = false;
        for (e = startElement; e != null; e = e.getNextSibling()) {
            if (!(e instanceof XmlText || e instanceof XmlTag || e instanceof PsiWhiteSpace || e instanceof PsiComment)) {
                return null;
            }
            if (e instanceof XmlTag) {
                containTag = true;
            }
            if (e == endElement) break;
        }
        return e != null && containTag ? Pair.create((Object)startElement, (Object)endElement) : null;
    }

    protected boolean isEnabledOnElements(@NotNull PsiElement[] elements) {
        if (elements.length == 0) {
            return false;
        }
        PsiElement element2 = elements[0];
        if (AndroidFacet.getInstance((PsiElement)element2) == null) {
            return false;
        }
        XmlTag[] tags2 = new XmlTag[elements.length];
        for (int i2 = 0; i2 < tags2.length; ++i2) {
            if (!(elements[i2] instanceof XmlTag)) {
                return false;
            }
            tags2[i2] = (XmlTag)elements[i2];
        }
        return this.isEnabledForTags(tags2);
    }

    protected abstract boolean isEnabledForTags(@NotNull XmlTag[] var1);

    protected boolean isEnabledForPsiRange(@NotNull PsiElement from, @Nullable PsiElement to) {
        return false;
    }

    protected boolean isAvailableForLanguage(Language language) {
        return language == XMLLanguage.INSTANCE;
    }

    protected boolean isAvailableForFile(PsiFile file2) {
        return file2 instanceof XmlFile && AndroidFacet.getInstance((PsiElement)file2) != null && this.isMyFile(file2);
    }

    protected abstract boolean isMyFile(PsiFile var1);

    public void update(@NotNull AnActionEvent e) {
        final DataContext context = e.getDataContext();
        DataContext patchedContext = new DataContext(){

            public Object getData(@NotNull @NonNls String dataId) {
                Object data = context.getData(dataId);
                if (data != null) {
                    return data;
                }
                if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
                    XmlTag[] tags2 = AndroidBaseXmlRefactoringAction.getXmlTagsFromExternalContext(context);
                    return tags2.length == 1 ? tags2[0] : null;
                }
                if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
                    return AndroidBaseXmlRefactoringAction.getXmlTagsFromExternalContext(context);
                }
                return null;
            }
        };
        super.update(new AnActionEvent(e.getInputEvent(), patchedContext, e.getPlace(), e.getPresentation(), e.getActionManager(), e.getModifiers()));
    }

    protected abstract void doRefactorForTags(@NotNull Project var1, @NotNull XmlTag[] var2);

    protected void doRefactorForPsiRange(@NotNull Project project, @NotNull PsiFile file2, @NotNull PsiElement from, @NotNull PsiElement to) {
    }

    protected RefactoringActionHandler getHandler(@NotNull DataContext dataContext) {
        XmlTag[] componentTags = AndroidBaseXmlRefactoringAction.getXmlTagsFromExternalContext(dataContext);
        return new MyHandler(componentTags);
    }

    protected boolean isAvailableInEditorOnly() {
        return false;
    }

    @NotNull
    protected static XmlTag[] getXmlTagsFromExternalContext(DataContext dataContext) {
        PsiElement[] data = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext);
        if (data instanceof XmlTag[]) {
            return (XmlTag[])data;
        }
        return XmlTag.EMPTY;
    }

    private class MyHandler
    implements RefactoringActionHandler {
        private final XmlTag[] myTagsFromExternalContext;

        private MyHandler(XmlTag[] tagsFromExternalContext) {
            this.myTagsFromExternalContext = tagsFromExternalContext;
        }

        public void invoke(@NotNull Project project, Editor editor2, PsiFile file2, DataContext dataContext) {
            if (this.myTagsFromExternalContext.length > 0) {
                AndroidBaseXmlRefactoringAction.this.doRefactorForTags(project, this.myTagsFromExternalContext);
                return;
            }
            TextRange range = AndroidBaseXmlRefactoringAction.getNonEmptySelectionRange(editor2);
            if (range != null) {
                Pair psiRange = AndroidBaseXmlRefactoringAction.getExtractableRange(file2, range.getStartOffset(), range.getEndOffset());
                if (psiRange != null) {
                    AndroidBaseXmlRefactoringAction.this.doRefactorForPsiRange(project, file2, (PsiElement)psiRange.getFirst(), (PsiElement)psiRange.getSecond());
                }
                return;
            }
            PsiElement element2 = BaseRefactoringAction.getElementAtCaret((Editor)editor2, (PsiFile)file2);
            if (element2 == null) {
                return;
            }
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element2, XmlTag.class);
            if (tag == null) {
                return;
            }
            AndroidBaseXmlRefactoringAction.this.doRefactorForTags(project, new XmlTag[]{tag});
        }

        public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
            if (this.myTagsFromExternalContext.length > 0) {
                AndroidBaseXmlRefactoringAction.this.doRefactorForTags(project, this.myTagsFromExternalContext);
                return;
            }
            if (elements.length != 1) {
                return;
            }
            PsiElement element2 = elements[0];
            if (!(element2 instanceof XmlTag)) {
                return;
            }
            AndroidBaseXmlRefactoringAction.this.doRefactorForTags(project, new XmlTag[]{(XmlTag)element2});
        }
    }
}

