/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.intentions;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.LintIdeQuickFix;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.ui.designer.EditorDesignSurface;
import com.android.utils.Pair;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.intellij.codeInsight.intention.AbstractIntentionAction;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.actions.ElementCreator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.android.actions.CreateResourceDirectoryDialog;
import org.jetbrains.android.actions.ElementCreatingValidator;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OverrideResourceAction
extends AbstractIntentionAction {
    @VisibleForTesting
    @Nullable
    public static String ourTargetFolderName;

    private static String getActionName(@Nullable String folder) {
        return "Override Resource in " + (folder != null ? folder : "Other Configuration...");
    }

    @NotNull
    public String getText() {
        return OverrideResourceAction.getActionName(null);
    }

    public boolean startInWriteAction() {
        return false;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor2, PsiFile file2) {
        if (file2 instanceof XmlFile && file2.isValid() && AndroidFacet.getInstance((PsiElement)file2) != null) {
            ResourceFolderType folderType = IdeResourcesUtil.getFolderType(file2);
            if (folderType == null) {
                return false;
            }
            if (folderType != ResourceFolderType.VALUES) {
                return true;
            }
            return this.isAvailable(OverrideResourceAction.getValueTag(editor2, file2), file2);
        }
        return false;
    }

    public boolean isAvailable(@Nullable XmlTag tag, PsiFile file2) {
        if (file2 instanceof XmlFile && file2.isValid() && AndroidFacet.getInstance((PsiElement)file2) != null) {
            ResourceFolderType folderType = IdeResourcesUtil.getFolderType(file2);
            if (folderType == null) {
                return false;
            }
            if (folderType != ResourceFolderType.VALUES) {
                return true;
            }
            if (tag != null && tag.getAttributeValue("name") != null) {
                return IdeResourcesUtil.getResourceTypeForResourceTag(tag) != null;
            }
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor2, PsiFile file2) throws IncorrectOperationException {
        ResourceFolderType folderType = IdeResourcesUtil.getFolderType(file2);
        if (folderType == null) {
            return;
        }
        if (folderType != ResourceFolderType.VALUES) {
            OverrideResourceAction.forkResourceFile((XmlFile)file2, null, true);
        } else if (editor2 != null) {
            OverrideResourceAction.forkResourceValue(project, editor2, file2, null, true);
        }
    }

    private static void forkResourceValue(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile file2, @Nullable PsiDirectory dir, boolean open) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        XmlTag tag = OverrideResourceAction.getValueTag(editor2, file2);
        if (tag == null) {
            return;
        }
        OverrideResourceAction.forkResourceValue(project, tag, file2, dir, open);
    }

    @Nullable
    private static PsiDirectory findRes(@NotNull PsiFile file2) {
        PsiDirectory resourceFolder = file2.getParent();
        return resourceFolder == null ? null : resourceFolder.getParent();
    }

    public static void forkResourceValue(@NotNull Project project, @NotNull XmlTag tag, @NotNull PsiFile file2, @Nullable PsiDirectory dir, boolean open) {
        PsiDirectory resFolder = OverrideResourceAction.findRes(file2);
        if (resFolder == null) {
            return;
        }
        String name = tag.getAttributeValue("name");
        ResourceType type = IdeResourcesUtil.getResourceTypeForResourceTag(tag);
        if (name == null || type == null) {
            return;
        }
        if (dir == null) {
            dir = OverrideResourceAction.selectFolderDir(project, resFolder.getVirtualFile(), ResourceFolderType.VALUES);
        }
        if (dir != null) {
            String value2 = IdeResourcesUtil.getTextContent(tag).trim();
            OverrideResourceAction.createValueResource(project, resFolder, file2, dir, name, value2, type, tag.getText(), open);
        }
    }

    @Nullable
    private static XmlTag getEditorTag(Editor editor2, PsiFile file2) {
        int offset2 = editor2.getCaretModel().getOffset();
        PsiElement psiElement = file2.findElementAt(offset2);
        if (psiElement != null) {
            return (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)psiElement, XmlTag.class, (boolean)false);
        }
        return null;
    }

    @Nullable
    private static XmlTag getValueTag(Editor editor2, PsiFile file2) {
        return OverrideResourceAction.getValueTag(OverrideResourceAction.getEditorTag(editor2, file2));
    }

    @Nullable
    public static XmlTag getValueTag(@Nullable XmlTag tag) {
        XmlTag current = null;
        if (tag != null) {
            XmlTag parentParent;
            current = tag;
            XmlTag parent = current.getParentTag();
            while (parent != null && (parentParent = parent.getParentTag()) != null) {
                current = parent;
                parent = parentParent;
            }
        }
        return current;
    }

    private static void createValueResource(final @NotNull Project project, final @NotNull PsiDirectory resDir, @NotNull PsiFile file2, @NotNull PsiDirectory resourceSubdir, final @NotNull String resName, final @NotNull String value2, final @NotNull ResourceType type, final @NotNull String oldTagText, boolean open) {
        final String filename = file2.getName();
        final List<String> dirNames = Collections.singletonList(resourceSubdir.getName());
        final AtomicReference openAfter = new AtomicReference();
        WriteCommandAction<Void> action2 = new WriteCommandAction<Void>(project, "Override Resource " + resName, new PsiFile[]{file2}){

            protected void run(@NotNull Result<Void> result2) {
                XmlTag tag;
                ArrayList elements = Lists.newArrayListWithExpectedSize((int)1);
                IdeResourcesUtil.createValueResource(project, resDir.getVirtualFile(), resName, type, filename, dirNames, value2, elements);
                if (elements.size() == 1 && (tag = ((ResourceElement)elements.get(0)).getXmlTag()) != null && tag.isValid()) {
                    try {
                        XmlTag tagFromText = XmlElementFactory.getInstance((Project)tag.getProject()).createTagFromText((CharSequence)oldTagText);
                        PsiElement replaced = tag.replace((PsiElement)tagFromText);
                        openAfter.set(replaced);
                    }
                    catch (IncorrectOperationException e) {
                        openAfter.set(tag);
                    }
                }
            }
        };
        action2.execute();
        PsiElement tag = (PsiElement)openAfter.get();
        if (open && tag != null) {
            NavigationUtil.openFileWithPsiElement((PsiElement)tag, (boolean)true, (boolean)true);
        }
    }

    public static void forkResourceFile(@NotNull EditorDesignSurface surface2, @Nullable String newFolder, boolean open) {
        for (Configuration configuration : surface2.getConfigurations()) {
            if (configuration == null) {
                assert (false);
                return;
            }
            VirtualFile file2 = configuration.getFile();
            if (file2 == null) {
                assert (false);
                return;
            }
            Module module2 = configuration.getModule();
            if (module2 == null) {
                assert (false);
                return;
            }
            XmlFile xmlFile = (XmlFile)configuration.getPsiFile();
            ResourceFolderType folderType = IdeResourcesUtil.getFolderType((PsiFile)xmlFile);
            if (folderType == null) {
                folderType = ResourceFolderType.LAYOUT;
            }
            OverrideResourceAction.forkResourceFile(module2.getProject(), folderType, file2, xmlFile, newFolder, configuration, open);
        }
    }

    public static void forkResourceFile(@NotNull XmlFile xmlFile, @Nullable String myNewFolder, boolean open) {
        VirtualFile file2 = xmlFile.getVirtualFile();
        if (file2 == null) {
            return;
        }
        Module module2 = AndroidPsiUtils.getModuleSafely((PsiElement)xmlFile);
        if (module2 == null) {
            return;
        }
        ResourceFolderType folderType = IdeResourcesUtil.getFolderType((PsiFile)xmlFile);
        if (folderType == null || folderType == ResourceFolderType.VALUES) {
            return;
        }
        Configuration configuration = null;
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
        if (facet2 != null) {
            configuration = ConfigurationManager.getOrCreateInstance(module2).getConfiguration(file2);
        }
        OverrideResourceAction.forkResourceFile(module2.getProject(), folderType, file2, xmlFile, myNewFolder, configuration, open);
    }

    private static void forkResourceFile(@NotNull Project project, final @NotNull ResourceFolderType folderType, final @NotNull VirtualFile file2, final @Nullable XmlFile xmlFile, @Nullable String myNewFolder, @Nullable Configuration configuration, boolean open) {
        FolderConfiguration folderConfig;
        if (myNewFolder == null) {
            VirtualFile parentFolder = file2.getParent();
            assert (parentFolder != null);
            VirtualFile res = parentFolder.getParent();
            folderConfig = OverrideResourceAction.selectFolderConfig(project, res, folderType);
        } else {
            folderConfig = FolderConfiguration.getConfigForFolder((String)myNewFolder);
        }
        if (folderConfig == null) {
            return;
        }
        Computable<Pair<String, VirtualFile>> computable = new Computable<Pair<String, VirtualFile>>(){

            public Pair<String, VirtualFile> compute() {
                String folderName = folderConfig.getFolderName(folderType);
                try {
                    VirtualFile existing2;
                    VirtualFile parentFolder = file2.getParent();
                    assert (parentFolder != null);
                    VirtualFile res = parentFolder.getParent();
                    VirtualFile newParentFolder = res.findChild(folderName);
                    if (newParentFolder == null) {
                        try {
                            newParentFolder = res.createChildDirectory((Object)this, folderName);
                        }
                        catch (IncorrectOperationException e) {
                            String message2 = String.format("Could not create folder %1$s in %2$s, Reason:\n%3$s", folderName, res.getPath(), e.getMessage());
                            return Pair.of((Object)message2, null);
                        }
                    }
                    if ((existing2 = newParentFolder.findChild(file2.getName())) != null && existing2.exists()) {
                        String message3 = String.format("File 'res/%1$s/%2$s' already exists!", folderName, file2.getName());
                        return Pair.of((Object)message3, null);
                    }
                    String text2 = xmlFile != null && xmlFile.isValid() ? xmlFile.getText() : StreamUtil.readText((InputStream)file2.getInputStream(), (String)"UTF-8");
                    VirtualFile newFile = newParentFolder.createChildData((Object)this, file2.getName());
                    VfsUtil.saveText((VirtualFile)newFile, (String)text2);
                    return Pair.of(null, (Object)newFile);
                }
                catch (IOException e2) {
                    String message4 = String.format("Failed to create File 'res/%1$s/%2$s' : %3$s", folderName, file2.getName(), e2.getMessage());
                    return Pair.of((Object)message4, null);
                }
            }
        };
        WriteCommandAction<Pair<String, VirtualFile>> action2 = new WriteCommandAction<Pair<String, VirtualFile>>(project, "Add Resource", new PsiFile[0], (Computable)computable){
            final /* synthetic */ Computable val$computable;
            {
                this.val$computable = computable;
                super(x0, x1, x2);
            }

            protected void run(@NotNull Result<Pair<String, VirtualFile>> result2) throws Throwable {
                result2.setResult(this.val$computable.compute());
            }
        };
        Pair result2 = (Pair)action2.execute().getResultObject();
        String error = (String)result2.getFirst();
        VirtualFile newFile = (VirtualFile)result2.getSecond();
        if (error != null) {
            Messages.showErrorDialog((Project)project, (String)error, (String)"Create Resource");
        } else {
            if (configuration != null) {
                ConfigurationManager configurationManager = configuration.getConfigurationManager();
                configurationManager.createSimilar(newFile, file2);
            }
            if (open) {
                OpenFileDescriptor descriptor2 = new OpenFileDescriptor(project, newFile, -1);
                FileEditorManager.getInstance((Project)project).openEditor(descriptor2, true);
            }
        }
    }

    @Nullable
    public static PsiDirectory selectFolderDir(Project project, VirtualFile res, ResourceFolderType folderType) {
        PsiDirectory directory = PsiManager.getInstance((Project)project).findDirectory(res);
        if (directory == null) {
            return null;
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && ourTargetFolderName != null) {
            PsiDirectory subDirectory = directory.findSubdirectory(ourTargetFolderName);
            if (subDirectory != null) {
                return subDirectory;
            }
            Computable createDirComputable = () -> directory.createSubdirectory(ourTargetFolderName);
            return (PsiDirectory)ApplicationManager.getApplication().runWriteAction(createDirComputable);
        }
        CreateResourceDirectoryDialog dialog2 = new CreateResourceDirectoryDialog(project, null, folderType, directory, null, resDirectory -> new ResourceDirectorySelector(project, resDirectory));
        dialog2.setTitle("Select Resource Directory");
        if (!dialog2.showAndGet()) {
            return null;
        }
        PsiElement[] createdElements = dialog2.getCreatedElements();
        if (createdElements.length > 0) {
            return (PsiDirectory)createdElements[0];
        }
        return null;
    }

    @Nullable
    public static FolderConfiguration selectFolderConfig(Project project, VirtualFile res, ResourceFolderType folderType) {
        PsiDirectory dir = OverrideResourceAction.selectFolderDir(project, res, folderType);
        if (dir != null) {
            return FolderConfiguration.getConfigForFolder((String)dir.getName());
        }
        return null;
    }

    public static LintIdeQuickFix createFix(@Nullable String folder) {
        return new OverrideElementFix(folder);
    }

    private static class OverrideElementFix
    implements LintIdeQuickFix {
        private final String myFolder;

        private OverrideElementFix(@Nullable String folder) {
            this.myFolder = folder;
        }

        public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
            ResourceFolderType folderType;
            PsiFile file2 = startElement.getContainingFile();
            if (file2 instanceof XmlFile && (folderType = IdeResourcesUtil.getFolderType(file2)) != null) {
                if (folderType != ResourceFolderType.VALUES) {
                    OverrideResourceAction.forkResourceFile((XmlFile)file2, this.myFolder, true);
                } else {
                    XmlTag tag = OverrideResourceAction.getValueTag((XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class, (boolean)false));
                    if (tag != null) {
                        PsiDirectory resFolder;
                        PsiDirectory dir = null;
                        if (this.myFolder != null && (resFolder = OverrideResourceAction.findRes(file2)) != null && (dir = resFolder.findSubdirectory(this.myFolder)) == null) {
                            dir = resFolder.createSubdirectory(this.myFolder);
                        }
                        OverrideResourceAction.forkResourceValue(startElement.getProject(), tag, file2, dir, true);
                    }
                }
            }
        }

        public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
            return true;
        }

        @NotNull
        public String getName() {
            return OverrideResourceAction.getActionName(this.myFolder);
        }
    }

    private static class ResourceDirectorySelector
    extends ElementCreator
    implements ElementCreatingValidator {
        private final PsiDirectory myDirectory;
        private PsiElement[] myCreatedElements = PsiElement.EMPTY_ARRAY;

        public ResourceDirectorySelector(Project project, PsiDirectory directory) {
            super(project, "Select Resource Directory");
            this.myDirectory = directory;
        }

        public boolean checkInput(String inputString) {
            return ResourceFolderType.getFolderType((String)inputString) != null && FolderConfiguration.getConfigForFolder((String)inputString) != null;
        }

        public PsiElement[] create(String newName2) throws Exception {
            PsiDirectory subdirectory = this.myDirectory.findSubdirectory(newName2);
            if (subdirectory == null) {
                subdirectory = this.myDirectory.createSubdirectory(newName2);
            }
            return new PsiElement[]{subdirectory};
        }

        public String getActionName(String newName2) {
            return "Select Resource Directory";
        }

        public boolean canClose(String inputString) {
            PsiDirectory subdirectory = this.myDirectory.findSubdirectory(inputString);
            if (subdirectory != null) {
                this.myCreatedElements = new PsiDirectory[]{subdirectory};
                return true;
            }
            this.myCreatedElements = this.tryCreate(inputString);
            return this.myCreatedElements.length > 0;
        }

        @Override
        @NotNull
        public final PsiElement[] getCreatedElements() {
            return this.myCreatedElements;
        }
    }
}

