/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.intentions;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.android.dom.manifest.Application;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.dom.manifest.Service;
import org.jetbrains.android.intentions.AbstractRegisterComponentAction;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class AddServiceToManifest
extends AbstractRegisterComponentAction {
    @Nls
    @NotNull
    public String getText() {
        return "Add service to manifest";
    }

    @Override
    boolean isAvailable(@NotNull PsiClass psiClass, @NotNull Manifest manifest) {
        if (!InheritanceUtil.isInheritor((PsiClass)psiClass, (boolean)true, (String)"android.app.Service")) {
            return false;
        }
        return !AddServiceToManifest.isRegisteredService(psiClass, manifest.getApplication());
    }

    @Override
    void invoke(@NotNull PsiClass psiClass, @NotNull Manifest manifest) {
        Application application = manifest.getApplication();
        application.addService().getServiceClass().setValue(psiClass);
    }

    private static boolean isRegisteredService(PsiClass psiClass, Application application) {
        for (Service service : application.getServices()) {
            if (!psiClass.isEquivalentTo((PsiElement)service.getServiceClass().getValue())) continue;
            return true;
        }
        return false;
    }
}

