/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.intentions;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.android.dom.manifest.Activity;
import org.jetbrains.android.dom.manifest.Application;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.intentions.AbstractRegisterComponentAction;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class AddActivityToManifest
extends AbstractRegisterComponentAction {
    @Nls
    @NotNull
    public String getText() {
        return "Add activity to manifest";
    }

    @Override
    boolean isAvailable(@NotNull PsiClass psiClass, @NotNull Manifest manifest) {
        if (!InheritanceUtil.isInheritor((PsiClass)psiClass, (boolean)true, (String)"android.app.Activity")) {
            return false;
        }
        return !AddActivityToManifest.isRegisteredActivity(psiClass, manifest.getApplication());
    }

    @Override
    void invoke(@NotNull PsiClass psiClass, @NotNull Manifest manifest) {
        Application application = manifest.getApplication();
        application.addActivity().getActivityClass().setValue(psiClass);
    }

    private static boolean isRegisteredActivity(PsiClass psiClass, Application application) {
        for (Activity activity : application.getActivities()) {
            if (!psiClass.isEquivalentTo((PsiElement)activity.getActivityClass().getValue())) continue;
            return true;
        }
        return false;
    }
}

