/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.android.resources.Density;
import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.LintIdeQuickFix;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class ConvertToDpQuickFix
implements LintIdeQuickFix {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.inspections.lint.ConvertToDpQuickFix");
    private static final Pattern PX_ATTR_VALUE_PATTERN = Pattern.compile("(\\d+)px");
    private static int ourPrevDpi = Density.DEFAULT_DENSITY;

    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        String newValue;
        int dpi;
        if (context instanceof AndroidQuickfixContexts.BatchContext) {
            return;
        }
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class);
        ArrayList<Density> densities = new ArrayList<Density>();
        for (Density density : Density.values()) {
            if (!density.isValidValueForDevice()) continue;
            densities.add(density);
        }
        String[] densityPresentableNames = new String[densities.size()];
        String defaultValue2 = null;
        String initialValue = null;
        for (int i2 = 0; i2 < densities.size(); ++i2) {
            Density density = (Density)densities.get(i2);
            densityPresentableNames[i2] = ConvertToDpQuickFix.getLabelForDensity(density);
            int dpi2 = density.getDpiValue();
            if (dpi2 == ourPrevDpi) {
                initialValue = densityPresentableNames[i2];
                continue;
            }
            if (dpi2 != Density.DEFAULT_DENSITY) continue;
            defaultValue2 = densityPresentableNames[i2];
        }
        if (initialValue == null) {
            initialValue = defaultValue2;
        }
        if (initialValue == null) {
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            dpi = Density.DEFAULT_DENSITY;
        } else {
            int selectedIndex = Messages.showChooseDialog((String)"What is the screen density the current px value works with?", (String)"Choose density", (String[])densityPresentableNames, initialValue, null);
            if (selectedIndex < 0) {
                return;
            }
            dpi = ((Density)densities.get(selectedIndex)).getDpiValue();
        }
        ourPrevDpi = dpi;
        for (XmlAttribute attribute : tag.getAttributes()) {
            String newValue2;
            String value2 = attribute.getValue();
            if (value2 == null || !value2.endsWith("px") || (newValue2 = ConvertToDpQuickFix.convertToDp(value2, dpi)) == null) continue;
            attribute.setValue(newValue2);
        }
        XmlTagValue tagValueElement = tag.getValue();
        String tagValue = tagValueElement.getText();
        if (tagValue.endsWith("px") && (newValue = ConvertToDpQuickFix.convertToDp(tagValue, dpi)) != null) {
            tagValueElement.setText(newValue);
        }
    }

    private static String convertToDp(String value2, int dpi) {
        String newValue = null;
        Matcher matcher = PX_ATTR_VALUE_PATTERN.matcher(value2);
        if (matcher.matches()) {
            String numberString = matcher.group(1);
            try {
                int px = Integer.parseInt(numberString);
                int dp = px * 160 / dpi;
                newValue = Integer.toString(dp) + "dp";
            }
            catch (NumberFormatException nufe) {
                LOG.error((Throwable)nufe);
            }
        }
        return newValue;
    }

    @NotNull
    private static String getLabelForDensity(@NotNull Density density) {
        return String.format(Locale.US, "%1$s (%2$d)", density.getShortDisplayValue(), density.getDpiValue());
    }

    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        return contextType != AndroidQuickfixContexts.BatchContext.TYPE && PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class) != null;
    }

    @NotNull
    public String getName() {
        return AndroidBundle.message("android.lint.fix.convert.to.dp", new Object[0]);
    }
}

