/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.importDependencies;

import com.intellij.CommonBundle;
import com.intellij.ProjectTopics;
import com.intellij.ide.highlighter.ModuleFileType;
import com.intellij.ide.util.newProjectWizard.SourcePathsStep;
import com.intellij.ide.util.projectWizard.importSources.JavaModuleSourceRoot;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.OrderedSet;
import com.intellij.util.messages.MessageBusConnection;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.importDependencies.AddModuleDependencyTask;
import org.jetbrains.android.importDependencies.CreateNewModuleTask;
import org.jetbrains.android.importDependencies.ImportDependenciesDialog;
import org.jetbrains.android.importDependencies.ImportDependenciesTask;
import org.jetbrains.android.importDependencies.ImportModuleTask;
import org.jetbrains.android.importDependencies.ImportSourceRootsDialog;
import org.jetbrains.android.importDependencies.ModuleProvider;
import org.jetbrains.android.importDependencies.ModuleProvidingTask;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportDependenciesUtil {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.importDependencies.ImportDependenciesUtil");
    private static final Key<Boolean> WAIT_FOR_IMPORTING_DEPENDENCIES_KEY = new Key("WAIT_FOR_IMPORTING_DEPENDENCIES_KEY");
    private static final Object LOCK = new Object();

    private ImportDependenciesUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void importDependencies(final @NotNull Module module2, final boolean updateBackwardDependencies) {
        Object object = LOCK;
        synchronized (object) {
            final Project project = module2.getProject();
            module2.putUserData(WAIT_FOR_IMPORTING_DEPENDENCIES_KEY, (Object)Boolean.TRUE);
            if (project.getUserData(WAIT_FOR_IMPORTING_DEPENDENCIES_KEY) != Boolean.TRUE) {
                project.putUserData(WAIT_FOR_IMPORTING_DEPENDENCIES_KEY, (Object)Boolean.TRUE);
                StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(new Runnable(){

                    @Override
                    public void run() {
                        if (module2.isLoaded()) {
                            ImportDependenciesUtil.importDependenciesForMarkedModules(project, updateBackwardDependencies);
                        } else {
                            final MessageBusConnection connection = module2.getMessageBus().connect();
                            connection.subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(){

                                public void moduleAdded(@NotNull Project project, @NotNull Module addedModule) {
                                    if (module2.equals(addedModule)) {
                                        connection.disconnect();
                                        ImportDependenciesUtil.importDependenciesForMarkedModules(project, updateBackwardDependencies);
                                    }
                                }
                            });
                        }
                    }
                });
            }
        }
    }

    private static void importDependenciesForMarkedModules(final Project project, final boolean updateBackwardDependencies) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                ImportDependenciesUtil.doImportDependenciesForMarkedModules(project, updateBackwardDependencies);
            }
        });
    }

    private static void doImportDependenciesForMarkedModules(Project project, boolean updateBackwardDependencies) {
        if (project.getUserData(WAIT_FOR_IMPORTING_DEPENDENCIES_KEY) != Boolean.TRUE) {
            return;
        }
        project.putUserData(WAIT_FOR_IMPORTING_DEPENDENCIES_KEY, null);
        ArrayList<Module> modulesToProcess = new ArrayList<Module>();
        for (Module module2 : ModuleManager.getInstance((Project)project).getModules()) {
            if (module2.getUserData(WAIT_FOR_IMPORTING_DEPENDENCIES_KEY) != Boolean.TRUE) continue;
            module2.putUserData(WAIT_FOR_IMPORTING_DEPENDENCIES_KEY, null);
            modulesToProcess.add(module2);
        }
        ImportDependenciesUtil.doImportDependencies(project, modulesToProcess, updateBackwardDependencies);
    }

    public static void doImportDependencies(@NotNull Project project, @NotNull List<Module> modules, boolean updateBackwardDependencies) {
        OrderedSet tasks = new OrderedSet();
        ArrayList<MyUnresolvedDependency> unresolvedDependencies = new ArrayList<MyUnresolvedDependency>();
        for (Module module2 : modules) {
            ImportDependenciesUtil.importDependencies(module2, updateBackwardDependencies, (List<ImportDependenciesTask>)tasks, unresolvedDependencies);
        }
        HashMap<VirtualFile, ModuleProvidingTask> libDir2ModuleProvidingTask = new HashMap<VirtualFile, ModuleProvidingTask>();
        for (ImportDependenciesTask task2 : tasks) {
            if (!(task2 instanceof ModuleProvidingTask)) continue;
            ModuleProvidingTask moduleProvidingTask = (ModuleProvidingTask)task2;
            libDir2ModuleProvidingTask.put(moduleProvidingTask.getContentRoot(), moduleProvidingTask);
        }
        for (MyUnresolvedDependency unresolvedDependency : unresolvedDependencies) {
            ModuleProvidingTask taskProvidingDepModule = (ModuleProvidingTask)libDir2ModuleProvidingTask.get(unresolvedDependency.myLibDir);
            if (taskProvidingDepModule == null) continue;
            tasks.add(new AddModuleDependencyTask(unresolvedDependency.myModuleProvider, ModuleProvider.create(taskProvidingDepModule)));
        }
        if (!tasks.isEmpty()) {
            ImportDependenciesUtil.doImportDependencies(project, (List<ImportDependenciesTask>)tasks);
        }
    }

    private static void importDependencies(Module module2, boolean updateBackwardDependencies, List<ImportDependenciesTask> tasks, List<MyUnresolvedDependency> unresolvedDependencies) {
        ImportDependenciesUtil.importDependencies(module2, null, tasks, unresolvedDependencies);
        if (updateBackwardDependencies) {
            ImportDependenciesUtil.importBackwardDependencies(module2, tasks, unresolvedDependencies);
        }
    }

    private static void doImportDependencies(@NotNull Project project, @NotNull List<ImportDependenciesTask> tasks) {
        ImportDependenciesDialog dialog2 = new ImportDependenciesDialog(project, tasks);
        dialog2.show();
        if (dialog2.getExitCode() != 0) {
            return;
        }
        List<ImportDependenciesTask> selectedTasks = dialog2.getSelectedTasks();
        StringBuilder messageBuilder = new StringBuilder();
        boolean failed = false;
        ArrayList<CreateNewModuleTask> createNewModuleTasks = new ArrayList<CreateNewModuleTask>();
        for (ImportDependenciesTask importDependenciesTask : selectedTasks) {
            Exception error = importDependenciesTask.perform();
            if (error != null) {
                LOG.info((Throwable)error);
                if (messageBuilder.length() > 0) {
                    messageBuilder.append('\n');
                }
                messageBuilder.append(error.getMessage());
                failed = true;
                continue;
            }
            if (!(importDependenciesTask instanceof CreateNewModuleTask)) continue;
            createNewModuleTasks.add((CreateNewModuleTask)importDependenciesTask);
        }
        if (!createNewModuleTasks.isEmpty()) {
            ArrayList<JavaModuleSourceRoot> sourceRoots = new ArrayList<JavaModuleSourceRoot>();
            for (CreateNewModuleTask task2 : createNewModuleTasks) {
                String contentRootPath = task2.getContentRoot().getPath();
                sourceRoots.addAll(SourcePathsStep.calculateSourceRoots((String)contentRootPath));
            }
            if (!sourceRoots.isEmpty()) {
                ImportSourceRootsDialog importSourceRootsDialog = new ImportSourceRootsDialog(project, sourceRoots);
                importSourceRootsDialog.show();
                if (importSourceRootsDialog.getExitCode() == 0) {
                    ImportDependenciesUtil.addSourceRoots(project, importSourceRootsDialog.getMarkedElements());
                }
            }
        }
        if (failed) {
            Messages.showErrorDialog((Project)project, (String)(AndroidBundle.message("android.import.dependencies.error.message.header", new Object[0]) + "\n" + messageBuilder.toString()), (String)CommonBundle.getErrorTitle());
        }
    }

    private static void addSourceRoots(final Project project, final List<JavaModuleSourceRoot> sourceRoots) {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                for (JavaModuleSourceRoot sourceRootTrinity : sourceRoots) {
                    String path2 = sourceRootTrinity.getDirectory().getPath();
                    VirtualFile sourceRoot = LocalFileSystem.getInstance().refreshAndFindFileByPath(FileUtil.toSystemIndependentName((String)path2));
                    if (sourceRoot == null) {
                        LOG.debug((Throwable)new Exception("Cannot find source root " + path2));
                        continue;
                    }
                    Module module2 = ModuleUtil.findModuleForFile((VirtualFile)sourceRoot, (Project)project);
                    if (module2 == null) {
                        LOG.debug((Throwable)new Exception("Cannot find module for file " + sourceRoot.getPath()));
                        continue;
                    }
                    ModifiableRootModel model2 = ModuleRootManager.getInstance((Module)module2).getModifiableModel();
                    ContentEntry[] entries = model2.getContentEntries();
                    if (entries.length > 0) {
                        entries[0].addSourceFolder(sourceRoot, false, sourceRootTrinity.getPackagePrefix());
                    } else {
                        LOG.debug((Throwable)new Exception("Module " + module2.getName() + " has no content entries"));
                    }
                    model2.commit();
                }
            }
        });
    }

    @Nullable
    private static VirtualFile findModuleFileChild(@NotNull VirtualFile dir) {
        for (VirtualFile child : dir.getChildren()) {
            if (!(child.getFileType() instanceof ModuleFileType)) continue;
            return child;
        }
        return null;
    }

    private static void importDependencies(@NotNull Module module2, @Nullable Module allowedDepModule, @NotNull List<ImportDependenciesTask> tasks, @NotNull List<MyUnresolvedDependency> unresolvedDependencies) {
        Project project = module2.getProject();
        ModuleProvider moduleProvider = ModuleProvider.create(module2);
        Pair<Properties, VirtualFile> pair = AndroidRootUtil.readProjectPropertyFile(module2);
        if (pair != null) {
            ImportDependenciesUtil.doImportDependencies(module2, allowedDepModule, tasks, unresolvedDependencies, project, moduleProvider, pair);
        }
    }

    private static void importDependenciesForNewModule(@NotNull Project project, @NotNull ModuleProvider newModuleProvider, @NotNull VirtualFile newModuleContentRoot, @NotNull List<ImportDependenciesTask> tasks, @NotNull List<MyUnresolvedDependency> unresolvedDependencies) {
        Pair<Properties, VirtualFile> properties2 = AndroidRootUtil.readProjectPropertyFile(newModuleContentRoot);
        if (properties2 != null) {
            ImportDependenciesUtil.doImportDependencies(null, null, tasks, unresolvedDependencies, project, newModuleProvider, properties2);
        }
    }

    private static void doImportDependencies(@Nullable Module module2, @Nullable Module allowedDepModule, @NotNull List<ImportDependenciesTask> tasks, @NotNull List<MyUnresolvedDependency> unresolvedDependencies, @NotNull Project project, @NotNull ModuleProvider moduleProvider, @NotNull Pair<Properties, VirtualFile> defaultProperties) {
        for (VirtualFile libDir : ImportDependenciesUtil.getLibDirs(defaultProperties)) {
            CreateNewModuleTask task2;
            Module depModule = ModuleUtil.findModuleForFile((VirtualFile)libDir, (Project)project);
            if (depModule != null) {
                if (allowedDepModule != null && allowedDepModule != depModule || ArrayUtil.find((Object[])ModuleRootManager.getInstance((Module)depModule).getContentRoots(), (Object)libDir) < 0 || module2 != null && ModuleRootManager.getInstance((Module)module2).isDependsOn(depModule)) continue;
                tasks.add(new AddModuleDependencyTask(moduleProvider, ModuleProvider.create(depModule)));
                continue;
            }
            VirtualFile libModuleFile = ImportDependenciesUtil.findModuleFileChild(libDir);
            ModuleProvidingTask moduleProvidingTask = task2 = libModuleFile != null && new File(libModuleFile.getPath()).exists() ? new ImportModuleTask(project, libModuleFile.getPath(), libDir) : new CreateNewModuleTask(project, libDir);
            if (!tasks.contains(task2)) {
                tasks.add(task2);
                ModuleProvider newModuleProvider = ModuleProvider.create(task2);
                tasks.add(new AddModuleDependencyTask(moduleProvider, newModuleProvider));
                ImportDependenciesUtil.importDependenciesForNewModule(project, newModuleProvider, libDir, tasks, unresolvedDependencies);
                continue;
            }
            unresolvedDependencies.add(new MyUnresolvedDependency(moduleProvider, libDir));
        }
    }

    @NotNull
    public static Set<VirtualFile> getLibDirs(@NotNull Pair<Properties, VirtualFile> properties2) {
        String libDirPath;
        HashSet<VirtualFile> resultSet = new HashSet<VirtualFile>();
        VirtualFile baseDir = ((VirtualFile)properties2.second).getParent();
        int i2 = 1;
        do {
            VirtualFile libDir;
            if ((libDirPath = ((Properties)properties2.first).getProperty("android.library.reference." + i2)) != null && (libDir = AndroidUtils.findFileByAbsoluteOrRelativePath(baseDir, FileUtil.toSystemIndependentName((String)libDirPath))) != null) {
                resultSet.add(libDir);
            }
            ++i2;
        } while (libDirPath != null);
        return resultSet;
    }

    private static void importBackwardDependencies(@NotNull Module module2, @NotNull List<ImportDependenciesTask> tasks, @NotNull List<MyUnresolvedDependency> unresolvedDependencies) {
        for (Module module1 : ModuleManager.getInstance((Project)module2.getProject()).getModules()) {
            if (module1 == module2) continue;
            ImportDependenciesUtil.importDependencies(module1, module2, tasks, unresolvedDependencies);
        }
    }

    private static class MyUnresolvedDependency {
        final ModuleProvider myModuleProvider;
        final VirtualFile myLibDir;

        private MyUnresolvedDependency(ModuleProvider moduleProvider, VirtualFile libDir) {
            this.myModuleProvider = moduleProvider;
            this.myLibDir = libDir;
        }
    }
}

