/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.importDependencies;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import org.jetbrains.android.importDependencies.ImportDependenciesTask;
import org.jetbrains.android.importDependencies.ModuleProvider;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AddModuleDependencyTask
extends ImportDependenciesTask {
    private final ModuleProvider myModuleProvider;
    private final ModuleProvider myDepModuleProvider;

    public AddModuleDependencyTask(@NotNull ModuleProvider moduleProvider, @NotNull ModuleProvider depModuleProvider) {
        this.myModuleProvider = moduleProvider;
        this.myDepModuleProvider = depModuleProvider;
    }

    @Override
    @Nullable
    public Exception perform() {
        Module module2 = this.myModuleProvider.getModule();
        Module depModule = this.myDepModuleProvider.getModule();
        if (module2 == null || depModule == null) {
            return null;
        }
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module2);
        if (!rootManager.isDependsOn(depModule)) {
            ModuleRootModificationUtil.addDependency((Module)module2, (Module)depModule);
        }
        return null;
    }

    @Override
    @NotNull
    public String getTitle() {
        return AndroidBundle.message("android.import.dependencies.add.module.dependency.task.title", this.myModuleProvider.getModuleName(), this.myDepModuleProvider.getModuleName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddModuleDependencyTask that = (AddModuleDependencyTask)o;
        if (!this.myDepModuleProvider.equals(that.myDepModuleProvider)) {
            return false;
        }
        return this.myModuleProvider.equals(that.myModuleProvider);
    }

    public int hashCode() {
        int result2 = this.myModuleProvider.hashCode();
        result2 = 31 * result2 + this.myDepModuleProvider.hashCode();
        return result2;
    }
}

