/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.layout;

import com.intellij.psi.PsiElement;
import com.intellij.psi.meta.PsiPresentableMetaData;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlElementsGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.dom.AndroidAnyAttributeDescriptor;
import org.jetbrains.android.dom.AndroidDomElementDescriptorProvider;
import org.jetbrains.android.dom.layout.AndroidLayoutNSDescriptor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\b\u001a\u0004\u0018\u00010\t2\n\b\u0001\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u001d\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u00112\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016\u00a2\u0006\u0002\u0010\u0012J\t\u0010\u0013\u001a\u00020\u0014H\u0096\u0001J\u0011\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016H\u0096\u0001J\u0011\u0010\u0018\u001a\n \u0017*\u0004\u0018\u00010\r0\rH\u0097\u0001J\u0010\u0010\u0019\u001a\t\u0018\u00010\r\u00a2\u0006\u0002\b\u001aH\u0097\u0001J\u001e\u0010\u001b\u001a\u0004\u0018\u00010\u00022\b\u0010\u001c\u001a\u0004\u0018\u00010\u000f2\b\u0010\u001d\u001a\u0004\u0018\u00010\u000fH\u0016J\u001d\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00000\u00112\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016\u00a2\u0006\u0002\u0010\u001fJ\u000f\u0010 \u001a\t\u0018\u00010!\u00a2\u0006\u0002\b\u001aH\u0016J\b\u0010\"\u001a\u00020#H\u0016J\u0011\u0010$\u001a\n \u0017*\u0004\u0018\u00010\r0\rH\u0097\u0001J!\u0010$\u001a\n \u0017*\u0004\u0018\u00010\r0\r2\u000e\u0010%\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016H\u0097\u0001J\u0011\u0010&\u001a\n \u0017*\u0004\u0018\u00010\r0\rH\u0097\u0001J\u0010\u0010'\u001a\t\u0018\u00010(\u00a2\u0006\u0002\b\u001aH\u0097\u0001J\n\u0010)\u001a\u0004\u0018\u00010*H\u0016J\u0019\u0010+\u001a\u00020,2\u000e\u0010%\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016H\u0096\u0001R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0007\u00a8\u0006-"}, d2={"Lorg/jetbrains/android/dom/layout/LayoutElementDescriptor;", "Lcom/intellij/psi/meta/PsiPresentableMetaData;", "Lcom/intellij/xml/XmlElementDescriptor;", "delegate", "(Lcom/intellij/xml/XmlElementDescriptor;)V", "isContainer", "", "()Z", "getAttributeDescriptor", "Lcom/intellij/xml/XmlAttributeDescriptor;", "attribute", "Lcom/intellij/psi/xml/XmlAttribute;", "attributeName", "", "context", "Lcom/intellij/psi/xml/XmlTag;", "getAttributesDescriptors", "", "(Lcom/intellij/psi/xml/XmlTag;)[Lcom/intellij/xml/XmlAttributeDescriptor;", "getContentType", "", "getDeclaration", "Lcom/intellij/psi/PsiElement;", "kotlin.jvm.PlatformType", "getDefaultName", "getDefaultValue", "Lorg/jetbrains/annotations/Nullable;", "getElementDescriptor", "childTag", "contextTag", "getElementsDescriptors", "(Lcom/intellij/psi/xml/XmlTag;)[Lorg/jetbrains/android/dom/layout/LayoutElementDescriptor;", "getIcon", "Ljavax/swing/Icon;", "getNSDescriptor", "Lorg/jetbrains/android/dom/layout/AndroidLayoutNSDescriptor;", "getName", "p0", "getQualifiedName", "getTopGroup", "Lcom/intellij/xml/XmlElementsGroup;", "getTypeName", "", "init", "", "intellij.android.core"})
public class LayoutElementDescriptor
implements PsiPresentableMetaData,
XmlElementDescriptor {
    private final boolean isContainer;
    private final XmlElementDescriptor delegate;

    protected boolean isContainer() {
        return this.isContainer;
    }

    @NotNull
    public AndroidLayoutNSDescriptor getNSDescriptor() {
        return AndroidLayoutNSDescriptor.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public LayoutElementDescriptor[] getElementsDescriptors(@Nullable XmlTag context) {
        void $this$mapTo$iv$iv;
        if (context == null) {
            return new LayoutElementDescriptor[0];
        }
        XmlElementDescriptor[] $this$map$iv = this.delegate.getElementsDescriptors(context);
        boolean $i$f$map = false;
        XmlElementDescriptor[] xmlElementDescriptorArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var7_7 = $this$mapTo$iv$iv;
        int n = ((void)var7_7).length;
        for (int j = 0; j < n; ++j) {
            void it;
            void item$iv$iv;
            void var11_11 = item$iv$iv = var7_7[j];
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            LayoutElementDescriptor layoutElementDescriptor = new LayoutElementDescriptor((XmlElementDescriptor)it);
            collection2.add(layoutElementDescriptor);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        LayoutElementDescriptor[] layoutElementDescriptorArray = thisCollection$iv.toArray(new LayoutElementDescriptor[0]);
        if (layoutElementDescriptorArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return layoutElementDescriptorArray;
    }

    @Nullable
    public XmlElementDescriptor getElementDescriptor(@Nullable XmlTag childTag, @Nullable XmlTag contextTag) {
        XmlElementDescriptor xmlElementDescriptor = this.delegate.getElementDescriptor(childTag, contextTag);
        if (xmlElementDescriptor == null) {
            return null;
        }
        XmlElementDescriptor fromDelegate = xmlElementDescriptor;
        return new LayoutElementDescriptor(fromDelegate);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public XmlAttributeDescriptor[] getAttributesDescriptors(@Nullable XmlTag context) {
        XmlAttributeDescriptor[] xmlAttributeDescriptorArray = this.delegate.getAttributesDescriptors(context);
        if (xmlAttributeDescriptorArray == null) {
            return new XmlAttributeDescriptor[0];
        }
        XmlAttributeDescriptor[] descriptors = xmlAttributeDescriptorArray;
        int layoutWidthIndex = -1;
        int layoutHeightIndex = -1;
        int n = 0;
        int n2 = descriptors.length;
        while (n < n2) {
            void i2;
            String name = descriptors[i2].getName();
            if (Intrinsics.areEqual((Object)"layout_width", (Object)name)) {
                layoutWidthIndex = i2;
            } else if (Intrinsics.areEqual((Object)"layout_height", (Object)name)) {
                layoutHeightIndex = i2;
            }
            ++i2;
        }
        if (layoutWidthIndex >= 0 && layoutHeightIndex >= 0 && layoutWidthIndex > layoutHeightIndex) {
            Object[] result2 = (XmlAttributeDescriptor[])descriptors.clone();
            ArrayUtil.swap((Object[])result2, (int)layoutWidthIndex, (int)layoutHeightIndex);
            return result2;
        }
        return descriptors;
    }

    @Nullable
    public XmlAttributeDescriptor getAttributeDescriptor(@NonNls @Nullable String attributeName, @Nullable XmlTag context) {
        XmlAttributeDescriptor xmlAttributeDescriptor = this.delegate.getAttributeDescriptor(attributeName, context);
        if (xmlAttributeDescriptor == null) {
            String string = attributeName;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            xmlAttributeDescriptor = new AndroidAnyAttributeDescriptor(string);
        }
        return xmlAttributeDescriptor;
    }

    @Nullable
    public XmlAttributeDescriptor getAttributeDescriptor(@NotNull XmlAttribute attribute) {
        XmlAttributeDescriptor xmlAttributeDescriptor = this.delegate.getAttributeDescriptor(attribute);
        if (xmlAttributeDescriptor == null) {
            xmlAttributeDescriptor = new AndroidAnyAttributeDescriptor(attribute.getName());
        }
        return xmlAttributeDescriptor;
    }

    @Nullable
    public Icon getIcon() {
        return AndroidDomElementDescriptorProvider.getIconForViewTag(this.getName());
    }

    @Nullable
    public Void getTypeName() {
        return null;
    }

    public LayoutElementDescriptor(@NotNull XmlElementDescriptor delegate2) {
        this.delegate = delegate2;
        this.isContainer = true;
    }

    public int getContentType() {
        return this.delegate.getContentType();
    }

    public PsiElement getDeclaration() {
        return this.delegate.getDeclaration();
    }

    @NonNls
    public String getDefaultName() {
        return this.delegate.getDefaultName();
    }

    @Nullable
    public String getDefaultValue() {
        return this.delegate.getDefaultValue();
    }

    @NonNls
    public String getName() {
        return this.delegate.getName();
    }

    @NonNls
    public String getName(PsiElement p0) {
        return this.delegate.getName(p0);
    }

    @NonNls
    public String getQualifiedName() {
        return this.delegate.getQualifiedName();
    }

    @Nullable
    public XmlElementsGroup getTopGroup() {
        return this.delegate.getTopGroup();
    }

    public void init(PsiElement p0) {
        this.delegate.init(p0);
    }
}

