/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.inspections;

import com.android.resources.ResourceFolderType;
import com.android.support.AndroidxNameUtils;
import com.android.tools.idea.imports.AndroidMavenImportFix;
import com.android.tools.idea.imports.MavenClassRegistry;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.refactoring.MigrateToAndroidxUtil;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0017J\b\u0010\u000f\u001a\u00020\u000eH\u0017J\b\u0010\u0010\u001a\u00020\u000eH\u0016J\u0018\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u0014H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/android/dom/inspections/AndroidUnresolvableTagInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "()V", "checkFile", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "file", "Lcom/intellij/psi/PsiFile;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "getDisplayName", "", "getGroupDisplayName", "getShortName", "isRelevantFile", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "Lcom/intellij/psi/xml/XmlFile;", "MyVisitor", "intellij.android.core"})
public final class AndroidUnresolvableTagInspection
extends LocalInspectionTool {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        return AndroidBundle.message("android.inspections.group.name", new Object[0]);
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        return AndroidBundle.message("android.inspections.unresolvable.tag", new Object[0]);
    }

    @NotNull
    public String getShortName() {
        return "AndroidUnresolvableTag";
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file2, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (!(file2 instanceof XmlFile)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        AndroidFacet androidFacet = AndroidFacet.getInstance((PsiElement)((PsiElement)file2));
        if (androidFacet == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        AndroidFacet facet2 = androidFacet;
        if (this.isRelevantFile(facet2, (XmlFile)file2)) {
            MyVisitor visitor2 = new MyVisitor(manager, isOnTheFly);
            file2.accept((PsiElementVisitor)visitor2);
            Collection $this$toTypedArray$iv = visitor2.getMyResult$intellij_android_core();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            ProblemDescriptor[] problemDescriptorArray = thisCollection$iv.toArray(new ProblemDescriptor[0]);
            if (problemDescriptorArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            return problemDescriptorArray;
        }
        return ProblemDescriptor.EMPTY_ARRAY;
    }

    private final boolean isRelevantFile(AndroidFacet facet2, XmlFile file2) {
        ResourceFolderType resourceType = ModuleResourceManagers.getInstance(facet2).getLocalResourceManager().getFileResourceFolderType((PsiFile)file2);
        return resourceType != null ? resourceType == ResourceFolderType.LAYOUT || resourceType == ResourceFolderType.MENU : false;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/android/dom/inspections/AndroidUnresolvableTagInspection$MyVisitor;", "Lcom/intellij/psi/XmlRecursiveElementVisitor;", "myInspectionManager", "Lcom/intellij/codeInspection/InspectionManager;", "myOnTheFly", "", "(Lcom/intellij/codeInspection/InspectionManager;Z)V", "myResult", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getMyResult$intellij_android_core", "()Ljava/util/List;", "visitXmlTag", "", "tag", "Lcom/intellij/psi/xml/XmlTag;", "intellij.android.core"})
    private static final class MyVisitor
    extends XmlRecursiveElementVisitor {
        @NotNull
        private final List<ProblemDescriptor> myResult;
        private final InspectionManager myInspectionManager;
        private final boolean myOnTheFly;

        @NotNull
        public final List<ProblemDescriptor> getMyResult$intellij_android_core() {
            return this.myResult;
        }

        public void visitXmlTag(@NotNull XmlTag tag) {
            super.visitXmlTag(tag);
            CharSequence charSequence = tag.getNamespace();
            boolean bl = false;
            if (charSequence.length() > 0) {
                return;
            }
            String className2 = tag.getName();
            if (StringsKt.indexOf$default((CharSequence)className2, (char)'.', (int)0, (boolean)false, (int)6, null) == -1) {
                if (Intrinsics.areEqual((Object)className2, (Object)"view")) {
                    String string = tag.getAttributeValue("class");
                    if (string == null) {
                        return;
                    }
                    className2 = string;
                } else {
                    return;
                }
            }
            PsiReference psiReference = (PsiReference)ArraysKt.lastOrNull((Object[])tag.getReferences());
            if (psiReference == null) {
                return;
            }
            PsiReference reference2 = psiReference;
            if (reference2.resolve() == null) {
                LocalQuickFix[] fixes = LocalQuickFix.EMPTY_ARRAY;
                PsiElement range = tag.getFirstChild().getNextSibling();
                for (PsiElement curr = tag.getFirstChild(); curr != null; curr = curr.getNextSibling()) {
                    if (!(curr instanceof XmlToken) || !Intrinsics.areEqual((Object)((XmlToken)curr).getTokenType(), (Object)XmlTokenType.XML_NAME)) continue;
                    range = curr;
                    break;
                }
                String string = className2;
                int n = StringsKt.lastIndexOf$default((CharSequence)className2, (char)'.', (int)0, (boolean)false, (int)6, null) + 1;
                boolean bl2 = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                String name = string3;
                String imported = MavenClassRegistry.INSTANCE.findImport(name);
                if (imported != null && (Intrinsics.areEqual((Object)className2, (Object)imported) || Intrinsics.areEqual((Object)className2, (Object)AndroidxNameUtils.getNewName((String)className2)))) {
                    String artifact;
                    String string4 = MavenClassRegistry.INSTANCE.findArtifact(name);
                    if (string4 == null) {
                        string4 = artifact = "library";
                    }
                    if (MigrateToAndroidxUtil.isAndroidx(tag.getProject())) {
                        artifact = AndroidxNameUtils.getCoordinateMapping((String)artifact);
                    }
                    fixes = new LocalQuickFix[]{new AndroidMavenImportFix(className2, artifact)};
                }
                this.myResult.add(this.myInspectionManager.createProblemDescriptor(range, AndroidBundle.message("element.cannot.resolve", className2), this.myOnTheFly, fixes, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL));
            }
        }

        public MyVisitor(@NotNull InspectionManager myInspectionManager, boolean myOnTheFly) {
            this.myInspectionManager = myInspectionManager;
            this.myOnTheFly = myOnTheFly;
            this.myResult = new ArrayList();
        }
    }
}

