/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.augment;

import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.StyleableResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.google.common.base.Verify;
import com.google.common.collect.ListMultimap;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiPredicate;
import kotlin.Pair;
import org.jetbrains.android.augment.AndroidLightField;
import org.jetbrains.android.augment.AndroidLightInnerClassBase;
import org.jetbrains.android.augment.ResourceLightField;
import org.jetbrains.android.augment.StyleableAttrFieldUrl;
import org.jetbrains.android.augment.StyleableAttrLightField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InnerRClassBase
extends AndroidLightInnerClassBase {
    private static final Logger LOG = Logger.getInstance(InnerRClassBase.class);
    @NotNull
    protected final ResourceType myResourceType;
    @Nullable
    private CachedValue<PsiField[]> myFieldsCache;
    protected static PsiType INT_ARRAY = PsiType.INT.createArrayType();

    public InnerRClassBase(@NotNull PsiClass context, @NotNull ResourceType resourceType) {
        super(context, resourceType.getName());
        this.myResourceType = resourceType;
    }

    @NotNull
    protected static PsiField[] buildResourceFields(@NotNull ResourceRepository repository, @NotNull ResourceNamespace namespace, @NotNull AndroidLightField.FieldModifier fieldModifier, @NotNull BiPredicate<ResourceType, String> isPublic, @NotNull ResourceType resourceType, @NotNull PsiClass context) {
        ArrayList<Pair<String, ResourceVisibility>> otherFields = new ArrayList<Pair<String, ResourceVisibility>>();
        ArrayList<Pair<String, ResourceVisibility>> styleableFields = new ArrayList<Pair<String, ResourceVisibility>>();
        ArrayList<StyleableAttrFieldUrl> styleableAttrFields = new ArrayList<StyleableAttrFieldUrl>();
        if (resourceType == ResourceType.STYLEABLE) {
            ListMultimap map2 = repository.getResources(namespace, resourceType);
            styleableFields.addAll(ContainerUtil.map((Collection)map2.keySet(), it -> new Pair(it, (Object)(isPublic.test(resourceType, (String)it) ? ResourceVisibility.PUBLIC : ResourceVisibility.PRIVATE))));
            for (ResourceItem item : map2.values()) {
                StyleableResourceValue value2 = (StyleableResourceValue)item.getResourceValue();
                if (value2 == null) continue;
                List attributes = value2.getAllAttributes();
                for (AttrResourceValue attr : attributes) {
                    if (!isPublic.test(attr.getResourceType(), attr.getName())) continue;
                    ResourceNamespace attrNamespace = attr.getNamespace();
                    styleableAttrFields.add(new StyleableAttrFieldUrl(new ResourceReference(namespace, ResourceType.STYLEABLE, item.getName()), new ResourceReference(attrNamespace, ResourceType.ATTR, attr.getName())));
                }
            }
        } else {
            otherFields.addAll(ContainerUtil.map((Collection)repository.getResourceNames(namespace, resourceType), it -> new Pair(it, (Object)(isPublic.test(resourceType, (String)it) ? ResourceVisibility.PUBLIC : ResourceVisibility.PRIVATE))));
        }
        return InnerRClassBase.buildResourceFields(otherFields, styleableFields, styleableAttrFields, resourceType, context, fieldModifier);
    }

    @NotNull
    protected static PsiField[] buildResourceFields(@NotNull Collection<Pair<String, ResourceVisibility>> otherFields, @NotNull Collection<Pair<String, ResourceVisibility>> styleableFields, @NotNull Collection<StyleableAttrFieldUrl> styleableAttrFields, @NotNull ResourceType resourceType, @NotNull PsiClass context, @NotNull AndroidLightField.FieldModifier fieldModifier) {
        AndroidLightField field2;
        int fieldId;
        PsiField[] result2 = new PsiField[otherFields.size() + styleableFields.size() + styleableAttrFields.size()];
        PsiElementFactory factory2 = JavaPsiFacade.getElementFactory((Project)context.getProject());
        int nextId = resourceType.ordinal() * 100000;
        int i2 = 0;
        for (Pair<String, ResourceVisibility> fieldPair : otherFields) {
            fieldId = nextId++;
            field2 = new ResourceLightField((String)fieldPair.getFirst(), context, (PsiType)PsiType.INT, fieldModifier, fieldModifier == AndroidLightField.FieldModifier.FINAL ? Integer.valueOf(fieldId) : null, (ResourceVisibility)fieldPair.getSecond());
            field2.setInitializer(factory2.createExpressionFromText(Integer.toString(fieldId), (PsiElement)field2));
            result2[i2++] = field2;
        }
        for (Pair<String, ResourceVisibility> fieldName : styleableFields) {
            fieldId = nextId++;
            field2 = new ResourceLightField((String)fieldName.getFirst(), context, INT_ARRAY, fieldModifier, fieldModifier == AndroidLightField.FieldModifier.FINAL ? Integer.valueOf(fieldId) : null, (ResourceVisibility)fieldName.getSecond());
            field2.setInitializer(factory2.createExpressionFromText(Integer.toString(fieldId), (PsiElement)field2));
            result2[i2++] = field2;
        }
        for (StyleableAttrFieldUrl fieldContents : styleableAttrFields) {
            fieldId = nextId++;
            field2 = new StyleableAttrLightField(fieldContents, context, fieldModifier, fieldModifier == AndroidLightField.FieldModifier.FINAL ? Integer.valueOf(fieldId) : null);
            field2.setInitializer(factory2.createExpressionFromText(Integer.toString(fieldId), (PsiElement)field2));
            result2[i2++] = field2;
        }
        return result2;
    }

    @Override
    @NotNull
    public PsiField[] getFields() {
        if (this.myFieldsCache == null) {
            this.myFieldsCache = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue(() -> {
                ModificationTracker dependencies2;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Recomputing fields for " + (Object)((Object)this));
                }
                Verify.verify((!((dependencies2 = this.getFieldsDependencies()) instanceof ResourceRepository) ? 1 : 0) != 0, (String)"Resource repository leaked in a CachedValue.", (Object[])new Object[0]);
                return CachedValueProvider.Result.create((Object)this.doGetFields(), (Object[])new Object[]{dependencies2});
            });
        }
        return (PsiField[])this.myFieldsCache.getValue();
    }

    @NotNull
    protected abstract PsiField[] doGetFields();

    @NotNull
    protected abstract ModificationTracker getFieldsDependencies();

    @NotNull
    public ResourceType getResourceType() {
        return this.myResourceType;
    }
}

