/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.resources.ResourceFolderType;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.google.common.collect.ImmutableSet;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.xml.XmlFile;
import com.intellij.xml.XmlSchemaProvider;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.android.dom.manifest.ManifestDomFileDescription;
import org.jetbrains.android.dom.xml.PreferenceClassDomFileDescription;
import org.jetbrains.android.dom.xml.XmlResourceDomFileDescription;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidXmlSchemaProvider
extends XmlSchemaProvider {
    private static final NotNullLazyKey<XmlFile, Project> DUMMY_XSD = NotNullLazyKey.create((String)AndroidXmlSchemaProvider.class.getName(), project -> (XmlFile)PsiFileFactory.getInstance((Project)project).createFileFromText("android.xsd", (Language)XMLLanguage.INSTANCE, (CharSequence)"<dummy />", false, false));

    public XmlFile getSchema(@NotNull @NonNls String url, @Nullable Module module2, @NotNull PsiFile baseFile) {
        return module2 == null ? null : (XmlFile)DUMMY_XSD.getValue((UserDataHolder)module2.getProject());
    }

    public boolean isAvailable(@NotNull XmlFile file2) {
        PsiFile f = file2.getOriginalFile();
        if (!(f instanceof XmlFile)) {
            return false;
        }
        XmlFile originalFile = (XmlFile)f;
        return (Boolean)ReadAction.compute(() -> {
            if (IdeResourcesUtil.isInResourceSubdirectory((PsiFile)originalFile, null)) {
                PsiDirectory parent = originalFile.getParent();
                if (parent == null) {
                    return false;
                }
                ResourceFolderType resType = ResourceFolderType.getFolderType((String)parent.getName());
                return resType != ResourceFolderType.XML || XmlResourceDomFileDescription.isXmlResourceFile(originalFile) || PreferenceClassDomFileDescription.Companion.isPreferenceClassFile(originalFile);
            }
            return ManifestDomFileDescription.isManifestFile(originalFile);
        });
    }

    @NotNull
    public Set<String> getAvailableNamespaces(@NotNull XmlFile file2, @Nullable String tagName) {
        HashSet<String> result2 = new HashSet<String>();
        AndroidFacet facet2 = AndroidFacet.getInstance((PsiElement)file2);
        if (facet2 != null) {
            ResourceFolderType type;
            result2.add("http://schemas.android.com/tools");
            result2.add("http://schemas.android.com/apk/res/android");
            if (ManifestDomFileDescription.isManifestFile(file2)) {
                result2.add("http://schemas.android.com/apk/distribution");
            }
            if ((type = IdeResourcesUtil.getFolderType(file2.getOriginalFile())) != ResourceFolderType.MIPMAP && type != ResourceFolderType.RAW) {
                if (type == ResourceFolderType.DRAWABLE) {
                    result2.add("http://schemas.android.com/aapt");
                }
                if (type == ResourceFolderType.XML || type == ResourceFolderType.VALUES) {
                    result2.add("urn:oasis:names:tc:xliff:document:1.2");
                }
                result2.add(AndroidXmlSchemaProvider.getLocalXmlNamespace(facet2));
                result2.addAll((Collection<String>)AndroidXmlSchemaProvider.getResourceNamespaces(facet2));
            }
        }
        return result2;
    }

    public String getDefaultPrefix(@NotNull @NonNls String namespace, @NotNull XmlFile context) {
        if ("http://schemas.android.com/apk/res/android".equals(namespace)) {
            return "android";
        }
        if (namespace.equals("http://schemas.android.com/apk/distribution")) {
            return "dist";
        }
        if (namespace.equals("http://schemas.android.com/tools")) {
            return "tools";
        }
        if (namespace.equals("http://schemas.android.com/apk/res-auto") || namespace.startsWith("http://schemas.android.com/apk/res/")) {
            return "app";
        }
        if (namespace.equals("urn:oasis:names:tc:xliff:document:1.2")) {
            return "xliff";
        }
        if (namespace.equals("http://schemas.android.com/aapt")) {
            return "aapt";
        }
        return null;
    }

    @NotNull
    private static String getLocalXmlNamespace(@NotNull AndroidFacet facet2) {
        return ResourceRepositoryManager.getInstance(facet2).getNamespace().getXmlNamespaceUri();
    }

    @NotNull
    private static ImmutableSet<String> getResourceNamespaces(@NotNull AndroidFacet facet2) {
        return (ImmutableSet)ResourceRepositoryManager.getAppResources(facet2).getNamespaces().stream().map(ResourceNamespace::getXmlNamespaceUri).collect(ImmutableSet.toImmutableSet());
    }
}

