/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.nativeSymbolizer;

import com.android.tools.idea.util.StudioPathManager;
import com.android.tools.nativeSymbolizer.LlvmSymbolizer;
import com.android.tools.nativeSymbolizer.NativeSymbolizer;
import com.android.tools.nativeSymbolizer.SymbolFilesLocator;
import com.android.tools.nativeSymbolizer.SymbolFilesLocatorKt;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0006\u0010\u0004\u001a\u00020\u0005\u001a\b\u0010\u0006\u001a\u00020\u0007H\u0000\u00a8\u0006\b"}, d2={"createNativeSymbolizer", "Lcom/android/tools/nativeSymbolizer/NativeSymbolizer;", "project", "Lcom/intellij/openapi/project/Project;", "getLlvmSymbolizerPath", "", "getLogger", "Lcom/intellij/openapi/diagnostic/Logger;", "native-symbolizer"})
public final class NativeSymbolizerKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final NativeSymbolizer createNativeSymbolizer(@NotNull Project project) {
        Map<String, Set<File>> symDirMap = SymbolFilesLocatorKt.getArchToSymDirsMap(project);
        String symbolizerPath = NativeSymbolizerKt.getLlvmSymbolizerPath();
        Logger log = NativeSymbolizerKt.getLogger();
        log.info("Creating a native symbolizer. Executable path: " + symbolizerPath);
        Object object = symDirMap;
        boolean bl = false;
        Iterator<Map.Entry<String, Set<File>>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            void arch;
            Map.Entry<String, Set<File>> entry;
            Map.Entry<String, Set<File>> entry2 = entry = iterator.next();
            boolean bl2 = false;
            object = entry2.getKey();
            entry2 = entry;
            bl2 = false;
            Set<File> dirs = entry2.getValue();
            log.debug("Native symbolizer paths for " + (String)arch + " is [" + dirs + ']');
        }
        SymbolFilesLocator symLocator = new SymbolFilesLocator(symDirMap);
        return new LlvmSymbolizer(symbolizerPath, symLocator, 0L, 4, null);
    }

    @NotNull
    public static final String getLlvmSymbolizerPath() {
        String exe = null;
        String os = null;
        if (SystemInfo.isLinux) {
            os = "linux-x86_64";
            exe = "llvm-symbolizer";
        } else if (SystemInfo.isMac) {
            os = "darwin-x86_64";
            exe = "llvm-symbolizer";
        } else if (SystemInfo.isWindows) {
            os = "windows-x86_64";
            exe = "llvm-symbolizer.exe";
        } else {
            throw (Throwable)new IllegalStateException("Unknown operating system");
        }
        Path result2 = StudioPathManager.isRunningFromSources() ? Paths.get(StudioPathManager.getSourcesRoot(), "prebuilts", "tools", os, "lldb", "bin", exe) : Paths.get(PathManager.getBinPath(), "lldb", "bin", exe);
        return ((Object)result2).toString();
    }

    @NotNull
    public static final Logger getLogger() {
        return Logger.getInstance((String)"NativeSymbolizer");
    }
}

