/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.whatsnew.assistant.actions;

import com.android.build.attribution.BuildAttributionStateReporter;
import com.android.build.attribution.ui.BuildAttributionUiManager;
import com.android.tools.idea.assistant.AssistActionState;
import com.android.tools.idea.assistant.AssistActionStateManager;
import com.android.tools.idea.assistant.StatefulButtonNotifier;
import com.android.tools.idea.assistant.datamodel.ActionData;
import com.android.tools.idea.assistant.view.StatefulButtonMessage;
import com.android.tools.idea.assistant.view.UIUtils;
import com.android.tools.idea.whatsnew.assistant.WhatsNewMetricsTracker;
import com.android.tools.idea.whatsnew.assistant.actions.BuildAnalyzerShowActionStateManager$WhenMappings;
import com.android.tools.idea.whatsnew.assistant.actions.BuildAnalyzerShowActionStateManager$sam$java_util_function_Function$0;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.JBColor;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.Color;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0005H\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\b\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J$\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0014\u001a\u0004\u0018\u00010\rH\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\f\u0010\u0018\u001a\u00020\r*\u00020\nH\u0002J\f\u0010\u0019\u001a\u00020\u000f*\u00020\nH\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/idea/whatsnew/assistant/actions/BuildAnalyzerShowActionStateManager;", "Lcom/android/tools/idea/assistant/AssistActionStateManager;", "()V", "projectToConnection", "", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/util/messages/MessageBusConnection;", "connectToNewProject", "newProject", "featureState", "Lcom/android/build/attribution/BuildAttributionStateReporter$State;", "project", "getId", "", "getState", "Lcom/android/tools/idea/assistant/AssistActionState;", "actionData", "Lcom/android/tools/idea/assistant/datamodel/ActionData;", "getStateDisplay", "Lcom/android/tools/idea/assistant/view/StatefulButtonMessage;", "successMessage", "init", "", "requestButtonRefresh", "toButtonMessage", "toButtonState", "ActionState", "whats-new-assistant"})
public final class BuildAnalyzerShowActionStateManager
extends AssistActionStateManager {
    private final Map<Project, MessageBusConnection> projectToConnection;

    @Override
    @NotNull
    public String getId() {
        return "build.analyzer.show";
    }

    @Override
    public void init(@NotNull Project project, @NotNull ActionData actionData) {
        Function1 function1 = (Function1)new Function1<Project, MessageBusConnection>(this){

            @NotNull
            public final MessageBusConnection invoke(@NotNull Project p1) {
                return BuildAnalyzerShowActionStateManager.access$connectToNewProject((BuildAnalyzerShowActionStateManager)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(BuildAnalyzerShowActionStateManager.class);
            }

            public final String getName() {
                return "connectToNewProject";
            }

            public final String getSignature() {
                return "connectToNewProject(Lcom/intellij/openapi/project/Project;)Lcom/intellij/util/messages/MessageBusConnection;";
            }
        };
        this.projectToConnection.computeIfAbsent(project, new BuildAnalyzerShowActionStateManager$sam$java_util_function_Function$0(function1));
        WhatsNewMetricsTracker.getInstance().actionButtonCreated(project, "build.analyzer.show");
    }

    private final MessageBusConnection connectToNewProject(Project newProject) {
        MessageBusConnection connection = newProject.getMessageBus().connect((Disposable)newProject);
        Disposer.register((Disposable)((Disposable)connection), (Disposable)new Disposable(this, newProject){
            final /* synthetic */ BuildAnalyzerShowActionStateManager this$0;
            final /* synthetic */ Project $newProject;

            public final void dispose() {
                BuildAnalyzerShowActionStateManager.access$getProjectToConnection$p(this.this$0).remove(this.$newProject);
            }
            {
                this.this$0 = buildAnalyzerShowActionStateManager;
                this.$newProject = project;
            }
        });
        connection.subscribe(BuildAttributionStateReporter.Companion.getFEATURE_STATE_TOPIC(), (Object)new BuildAttributionStateReporter.Notifier(this, newProject){
            final /* synthetic */ BuildAnalyzerShowActionStateManager this$0;
            final /* synthetic */ Project $newProject;

            public void stateUpdated(@NotNull BuildAttributionStateReporter.State newState) {
                BuildAnalyzerShowActionStateManager.access$requestButtonRefresh(this.this$0, this.$newProject);
                WhatsNewMetricsTracker.getInstance().stateUpdateActionButton(this.$newProject, "build.analyzer.show");
            }
            {
                this.this$0 = this$0;
                this.$newProject = $captured_local_variable$1;
            }
        });
        return connection;
    }

    @Override
    @NotNull
    public AssistActionState getState(@NotNull Project project, @NotNull ActionData actionData) {
        return this.toButtonState(this.featureState(project));
    }

    @Override
    @Nullable
    public StatefulButtonMessage getStateDisplay(@NotNull Project project, @NotNull ActionData actionData, @Nullable String successMessage) {
        BuildAttributionStateReporter.State featureState = this.featureState(project);
        return new StatefulButtonMessage(this.toButtonMessage(featureState), this.toButtonState(featureState), null, 4, null);
    }

    private final BuildAttributionStateReporter.State featureState(Project project) {
        return BuildAttributionUiManager.Companion.getInstance(project).getStateReporter().currentState();
    }

    private final AssistActionState toButtonState(BuildAttributionStateReporter.State $this$toButtonState) {
        AssistActionState assistActionState;
        switch (BuildAnalyzerShowActionStateManager$WhenMappings.$EnumSwitchMapping$0[$this$toButtonState.ordinal()]) {
            case 1: {
                assistActionState = ActionState.REPORT_DATA_READY;
                break;
            }
            case 2: {
                assistActionState = ActionState.BUILD_REQUIRED;
                break;
            }
            case 3: {
                assistActionState = ActionState.BUILD_RUNNING;
                break;
            }
            case 4: {
                assistActionState = ActionState.BUILD_FAILED_TO_COMPLETE;
                break;
            }
            case 5: {
                assistActionState = ActionState.AGP_UPDATE_REQUIRED;
                break;
            }
            case 6: {
                assistActionState = ActionState.FEATURE_TURNED_OFF;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return assistActionState;
    }

    private final String toButtonMessage(BuildAttributionStateReporter.State $this$toButtonMessage) {
        String string;
        switch (BuildAnalyzerShowActionStateManager$WhenMappings.$EnumSwitchMapping$1[$this$toButtonMessage.ordinal()]) {
            case 1: {
                string = "Previous build's report is available. Click to open.";
                break;
            }
            case 2: {
                string = "No report is available.<br/>Click Analyze Build to build your project<br/>and open the Build Analyzer with the new report.";
                break;
            }
            case 3: {
                string = "Generating build report now.";
                break;
            }
            case 4: {
                string = "Build failed to complete.<br/>Resolve any errors and try again.";
                break;
            }
            case 5: {
                string = "Android Gradle Plugin 4.0.0 or higher<br/>is required to use the Build Analyzer.";
                break;
            }
            case 6: {
                string = "";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private final void requestButtonRefresh(Project project) {
        ((StatefulButtonNotifier)project.getMessageBus().syncPublisher(StatefulButtonNotifier.BUTTON_STATE_TOPIC)).stateUpdated();
    }

    public BuildAnalyzerShowActionStateManager() {
        boolean bl = false;
        this.projectToConnection = new LinkedHashMap();
    }

    public static final /* synthetic */ MessageBusConnection access$connectToNewProject(BuildAnalyzerShowActionStateManager $this, Project newProject) {
        return $this.connectToNewProject(newProject);
    }

    public static final /* synthetic */ Map access$getProjectToConnection$p(BuildAnalyzerShowActionStateManager $this) {
        return $this.projectToConnection;
    }

    public static final /* synthetic */ void access$requestButtonRefresh(BuildAnalyzerShowActionStateManager $this, Project project) {
        $this.requestButtonRefresh(project);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B\u001f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u0006H\u0016J\n\u0010\u000b\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010\f\u001a\u00020\u0004H\u0016J\b\u0010\r\u001a\u00020\u0004H\u0016J\b\u0010\u000e\u001a\u00020\u0004H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/whatsnew/assistant/actions/BuildAnalyzerShowActionStateManager$ActionState;", "", "Lcom/android/tools/idea/assistant/AssistActionState;", "buttonActive", "", "messageForegroundColor", "Ljava/awt/Color;", "messageIcon", "Ljavax/swing/Icon;", "(Ljava/lang/String;IZLjava/awt/Color;Ljavax/swing/Icon;)V", "getForeground", "getIcon", "isButtonEnabled", "isButtonVisible", "isMessageVisible", "REPORT_DATA_READY", "BUILD_REQUIRED", "BUILD_RUNNING", "BUILD_FAILED_TO_COMPLETE", "AGP_UPDATE_REQUIRED", "FEATURE_TURNED_OFF", "whats-new-assistant"})
    private static final class ActionState
    extends Enum<ActionState>
    implements AssistActionState {
        public static final /* enum */ ActionState REPORT_DATA_READY;
        public static final /* enum */ ActionState BUILD_REQUIRED;
        public static final /* enum */ ActionState BUILD_RUNNING;
        public static final /* enum */ ActionState BUILD_FAILED_TO_COMPLETE;
        public static final /* enum */ ActionState AGP_UPDATE_REQUIRED;
        public static final /* enum */ ActionState FEATURE_TURNED_OFF;
        private static final /* synthetic */ ActionState[] $VALUES;
        private final boolean buttonActive;
        private final Color messageForegroundColor;
        private final Icon messageIcon;

        static {
            ActionState[] actionStateArray = new ActionState[6];
            ActionState[] actionStateArray2 = actionStateArray;
            actionStateArray[0] = REPORT_DATA_READY = new ActionState(true, UIUtils.getSuccessColor(), AllIcons.RunConfigurations.TestPassed);
            actionStateArray[1] = BUILD_REQUIRED = new ActionState(true, UIUtils.getFailureColor(), AllIcons.General.Warning);
            actionStateArray[2] = BUILD_RUNNING = new ActionState(false, (Color)JBColor.BLACK, (Icon)AnimatedIcon.Default.INSTANCE);
            actionStateArray[3] = BUILD_FAILED_TO_COMPLETE = new ActionState(true, UIUtils.getFailureColor(), AllIcons.General.Error);
            actionStateArray[4] = AGP_UPDATE_REQUIRED = new ActionState(false, (Color)JBColor.BLACK, AllIcons.General.Information);
            actionStateArray[5] = FEATURE_TURNED_OFF = new ActionState(false, (Color)JBColor.BLACK, AllIcons.General.Information);
            $VALUES = actionStateArray;
        }

        @Override
        public boolean isButtonVisible() {
            return true;
        }

        @Override
        public boolean isButtonEnabled() {
            return this.buttonActive;
        }

        @Override
        public boolean isMessageVisible() {
            return true;
        }

        @Override
        @Nullable
        public Icon getIcon() {
            return this.messageIcon;
        }

        @Override
        @NotNull
        public Color getForeground() {
            return this.messageForegroundColor;
        }

        private ActionState(boolean buttonActive, Color messageForegroundColor, Icon messageIcon) {
            this.buttonActive = buttonActive;
            this.messageForegroundColor = messageForegroundColor;
            this.messageIcon = messageIcon;
        }

        public static ActionState[] values() {
            return (ActionState[])$VALUES.clone();
        }

        public static ActionState valueOf(String string) {
            return Enum.valueOf(ActionState.class, string);
        }
    }
}

