/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.repository.io.FileOpUtils;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.avdmanager.AccelerationErrorCode;
import com.android.tools.idea.avdmanager.AccelerationErrorSolution;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.avdmanager.ElevatedCommandLine;
import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.install.InstallableComponent;
import com.android.tools.idea.welcome.install.InstallationIntention;
import com.android.tools.idea.welcome.install.VmInstallerInfo;
import com.android.tools.idea.welcome.install.VmKt;
import com.android.tools.idea.welcome.install.WizardException;
import com.android.tools.idea.welcome.wizard.deprecated.ProgressStep;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Platform;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingAnsiEscapesAwareProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!H\u0002J\u0018\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020\u000bH\u0004J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020!H\u0014J\u0010\u0010(\u001a\u00020&2\u0006\u0010'\u001a\u00020!H\u0004J\u0010\u0010)\u001a\u00020&2\u0006\u0010*\u001a\u00020!H\u0014J\u0010\u0010+\u001a\u00020!2\u0006\u0010'\u001a\u00020!H\u0002J\u0010\u0010,\u001a\u00020&2\u0006\u0010'\u001a\u00020!H\u0014J\u0010\u0010-\u001a\u00020&2\u0006\u0010*\u001a\u00020!H\u0004J\u0010\u0010.\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010/\u001a\u00020\b2\u0006\u00100\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!H\u0002J\u001c\u00101\u001a\u00020\u001a2\n\u00102\u001a\u000603j\u0002`42\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u00105\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u00106\u001a\u00020&H\u0002R\u0012\u0010\n\u001a\u00020\u000bX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000bX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u00067"}, d2={"Lcom/android/tools/idea/welcome/install/Vm;", "Lcom/android/tools/idea/welcome/install/InstallableComponent;", "installerInfo", "Lcom/android/tools/idea/welcome/install/VmInstallerInfo;", "installationIntention", "Lcom/android/tools/idea/welcome/install/InstallationIntention;", "isCustomInstall", "Lcom/android/tools/idea/wizard/dynamic/ScopedStateStore$Key;", "", "(Lcom/android/tools/idea/welcome/install/VmInstallerInfo;Lcom/android/tools/idea/welcome/install/InstallationIntention;Lcom/android/tools/idea/wizard/dynamic/ScopedStateStore$Key;)V", "filePrefix", "", "getFilePrefix", "()Ljava/lang/String;", "installUrl", "getInstallUrl", "<set-?>", "isInstallerSuccessfullyCompleted", "()Z", "progressStep", "Lcom/android/tools/idea/welcome/wizard/deprecated/ProgressStep;", "requiredSdkPackages", "", "getRequiredSdkPackages", "()Ljava/util/List;", "configure", "", "installContext", "Lcom/android/tools/idea/welcome/install/InstallContext;", "sdkHandler", "Lcom/android/sdklib/repository/AndroidSdkHandler;", "configureForUninstall", "sdkRoot", "Ljava/io/File;", "ensureExistsAndIsExecutable", "path", "exeName", "getInstallCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "sdk", "getInstallerBaseCommandLine", "getMacBaseCommandLine", "source", "getSourceLocation", "getUninstallCommandLine", "getWindowsBaseCommandLine", "init", "isInstalled", "context", "printExceptionMessage", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "runInstaller", "commandLine", "intellij.android.core"})
public abstract class Vm
extends InstallableComponent {
    private boolean isInstallerSuccessfullyCompleted;
    private ProgressStep progressStep;
    private final VmInstallerInfo installerInfo;
    @JvmField
    @NotNull
    public final InstallationIntention installationIntention;
    @JvmField
    @NotNull
    public final ScopedStateStore.Key<Boolean> isCustomInstall;

    public final boolean isInstallerSuccessfullyCompleted() {
        return this.isInstallerSuccessfullyCompleted;
    }

    @NotNull
    protected abstract String getInstallUrl();

    @NotNull
    protected abstract String getFilePrefix();

    @NotNull
    public List<String> getRequiredSdkPackages() {
        return CollectionsKt.listOf((Object)this.installerInfo.getRepoPackagePath());
    }

    @Override
    public void init(@NotNull ProgressStep progressStep) {
        this.progressStep = progressStep;
    }

    @NotNull
    protected GeneralCommandLine getInstallCommandLine(@NotNull File sdk) throws IOException, WizardException {
        boolean bl = this.installerInfo.canRun();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Unsupported OS";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return this.getInstallerBaseCommandLine(sdk);
    }

    @NotNull
    protected final GeneralCommandLine getInstallerBaseCommandLine(@NotNull File sdk) throws WizardException, IOException {
        GeneralCommandLine generalCommandLine;
        if (SystemInfo.isMac) {
            generalCommandLine = this.getMacBaseCommandLine(this.getSourceLocation(sdk));
        } else if (SystemInfo.isWindows) {
            generalCommandLine = this.getWindowsBaseCommandLine(this.getSourceLocation(sdk));
        } else {
            throw (Throwable)new IllegalStateException("Unsupported OS");
        }
        return generalCommandLine;
    }

    @NotNull
    protected GeneralCommandLine getUninstallCommandLine(@NotNull File sdk) throws WizardException, IOException {
        GeneralCommandLine generalCommandLine = this.getInstallerBaseCommandLine(sdk);
        boolean bl = false;
        boolean bl2 = false;
        GeneralCommandLine $this$apply = generalCommandLine;
        boolean bl3 = false;
        $this$apply.addParameters(new String[]{"-u"});
        return generalCommandLine;
    }

    @NotNull
    protected GeneralCommandLine getMacBaseCommandLine(@NotNull File source) throws IOException, WizardException {
        throw (Throwable)new IllegalStateException("Unsupported OS");
    }

    @NotNull
    protected final GeneralCommandLine getWindowsBaseCommandLine(@NotNull File source) throws IOException {
        File batFile = new File(source, "silent_install.bat");
        File logFile = FileUtil.createTempFile((String)(this.getFilePrefix() + "_log"), (String)".txt");
        return new ElevatedCommandLine(batFile.getAbsolutePath()).withTempFilePrefix(this.getFilePrefix()).withWorkDirectory(source).withParameters(new String[]{"-log", logFile.getPath()});
    }

    @Override
    public void configure(@NotNull InstallContext installContext, @NotNull AndroidSdkHandler sdkHandler) {
        block8: {
            AccelerationErrorSolution.SolutionCode solutionCode;
            AccelerationErrorCode accelerationErrorCode;
            block7: {
                File sdkRoot = sdkHandler.getLocation();
                if (sdkRoot == null) {
                    installContext.print(this.installerInfo.getFullName$intellij_android_core() + " installer could not be run because SDK root isn't specified", ConsoleViewContentType.ERROR_OUTPUT);
                    return;
                }
                if (this.installationIntention == InstallationIntention.UNINSTALL) {
                    this.configureForUninstall(installContext, sdkRoot);
                    return;
                }
                accelerationErrorCode = this.installerInfo.checkInstallation();
                AccelerationErrorSolution.SolutionCode solution = accelerationErrorCode.getSolution();
                if (accelerationErrorCode == AccelerationErrorCode.ALREADY_INSTALLED) {
                    if (this.installationIntention == InstallationIntention.INSTALL_WITHOUT_UPDATES) {
                        this.isInstallerSuccessfullyCompleted = true;
                        return;
                    }
                    solution = this.installerInfo.getReinstallSolution();
                }
                if ((solutionCode = solution) != this.installerInfo.getInstallSolution() && solutionCode != this.installerInfo.getReinstallSolution()) break block7;
                try {
                    GeneralCommandLine commandLine = this.getInstallCommandLine(sdkRoot);
                    this.runInstaller(installContext, commandLine);
                }
                catch (WizardException e) {
                    this.printExceptionMessage(e, installContext);
                }
                catch (IOException e) {
                    this.printExceptionMessage(e, installContext);
                }
                break block8;
            }
            if (solutionCode != AccelerationErrorSolution.SolutionCode.NONE) break block8;
            String message2 = "Unable to install " + this.installerInfo.getFullName$intellij_android_core() + '\n' + accelerationErrorCode.getProblem() + '\n' + accelerationErrorCode.getSolutionMessage();
            installContext.print(message2, ConsoleViewContentType.ERROR_OUTPUT);
        }
    }

    private final void printExceptionMessage(Exception e, InstallContext installContext) {
        String message2;
        VmKt.access$getLOG$p().warn("Tried to install " + this.installerInfo.getFullName$intellij_android_core() + " on " + Platform.current().name() + " OS with " + AvdManagerConnection.getMemorySize() + " memory size", (Throwable)e);
        installContext.print("Unable to install " + this.installerInfo.getFullName$intellij_android_core() + '\n', ConsoleViewContentType.ERROR_OUTPUT);
        String string = e.getMessage();
        if (string == null) {
            string = message2 = "(unknown)";
        }
        if (!StringUtil.endsWithLineBreak((CharSequence)message2)) {
            message2 = message2 + "\n";
        }
        installContext.print(message2, ConsoleViewContentType.ERROR_OUTPUT);
    }

    private final void configureForUninstall(InstallContext installContext, File sdkRoot) {
        if (this.isInstalled(installContext, sdkRoot)) {
            try {
                GeneralCommandLine commandLine = this.getUninstallCommandLine(sdkRoot);
                this.runInstaller(installContext, commandLine);
            }
            catch (WizardException e) {
                this.printExceptionMessage(e, installContext);
            }
            catch (IOException e) {
                this.printExceptionMessage(e, installContext);
            }
        } else {
            installContext.print(this.installerInfo.getFullName$intellij_android_core() + " is not installed, so not proceeding with its uninstallation.", ConsoleViewContentType.NORMAL_OUTPUT);
            this.isInstallerSuccessfullyCompleted = true;
        }
    }

    private final boolean isInstalled(InstallContext context, File sdkRoot) {
        Function1 printError2 = (Function1)new Function1<Exception, Unit>(this, context){
            final /* synthetic */ Vm this$0;
            final /* synthetic */ InstallContext $context;

            public final void invoke(@NotNull Exception exception) {
                this.$context.print("Failed to determine whether " + Vm.access$getInstallerInfo$p(this.this$0).getFullName$intellij_android_core() + " is installed: " + exception.getMessage(), ConsoleViewContentType.ERROR_OUTPUT);
            }
            {
                this.this$0 = vm;
                this.$context = installContext;
                super(1);
            }
        };
        try {
            GeneralCommandLine command = this.getInstallerBaseCommandLine(sdkRoot);
            command.addParameter("-v");
            OSProcessHandler oSProcessHandler = new OSProcessHandler(command);
            boolean bl = false;
            boolean bl2 = false;
            OSProcessHandler $this$apply = oSProcessHandler;
            boolean bl3 = false;
            $this$apply.startNotify();
            $this$apply.waitFor();
            Integer n = oSProcessHandler.getExitCode();
            return n != null && n == 0;
        }
        catch (ExecutionException exception) {
            printError2.invoke((Object)exception);
        }
        catch (WizardException exception) {
            printError2.invoke((Object)exception);
        }
        catch (IOException exception) {
            printError2.invoke((Object)exception);
        }
        return false;
    }

    private final void runInstaller(InstallContext installContext, GeneralCommandLine commandLine) {
        try {
            ProgressIndicator progressIndicator;
            ProgressIndicator progressIndicator2 = progressIndicator = ProgressManager.getInstance().getProgressIndicator();
            if (progressIndicator2 != null) {
                ProgressIndicator progressIndicator3 = progressIndicator2;
                boolean bl = false;
                boolean bl2 = false;
                ProgressIndicator $this$apply = progressIndicator3;
                boolean bl3 = false;
                $this$apply.setIndeterminate(true);
                $this$apply.setText(this.installerInfo.getRunningInstallerMessage());
            }
            installContext.print(this.installerInfo.getRunningInstallerMessage() + "\n", ConsoleViewContentType.SYSTEM_OUTPUT);
            CapturingAnsiEscapesAwareProcessHandler process = new CapturingAnsiEscapesAwareProcessHandler(commandLine);
            StringBuffer output = new StringBuffer();
            process.addProcessListener((ProcessListener)new ProcessAdapter(output){
                final /* synthetic */ StringBuffer $output;

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
                    this.$output.append(event.getText());
                    super.onTextAvailable(event, outputType);
                }
                {
                    this.$output = $captured_local_variable$0;
                }
            });
            ProgressStep progressStep = this.progressStep;
            if (progressStep == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"progressStep");
            }
            progressStep.attachToProcess((ProcessHandler)process);
            int exitCode = process.runProcess().getExitCode();
            if (exitCode != 0) {
                String file2;
                Object object;
                if (SystemInfo.isWindows && exitCode == 2) {
                    String rebootMessage = "Reboot required: " + this.installerInfo.getFullName$intellij_android_core() + " installation succeeded, however the installer reported that a " + "reboot is required in order for the changes to take effect";
                    installContext.print(rebootMessage, ConsoleViewContentType.NORMAL_OUTPUT);
                    AccelerationErrorSolution.promptAndRebootAsync(rebootMessage, ModalityState.NON_MODAL);
                    this.isInstallerSuccessfullyCompleted = true;
                    ProgressIndicator progressIndicator4 = progressIndicator;
                    if (progressIndicator4 != null) {
                        ProgressIndicator bl3 = progressIndicator4;
                        boolean bl = false;
                        boolean bl4 = false;
                        ProgressIndicator $this$apply = bl3;
                        boolean bl5 = false;
                        $this$apply.setFraction(1.0);
                    }
                    return;
                }
                if (this.installationIntention == InstallationIntention.UNINSTALL) {
                    installContext.print(this.installerInfo.getFullName$intellij_android_core() + " uninstallation failed", ConsoleViewContentType.ERROR_OUTPUT);
                } else {
                    installContext.print(this.installerInfo.getFullName$intellij_android_core() + " installation failed. To install " + this.installerInfo.getFullName$intellij_android_core() + ' ' + "follow the instructions found at: " + this.getInstallUrl(), ConsoleViewContentType.ERROR_OUTPUT);
                }
                String string = (object = Regex.find$default((Regex)new Regex("installation log:\\s*\"(.*)\""), (CharSequence)output.toString(), (int)0, (int)2, null)) != null && (object = object.getGroupValues()) != null ? (String)object.get(1) : (file2 = null);
                if (file2 != null) {
                    installContext.print("Installer log is located at " + file2, ConsoleViewContentType.ERROR_OUTPUT);
                    try {
                        installContext.print("Installer log contents:\n", ConsoleViewContentType.ERROR_OUTPUT);
                        installContext.print(FileUtil.loadFile((File)new File(file2), (String)"UTF-16"), ConsoleViewContentType.NORMAL_OUTPUT);
                    }
                    catch (IOException e) {
                        installContext.print("Failed to read installer output log.\n", ConsoleViewContentType.ERROR_OUTPUT);
                    }
                }
                this.isInstallerSuccessfullyCompleted = false;
            } else {
                this.isInstallerSuccessfullyCompleted = true;
            }
            ProgressIndicator progressIndicator5 = progressIndicator;
            if (progressIndicator5 != null) {
                ProgressIndicator progressIndicator6 = progressIndicator5;
                boolean bl = false;
                boolean bl6 = false;
                ProgressIndicator $this$apply = progressIndicator6;
                boolean bl7 = false;
                $this$apply.setFraction(1.0);
            }
        }
        catch (ExecutionException e) {
            installContext.print("Unable to run " + this.installerInfo.getFullName$intellij_android_core() + " installer: " + e.getMessage() + '\n', ConsoleViewContentType.ERROR_OUTPUT);
            VmKt.access$getLOG$p().warn((Throwable)e);
        }
    }

    @NotNull
    protected final File ensureExistsAndIsExecutable(@NotNull File path2, @NotNull String exeName) throws WizardException {
        File executable = new File(path2, exeName);
        if (!executable.isFile()) {
            throw (Throwable)new WizardException("Installer executable is missing: " + executable.getAbsolutePath());
        }
        if (!executable.canExecute() && !executable.setExecutable(true)) {
            throw (Throwable)new WizardException("Unable to set execute permission bit on installer executable: " + executable.getAbsolutePath());
        }
        return executable;
    }

    private final File getSourceLocation(File sdk) {
        return new File(sdk, FileUtil.join((String[])new String[]{"extras", this.installerInfo.getVendor(), this.installerInfo.getComponentPath()}));
    }

    public Vm(@NotNull VmInstallerInfo installerInfo, @NotNull InstallationIntention installationIntention, @NotNull ScopedStateStore.Key<Boolean> isCustomInstall) {
        super("Performance (" + installerInfo.getFullName$intellij_android_core() + ')', "Enables a hardware-assisted virtualization engine (hypervisor) to speed up Android app emulation on your development computer. (Recommended)", installationIntention == InstallationIntention.INSTALL_WITH_UPDATES, FileOpUtils.create());
        this.installerInfo = installerInfo;
        this.installationIntention = installationIntention;
        this.isCustomInstall = isCustomInstall;
    }

    public static final /* synthetic */ VmInstallerInfo access$getInstallerInfo$p(Vm $this) {
        return $this.installerInfo;
    }
}

