/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.updater.configure;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.SdkVersionInfo;
import com.android.tools.idea.updater.configure.PackageNodeModel;
import com.android.tools.idea.updater.configure.UpdaterTreeNode;
import com.intellij.ui.SimpleTextAttributes;
import java.util.Enumeration;
import java.util.function.Function;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ParentTreeNode
extends UpdaterTreeNode {
    private final AndroidVersion myVersion;
    private final String myTitle;
    private PackageNodeModel.SelectedState myInitialState;

    public ParentTreeNode(@NotNull AndroidVersion version2) {
        this.myVersion = version2;
        this.myTitle = null;
    }

    public ParentTreeNode(@NotNull String title) {
        this.myTitle = title;
        this.myVersion = null;
    }

    @NotNull
    private PackageNodeModel.SelectedState getState(@NotNull Function<UpdaterTreeNode, PackageNodeModel.SelectedState> childStateGetter) {
        boolean foundInstalled = false;
        boolean foundNotInstalled = false;
        Enumeration<TreeNode> children = this.children();
        while (children.hasMoreElements()) {
            UpdaterTreeNode child = (UpdaterTreeNode)children.nextElement();
            PackageNodeModel.SelectedState childState = childStateGetter.apply(child);
            if (childState != PackageNodeModel.SelectedState.INSTALLED) {
                foundNotInstalled = true;
            }
            if (childState == PackageNodeModel.SelectedState.NOT_INSTALLED) continue;
            foundInstalled = true;
        }
        if (foundInstalled && foundNotInstalled) {
            return PackageNodeModel.SelectedState.MIXED;
        }
        if (foundInstalled) {
            return PackageNodeModel.SelectedState.INSTALLED;
        }
        return PackageNodeModel.SelectedState.NOT_INSTALLED;
    }

    @Override
    @NotNull
    public PackageNodeModel.SelectedState getInitialState() {
        if (this.myInitialState == null) {
            this.myInitialState = this.getState(UpdaterTreeNode::getInitialState);
        }
        return this.myInitialState;
    }

    @Override
    protected boolean canHaveMixedState() {
        return this.getInitialState() == PackageNodeModel.SelectedState.MIXED;
    }

    @Override
    @NotNull
    public PackageNodeModel.SelectedState getCurrentState() {
        return this.getState(UpdaterTreeNode::getCurrentState);
    }

    @Override
    public int compareTo(@NotNull UpdaterTreeNode other) {
        if (!(other instanceof ParentTreeNode)) {
            return super.compareTo(other);
        }
        if (this.myVersion == null) {
            return ((ParentTreeNode)other).myVersion == null ? 0 : -1;
        }
        if (((ParentTreeNode)other).myVersion == null) {
            return 1;
        }
        return this.myVersion.compareTo(((ParentTreeNode)other).myVersion);
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof ParentTreeNode)) {
            return false;
        }
        if (this.myVersion != null) {
            return this.myVersion.equals((Object)((ParentTreeNode)obj).myVersion);
        }
        return this.getStatusString().equals(((ParentTreeNode)obj).getStatusString());
    }

    @Override
    public void customizeRenderer(UpdaterTreeNode.Renderer renderer2, JTree tree, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String title = this.myTitle;
        if (title == null) {
            title = SdkVersionInfo.getVersionWithCodename((AndroidVersion)this.myVersion);
        }
        renderer2.getTextRenderer().append(title, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
    }

    @Override
    protected void setState(PackageNodeModel.SelectedState state) {
        Enumeration<TreeNode> children = this.children();
        while (children.hasMoreElements()) {
            UpdaterTreeNode child = (UpdaterTreeNode)children.nextElement();
            child.setState(state == PackageNodeModel.SelectedState.MIXED ? child.getInitialState() : state);
        }
    }
}

