/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.tools.adtui.actions.ZoomType;
import com.android.tools.idea.actions.DesignerDataKeys;
import com.android.tools.idea.actions.LayoutPreviewHandler;
import com.android.tools.idea.actions.LayoutPreviewHandlerKt;
import com.android.tools.idea.common.editor.ActionManager;
import com.android.tools.idea.common.error.IssueProvider;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.DefaultSelectionModel;
import com.android.tools.idea.common.model.DnDTransferComponent;
import com.android.tools.idea.common.model.DnDTransferItem;
import com.android.tools.idea.common.model.ItemTransferable;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.ScaleKt;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.DesignSurfaceActionHandler;
import com.android.tools.idea.common.surface.DesignSurfaceListener;
import com.android.tools.idea.common.surface.InteractionHandler;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.BuildSettings;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.rendering.RenderErrorModelFactory;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.RenderSettings;
import com.android.tools.idea.rendering.errors.ui.RenderErrorModel;
import com.android.tools.idea.uibuilder.adaptiveicon.ShapeMenuAction;
import com.android.tools.idea.uibuilder.analytics.NlAnalyticsManager;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.editor.NlActionManager;
import com.android.tools.idea.uibuilder.error.RenderIssueProvider;
import com.android.tools.idea.uibuilder.mockup.editor.MockupEditor;
import com.android.tools.idea.uibuilder.model.NlComponentHelper;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.android.tools.idea.uibuilder.scene.RenderListener;
import com.android.tools.idea.uibuilder.surface.AccessoryPanel;
import com.android.tools.idea.uibuilder.surface.LayoutScannerControl;
import com.android.tools.idea.uibuilder.surface.LayoutScannerEnabled;
import com.android.tools.idea.uibuilder.surface.NlDesignSurfaceActionHandler;
import com.android.tools.idea.uibuilder.surface.NlDesignSurfacePositionableContentLayoutManager;
import com.android.tools.idea.uibuilder.surface.NlInteractionHandler;
import com.android.tools.idea.uibuilder.surface.NlLayoutScannerControl;
import com.android.tools.idea.uibuilder.surface.NlScreenViewProvider;
import com.android.tools.idea.uibuilder.surface.ScreenViewProvider;
import com.android.tools.idea.uibuilder.surface.layout.SingleDirectionLayoutManager;
import com.android.tools.idea.uibuilder.surface.layout.SurfaceLayoutManager;
import com.android.utils.ImmutableCollectors;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Update;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlDesignSurface
extends DesignSurface
implements ViewGroupHandler.AccessoryPanelVisibility,
LayoutPreviewHandler {
    private boolean myPreviewWithToolsVisibilityAndPosition = true;
    private static final double DEFAULT_MIN_SCALE = 0.1;
    private static final double DEFAULT_MAX_SCALE = 10.0;
    @Nullable
    private final DataProvider myDelegateDataProvider;
    @NotNull
    private ScreenViewProvider myScreenViewProvider = NlScreenViewProvider.Companion.loadPreferredMode();
    private boolean myIsCanvasResizing = false;
    private boolean myShowModelNames = false;
    private boolean myMockupVisible;
    private MockupEditor myMockupEditor;
    private final boolean myIsInPreview;
    private ShapeMenuAction.AdaptiveIconShape myAdaptiveIconShape = ShapeMenuAction.AdaptiveIconShape.getDefaultShape();
    private final RenderListener myRenderListener = this::modelRendered;
    @NotNull
    private ImmutableList<? extends IssueProvider> myRenderIssueProviders = ImmutableList.of();
    private AccessoryPanel myAccessoryPanel = new AccessoryPanel(AccessoryPanel.Type.SOUTH_PANEL, true);
    @NotNull
    private final NlAnalyticsManager myAnalyticsManager;
    private final BiFunction<NlDesignSurface, NlModel, LayoutlibSceneManager> mySceneManagerProvider;
    @NotNull
    private SurfaceLayoutManager myLayoutManager;
    @Nullable
    private final NavigationHandler myNavigationHandler;
    private final double myMinScale;
    private final double myMaxScale;
    private boolean myIsRenderingSynchronously = false;
    private boolean myIsAnimationScrubbing = false;
    private final Dimension myScrollableViewMinSize = new Dimension();
    @Nullable
    private LayoutScannerControl myValidatorControl;

    private NlDesignSurface(@NotNull Project project, @NotNull Disposable parentDisposable, boolean isInPreview, boolean isEditable, boolean showModelNames, @NotNull BiFunction<NlDesignSurface, NlModel, LayoutlibSceneManager> sceneManagerProvider, @NotNull SurfaceLayoutManager defaultLayoutManager, @NotNull Function<DesignSurface, ActionManager<? extends DesignSurface>> actionManagerProvider, @NotNull Function<DesignSurface, InteractionHandler> interactionHandlerProvider, @Nullable NavigationHandler navigationHandler, double minScale, double maxScale, @NotNull ZoomType onChangeZoom, @NotNull Function<DesignSurface, DesignSurfaceActionHandler> actionHandlerProvider, @Nullable DataProvider delegateDataProvider, @NotNull SelectionModel selectionModel) {
        super(project, parentDisposable, actionManagerProvider, interactionHandlerProvider, isEditable, onChangeZoom, surface2 -> new NlDesignSurfacePositionableContentLayoutManager((NlDesignSurface)surface2, defaultLayoutManager), actionHandlerProvider, selectionModel);
        this.myAnalyticsManager = new NlAnalyticsManager(this);
        this.myAccessoryPanel.setSurface(this);
        this.myIsInPreview = isInPreview;
        this.myShowModelNames = showModelNames;
        this.myLayoutManager = defaultLayoutManager;
        this.mySceneManagerProvider = sceneManagerProvider;
        this.myNavigationHandler = navigationHandler;
        if (this.myNavigationHandler != null) {
            Disposer.register((Disposable)this, (Disposable)this.myNavigationHandler);
        }
        this.myMinScale = minScale;
        this.myMaxScale = maxScale;
        if (((Boolean)StudioFlags.NELE_LAYOUT_SCANNER_IN_EDITOR.get()).booleanValue()) {
            this.myValidatorControl = new NlLayoutScannerControl(this, this);
        }
        this.myDelegateDataProvider = delegateDataProvider;
    }

    @NotNull
    public static LayoutlibSceneManager defaultSceneManagerProvider(@NotNull NlDesignSurface surface2, @NotNull NlModel model2) {
        LayoutlibSceneManager sceneManager = new LayoutlibSceneManager(model2, surface2, new LayoutScannerEnabled());
        RenderSettings settings = RenderSettings.getProjectSettings(model2.getProject());
        sceneManager.setShowDecorations(settings.getShowDecorations());
        sceneManager.setUseImagePool(settings.getUseLiveRendering());
        sceneManager.setQuality(settings.getQuality());
        return sceneManager;
    }

    @NotNull
    public static SurfaceLayoutManager createDefaultSurfaceLayoutManager() {
        return new SingleDirectionLayoutManager(50, 50, 48, 48, SingleDirectionLayoutManager.Alignment.CENTER);
    }

    @NotNull
    public static ActionManager<? extends NlDesignSurface> defaultActionManagerProvider(@NotNull DesignSurface surface2) {
        return new NlActionManager((NlDesignSurface)surface2);
    }

    @NotNull
    public static NlInteractionHandler defaultInteractionHandlerProvider(@NotNull DesignSurface surface2) {
        return new NlInteractionHandler(surface2);
    }

    @NotNull
    public static NlDesignSurfaceActionHandler defaultActionHandlerProvider(@NotNull DesignSurface surface2) {
        return new NlDesignSurfaceActionHandler(surface2);
    }

    @NotNull
    public static Builder builder(@NotNull Project project, @NotNull Disposable parentDisposable) {
        return new Builder(project, parentDisposable);
    }

    @Override
    @NotNull
    protected SceneManager createSceneManager(@NotNull NlModel model2) {
        LayoutlibSceneManager manager = this.mySceneManagerProvider.apply(this, model2);
        manager.addRenderListener(this.myRenderListener);
        return manager;
    }

    @Override
    @NotNull
    public NlAnalyticsManager getAnalyticsManager() {
        return this.myAnalyticsManager;
    }

    public boolean isPreviewSurface() {
        return this.myIsInPreview;
    }

    public void setResizeMode(boolean isResizing) {
        this.myIsCanvasResizing = isResizing;
        this.myScrollPane.setAutoscrolls(isResizing);
    }

    public boolean isCanvasResizing() {
        return this.myIsCanvasResizing;
    }

    @Override
    public boolean isLayoutDisabled() {
        return this.myIsCanvasResizing;
    }

    public boolean isShowModelNames() {
        return this.myShowModelNames;
    }

    @NotNull
    public ScreenViewProvider getScreenViewProvider() {
        return this.myScreenViewProvider;
    }

    public void setScreenViewProvider(@NotNull ScreenViewProvider screenViewProvider, boolean setAsDefault) {
        if (setAsDefault && screenViewProvider instanceof NlScreenViewProvider) {
            NlScreenViewProvider.Companion.savePreferredMode((NlScreenViewProvider)screenViewProvider);
        }
        if (screenViewProvider != this.myScreenViewProvider) {
            this.myScreenViewProvider = screenViewProvider;
            for (SceneManager manager : this.getSceneManagers()) {
                manager.updateSceneView();
                manager.requestLayoutAndRender(false);
            }
            this.revalidateScrollArea();
        }
    }

    @Nullable
    public NavigationHandler getNavigationHandler() {
        return this.myNavigationHandler;
    }

    @NotNull
    public static NlDesignSurface build(@NotNull Project project, @NotNull Disposable parentDisposable) {
        return new Builder(project, parentDisposable).build();
    }

    @Override
    @Nullable
    public LayoutlibSceneManager getSceneManager() {
        return (LayoutlibSceneManager)super.getSceneManager();
    }

    public void forceLayersPaint(boolean value2) {
        for (SceneView view : this.getSceneViews()) {
            view.setForceLayersRepaint(value2);
        }
        this.repaint();
    }

    @Override
    @Nullable
    public SceneView getSceneView(int x, int y) {
        LayoutlibSceneManager manager;
        SceneView view = this.getHoverSceneView(x, y);
        if (view == null && (manager = this.getSceneManager()) != null) {
            view = manager.getSceneView();
        }
        return view;
    }

    @Override
    @Nullable
    public SceneView getHoverSceneView(int x, int y) {
        ImmutableCollection<SceneView> sceneViews = this.getSceneViews();
        Dimension scaledSize = new Dimension();
        for (SceneView view : sceneViews) {
            ScaleKt.scaleBy(view.getContentSize(scaledSize), view.getScale());
            if (view.getX() > x || x > view.getX() + scaledSize.width || view.getY() > y || y > view.getY() + scaledSize.height) continue;
            return view;
        }
        return null;
    }

    @Override
    @NotNull
    protected ImmutableCollection<SceneView> getSceneViews() {
        ImmutableList.Builder builder2 = new ImmutableList.Builder();
        builder2.addAll(super.getSceneViews());
        for (SceneManager manager : this.getSceneManagers()) {
            SceneView secondarySceneView = ((LayoutlibSceneManager)manager).getSecondarySceneView();
            if (secondarySceneView == null) continue;
            builder2.add((Object)secondarySceneView);
        }
        return builder2.build();
    }

    public void setAdaptiveIconShape(@NotNull ShapeMenuAction.AdaptiveIconShape adaptiveIconShape) {
        this.myAdaptiveIconShape = adaptiveIconShape;
    }

    @NotNull
    public ShapeMenuAction.AdaptiveIconShape getAdaptiveIconShape() {
        return this.myAdaptiveIconShape;
    }

    @Override
    @NotNull
    public AccessoryPanel getAccessoryPanel() {
        return this.myAccessoryPanel;
    }

    public void showInspectorAccessoryPanel(boolean show) {
        for (DesignSurfaceListener listener2 : ImmutableList.copyOf((Collection)this.myListeners)) {
            listener2.showAccessoryPanel(this, show);
        }
    }

    @Override
    public void show(@NotNull AccessoryPanel.Type type, boolean show) {
        this.showInspectorAccessoryPanel(show);
    }

    @Override
    public double getScreenScalingFactor() {
        return JBUIScale.sysScale((Component)((Object)this));
    }

    @Override
    @NotNull
    public ActionManager<NlDesignSurface> getActionManager() {
        return super.getActionManager();
    }

    @Override
    @NotNull
    public ItemTransferable getSelectionAsTransferable() {
        NlModel model2 = this.getModel();
        ImmutableList components = (ImmutableList)this.getSelectionModel().getSelection().stream().map(component -> new DnDTransferComponent(component.getTagName(), component.getTagDeprecated().getText(), NlComponentHelperKt.getW(component), NlComponentHelperKt.getH(component))).collect(ImmutableCollectors.toImmutableList());
        return new ItemTransferable(new DnDTransferItem(model2 != null ? model2.getId() : 0L, (ImmutableList<DnDTransferComponent>)components));
    }

    @Override
    protected Dimension getDefaultOffset() {
        return new Dimension(100, 100);
    }

    @Override
    @NotNull
    protected Dimension getPreferredContentSize(int availableWidth, int availableHeight) {
        Dimension extent = this.getExtentSize();
        return ((NlDesignSurfacePositionableContentLayoutManager)this.getSceneViewLayoutManager()).getLayoutManager().getPreferredSize(this.getPositionableContent(), extent.width, extent.height, null);
    }

    @Override
    public CompletableFuture<Void> setModel(@Nullable NlModel model2) {
        this.myAccessoryPanel.setModel(model2);
        return super.setModel(model2);
    }

    @Override
    public void dispose() {
        this.myAccessoryPanel.setSurface(null);
        super.dispose();
    }

    @Override
    public void notifyComponentActivate(@NotNull NlComponent component, int x, int y) {
        ViewHandler handler2 = NlComponentHelperKt.getViewHandler(component);
        if (handler2 != null) {
            handler2.onActivateInDesignSurface(component, this.getSceneManager().getViewEditor(), x, y);
        }
        super.notifyComponentActivate(component, x, y);
    }

    @Override
    @NotNull
    public Consumer<NlComponent> getComponentRegistrar() {
        return component -> NlComponentHelper.INSTANCE.registerComponent((NlComponent)component);
    }

    public void setMockupVisible(boolean mockupVisible) {
        this.myMockupVisible = mockupVisible;
        this.repaint();
    }

    public boolean isMockupVisible() {
        return this.myMockupVisible;
    }

    public void setMockupEditor(@Nullable MockupEditor mockupEditor) {
        this.myMockupEditor = mockupEditor;
    }

    @Nullable
    public MockupEditor getMockupEditor() {
        return this.myMockupEditor;
    }

    public void updateErrorDisplay() {
        if (this.myIsRenderingSynchronously) {
            return;
        }
        assert (ApplicationManager.getApplication().isDispatchThread() || !ApplicationManager.getApplication().isReadAccessAllowed()) : "Do not hold read lock when calling updateErrorDisplay!";
        this.getErrorQueue().cancelAllUpdates();
        this.getErrorQueue().queue(new Update("errors"){

            public void run() {
                Project project;
                Map results = NlDesignSurface.this.getSceneManagers().stream().filter(LayoutlibSceneManager.class::isInstance).map(LayoutlibSceneManager.class::cast).filter(sceneManager -> sceneManager.getRenderResult() != null).collect(Collectors.toMap(Function.identity(), LayoutlibSceneManager::getRenderResult));
                if (results.isEmpty()) {
                    return;
                }
                if (((Boolean)StudioFlags.NELE_LAYOUT_SCANNER_IN_EDITOR.get()).booleanValue() && NlDesignSurface.this.myValidatorControl != null) {
                    for (Map.Entry entry : results.entrySet()) {
                        NlDesignSurface.this.myValidatorControl.getScanner().validateAndUpdateLint(entry.getValue(), ((LayoutlibSceneManager)entry.getKey()).getModel());
                    }
                }
                if ((project = NlDesignSurface.this.getProject()).isDisposed()) {
                    return;
                }
                DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> {
                    BuildMode gradleBuildMode = BuildSettings.getInstance(project).getBuildMode();
                    ImmutableList renderIssueProviders = null;
                    if (gradleBuildMode != null) {
                        for (Map.Entry entry2 : results.entrySet()) {
                            if (!((RenderResult)entry2.getValue()).getLogger().hasErrors()) continue;
                            renderIssueProviders = ImmutableList.of((Object)new RenderIssueProvider(((LayoutlibSceneManager)entry2.getKey()).getModel(), RenderErrorModel.STILL_BUILDING_ERROR_MODEL));
                            break;
                        }
                    }
                    if (renderIssueProviders == null) {
                        renderIssueProviders = (ImmutableList)results.entrySet().stream().map(entry -> {
                            RenderErrorModel errorModel = RenderErrorModelFactory.createErrorModel(NlDesignSurface.this, (RenderResult)entry.getValue(), DataManager.getInstance().getDataContext((Component)NlDesignSurface.this.getIssuePanel()));
                            return new RenderIssueProvider(((LayoutlibSceneManager)entry.getKey()).getModel(), errorModel);
                        }).collect(ImmutableList.toImmutableList());
                    }
                    NlDesignSurface.this.myRenderIssueProviders.forEach(renderIssueProvider -> NlDesignSurface.this.getIssueModel().removeIssueProvider((IssueProvider)renderIssueProvider));
                    NlDesignSurface.this.myRenderIssueProviders = renderIssueProviders;
                    renderIssueProviders.forEach(renderIssueProvider -> NlDesignSurface.this.getIssueModel().addIssueProvider((IssueProvider)renderIssueProvider));
                });
            }

            public boolean canEat(Update update2) {
                return true;
            }
        });
    }

    private void modelRendered() {
        this.updateErrorDisplay();
        UIUtil.invokeLaterIfNeeded(() -> this.revalidateScrollArea());
    }

    @Override
    @NotNull
    public CompletableFuture<Void> forceUserRequestedRefresh() {
        return this.requestSequentialRender(manager -> ((LayoutlibSceneManager)manager).requestUserInitiatedRender());
    }

    @Override
    protected boolean useSmallProgressIcon() {
        if (this.getFocusedSceneView() == null) {
            return false;
        }
        LayoutlibSceneManager manager = this.getSceneManager();
        assert (manager != null);
        return manager.getRenderResult() != null;
    }

    @Override
    protected double getMinScale() {
        return Math.max(this.getFitScale(true), this.myMinScale);
    }

    @Override
    protected double getMaxScale() {
        return this.myMaxScale;
    }

    @Override
    public boolean canZoomToFit() {
        double minZoomLevel = this.myMinScale;
        double maxZoomLevel = this.myMaxScale;
        double zoomToFitLevel = Math.max(minZoomLevel, Math.min(this.getFitScale(true), maxZoomLevel));
        return Math.abs(this.getScale() - zoomToFitLevel) > 0.005 / this.getScreenScalingFactor();
    }

    @Override
    public boolean canZoomToActual() {
        double scaleOfActual;
        double currentScale = this.getScale();
        return currentScale > (scaleOfActual = 1.0 / this.getScreenScalingFactor()) && this.canZoomOut() || currentScale < scaleOfActual && this.canZoomIn();
    }

    @Override
    public void scrollToCenter(@NotNull List<NlComponent> list) {
        Scene scene = this.getScene();
        SceneView view = this.getFocusedSceneView();
        if (list.isEmpty() || scene == null || view == null) {
            return;
        }
        Rectangle componentsArea = new Rectangle(0, 0, -1, -1);
        Rectangle componentRect = new Rectangle();
        list.stream().filter(nlComponent -> !nlComponent.isRoot()).forEach(nlComponent -> {
            SceneComponent component = scene.getSceneComponent((NlComponent)nlComponent);
            if (component == null) {
                return;
            }
            component.fillRect(componentRect);
            if (componentsArea.width < 0) {
                componentsArea.setBounds(componentRect);
            } else {
                componentsArea.add(componentRect);
            }
        });
        Rectangle areaToCenter = Coordinates.getSwingRectDip(view, componentsArea);
        if (areaToCenter.isEmpty() || this.getLayeredPane().getVisibleRect().contains(areaToCenter)) {
            return;
        }
        Dimension swingViewportSize = this.getExtentSize();
        int targetSwingX = (int)areaToCenter.getCenterX();
        int targetSwingY = (int)areaToCenter.getCenterY();
        this.setScrollPosition(targetSwingX - swingViewportSize.width / 2, targetSwingY - swingViewportSize.height / 2);
        double fitScale = this.getFitScale(areaToCenter.getSize(), false);
        if (this.getScale() > fitScale) {
            this.setScale(fitScale, targetSwingX, targetSwingY);
        }
    }

    @Override
    protected void notifySelectionListeners(@NotNull List<NlComponent> newSelection) {
        super.notifySelectionListeners(newSelection);
        this.scrollToCenter(newSelection);
    }

    @Override
    @NotNull
    public List<NlComponent> getSelectableComponents() {
        NlModel model2 = this.getModel();
        if (model2 == null) {
            return Collections.emptyList();
        }
        ImmutableList<NlComponent> roots = model2.getComponents();
        if (roots.isEmpty()) {
            return Collections.emptyList();
        }
        NlComponent root2 = (NlComponent)roots.get(0);
        if (root2 == null) {
            return Collections.emptyList();
        }
        return root2.flatten().collect(Collectors.toList());
    }

    public void setRenderSynchronously(boolean enabled) {
        this.myIsRenderingSynchronously = enabled;
    }

    public boolean isRenderingSynchronously() {
        return this.myIsRenderingSynchronously;
    }

    public void setAnimationScrubbing(boolean value2) {
        this.myIsAnimationScrubbing = value2;
    }

    public boolean isInAnimationScrubbing() {
        return this.myIsAnimationScrubbing;
    }

    public void setScrollableViewMinSize(@NotNull Dimension dimension2) {
        this.myScrollableViewMinSize.setSize(dimension2);
    }

    @Override
    public final Object getData(@NotNull String dataId) {
        Object data;
        Object object = data = this.myDelegateDataProvider != null ? this.myDelegateDataProvider.getData(dataId) : null;
        if (data != null) {
            return data;
        }
        if (LayoutPreviewHandlerKt.LAYOUT_PREVIEW_HANDLER_KEY.is(dataId)) {
            return this;
        }
        if (DesignerDataKeys.LAYOUT_SCANNER_KEY.is(dataId)) {
            return this.myValidatorControl;
        }
        return super.getData(dataId);
    }

    @Override
    public boolean getPreviewWithToolsVisibilityAndPosition() {
        return this.myPreviewWithToolsVisibilityAndPosition;
    }

    @Override
    public void setPreviewWithToolsVisibilityAndPosition(boolean isPreviewWithToolsVisibilityAndPosition) {
        if (this.myPreviewWithToolsVisibilityAndPosition != isPreviewWithToolsVisibilityAndPosition) {
            this.myPreviewWithToolsVisibilityAndPosition = isPreviewWithToolsVisibilityAndPosition;
            this.forceUserRequestedRefresh();
        }
    }

    @NotNull
    Dimension getScrollableViewMinSize() {
        return this.myScrollableViewMinSize;
    }

    public static interface NavigationHandler
    extends Disposable {
        public boolean handleNavigate(@NotNull SceneView var1, @NotNull SceneComponent var2, int var3, int var4, boolean var5);
    }

    public static class Builder {
        private final Project myProject;
        private final Disposable myParentDisposable;
        private boolean myIsPreview = false;
        private BiFunction<NlDesignSurface, NlModel, LayoutlibSceneManager> mySceneManagerProvider = NlDesignSurface::defaultSceneManagerProvider;
        private boolean myShowModelName = false;
        private boolean myIsEditable = true;
        private SurfaceLayoutManager myLayoutManager;
        private NavigationHandler myNavigationHandler;
        private double myMinScale = 0.1;
        private double myMaxScale = 10.0;
        @NotNull
        private ZoomType myOnChangeZoom = ZoomType.FIT_INTO;
        @Nullable
        private DataProvider myDelegateDataProvider = null;
        private Function<DesignSurface, ActionManager<? extends DesignSurface>> myActionManagerProvider = NlDesignSurface::defaultActionManagerProvider;
        private Function<DesignSurface, InteractionHandler> myInteractionHandlerProvider = NlDesignSurface::defaultInteractionHandlerProvider;
        private Function<DesignSurface, DesignSurfaceActionHandler> myActionHandlerProvider = NlDesignSurface::defaultActionHandlerProvider;
        @Nullable
        private SelectionModel mySelectionModel = null;

        private Builder(@NotNull Project project, @NotNull Disposable parentDisposable) {
            this.myProject = project;
            this.myParentDisposable = parentDisposable;
        }

        @NotNull
        public Builder setIsPreview(boolean isPreview) {
            this.myIsPreview = isPreview;
            return this;
        }

        @NotNull
        public Builder setSceneManagerProvider(@NotNull BiFunction<NlDesignSurface, NlModel, LayoutlibSceneManager> sceneManagerProvider) {
            this.mySceneManagerProvider = sceneManagerProvider;
            return this;
        }

        @NotNull
        public Builder showModelNames() {
            this.myShowModelName = true;
            return this;
        }

        @NotNull
        public Builder setLayoutManager(@NotNull SurfaceLayoutManager layoutManager) {
            this.myLayoutManager = layoutManager;
            return this;
        }

        @NotNull
        public Builder setActionManagerProvider(@NotNull Function<DesignSurface, ActionManager<? extends DesignSurface>> actionManagerProvider) {
            this.myActionManagerProvider = actionManagerProvider;
            return this;
        }

        @NotNull
        public Builder setEditable(boolean editable) {
            this.myIsEditable = editable;
            return this;
        }

        @NotNull
        public Builder setInteractionHandlerProvider(@NotNull Function<DesignSurface, InteractionHandler> interactionHandlerProvider) {
            this.myInteractionHandlerProvider = interactionHandlerProvider;
            return this;
        }

        @NotNull
        public Builder setNavigationHandler(NavigationHandler navigationHandler) {
            this.myNavigationHandler = navigationHandler;
            return this;
        }

        public Builder setMinScale(double scale) {
            if (scale <= 0.0) {
                throw new IllegalStateException("The min scale (" + scale + ") is not larger than 0");
            }
            this.myMinScale = scale;
            return this;
        }

        public Builder setMaxScale(double scale) {
            this.myMaxScale = scale;
            return this;
        }

        public Builder setOnConfigurationChangedZoom(@NotNull ZoomType onChangeZoom) {
            this.myOnChangeZoom = onChangeZoom;
            return this;
        }

        @NotNull
        public Builder setActionHandler(@NotNull Function<DesignSurface, DesignSurfaceActionHandler> actionHandlerProvider) {
            this.myActionHandlerProvider = actionHandlerProvider;
            return this;
        }

        @NotNull
        public Builder setDelegateDataProvider(@NotNull DataProvider dataProvider) {
            this.myDelegateDataProvider = dataProvider;
            return this;
        }

        @NotNull
        public Builder setSelectionModel(@NotNull SelectionModel selectionModel) {
            this.mySelectionModel = selectionModel;
            return this;
        }

        @NotNull
        public NlDesignSurface build() {
            SurfaceLayoutManager layoutManager;
            SurfaceLayoutManager surfaceLayoutManager = layoutManager = this.myLayoutManager != null ? this.myLayoutManager : NlDesignSurface.createDefaultSurfaceLayoutManager();
            if (this.myMinScale > this.myMaxScale) {
                throw new IllegalStateException("The max scale (" + this.myMaxScale + ") is lower than min scale (" + this.myMinScale + ")");
            }
            return new NlDesignSurface(this.myProject, this.myParentDisposable, this.myIsPreview, this.myIsEditable, this.myShowModelName, this.mySceneManagerProvider, layoutManager, this.myActionManagerProvider, this.myInteractionHandlerProvider, this.myNavigationHandler, this.myMinScale, this.myMaxScale, this.myOnChangeZoom, this.myActionHandlerProvider, this.myDelegateDataProvider, this.mySelectionModel != null ? this.mySelectionModel : new DefaultSelectionModel());
        }
    }
}

