/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.structure;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Locale;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class NlComponentTreeModel
implements TreeModel {
    private final NlComponent myRoot;

    NlComponentTreeModel() {
        this.myRoot = null;
    }

    NlComponentTreeModel(@NotNull NlModel model2) {
        ImmutableList<NlComponent> components = model2.getComponents();
        this.myRoot = components.isEmpty() ? null : (NlComponent)components.get(0);
    }

    @Override
    @Nullable
    public Object getRoot() {
        return this.myRoot;
    }

    @Override
    @NotNull
    public Object getChild(@NotNull Object parent, int i2) {
        int count;
        if (!(parent instanceof NlComponent)) {
            throw new IllegalArgumentException(String.format(Locale.US, "Parent can only be an NlComponent but is %s.", parent.toString()));
        }
        NlComponent component = (NlComponent)parent;
        ViewGroupHandler handler2 = NlComponentHelperKt.getViewGroupHandler(component);
        int n = count = handler2 == null ? ((NlComponent)parent).getChildCount() : handler2.getComponentTreeChildCount(component);
        if (i2 < 0 || i2 >= count) {
            Logger.getInstance(NlComponentTreeModel.class).error(String.format(Locale.US, "Index out of bounds for NlComponent.getChild. Index %d,  Parent: %s", i2, ((NlComponent)parent).getTagName()));
            return "";
        }
        Object object = handler2 == null ? component.getChild(i2) : handler2.getComponentTreeChild(component, i2);
        return object != null ? object : "";
    }

    @Override
    public int getChildCount(@NotNull Object parent) {
        if (parent instanceof NlComponent) {
            NlComponent component = (NlComponent)parent;
            ViewGroupHandler handler2 = NlComponentHelperKt.getViewGroupHandler(component);
            if (handler2 != null) {
                return handler2.getComponentTreeChildCount(component);
            }
            return component.getChildCount();
        }
        return 0;
    }

    @Override
    public boolean isLeaf(@NotNull Object node2) {
        return this.getChildCount(node2) == 0;
    }

    @Override
    public void valueForPathChanged(@Nullable TreePath path2, @Nullable Object newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getIndexOfChild(@NotNull Object parent, @NotNull Object child) {
        return ((NlComponent)parent).getChildren().indexOf(child);
    }

    @Override
    public void addTreeModelListener(@Nullable TreeModelListener listener2) {
    }

    @Override
    public void removeTreeModelListener(@Nullable TreeModelListener listener2) {
    }
}

