/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scout;

import com.android.tools.idea.uibuilder.scout.Connection;
import com.android.tools.idea.uibuilder.scout.Direction;
import com.android.tools.idea.uibuilder.scout.ScoutWidget;

public class ConstrainedWidget {
    private ScoutWidget myScoutWidget;
    public Connection north;
    public Connection south;
    public Connection east;
    public Connection west;
    public Connection baseline;
    private double myCost;
    private double errorCenterFactor = 8.0;

    public ConstrainedWidget(ScoutWidget sWidget) {
        this.myScoutWidget = sWidget;
    }

    public ConstrainedWidget(Connection north, Connection south, Connection east, Connection west, Connection baseline, ScoutWidget sWidget) {
        this.myScoutWidget = sWidget;
        this.north = north;
        this.north.setOriginWidget(this);
        this.south = south;
        this.south.setOriginWidget(this);
        this.east = east;
        this.east.setOriginWidget(this);
        this.west = west;
        this.west.setOriginWidget(this);
        this.baseline = baseline;
        this.baseline.setOriginWidget(this);
        this.myCost = north.getCost() + south.getCost() + east.getCost() + west.getCost() + baseline.getCost();
    }

    public String toString() {
        String res = this.myScoutWidget.isVerticalGuideline() ? "V GUIDELINE" : (this.myScoutWidget.isHorizontalGuideline() ? "H GUIDELINE" : String.format("%s %s %s %s %s %f", this.north.toString(), this.south.toString(), this.east.toString(), this.west.toString(), this.baseline.toString(), this.myCost));
        return res;
    }

    public double getCost() {
        return this.myCost;
    }

    int compareTo(ConstrainedWidget other) {
        int val = this.myCost < other.getCost() ? 1 : (this.myCost == other.getCost() ? 0 : -1);
        return val;
    }

    public ScoutWidget getScoutWidget() {
        return this.myScoutWidget;
    }

    public boolean isBackwardsConnection(Direction anchor) {
        if ((anchor == Direction.TOP || anchor == Direction.LEFT) && this.getConnection(anchor).getMargin() > 0 && this.getConnection(anchor).isConnected()) {
            return true;
        }
        return (anchor == Direction.BOTTOM || anchor == Direction.RIGHT) && this.getConnection(anchor).getMargin() < 0 && this.getConnection(anchor).isConnected();
    }

    public Connection getConnection(Direction dir) {
        switch (dir) {
            case TOP: {
                return this.north;
            }
            case LEFT: {
                return this.west;
            }
            case RIGHT: {
                return this.east;
            }
            case BOTTOM: {
                return this.south;
            }
            case BASELINE: {
                return this.baseline;
            }
        }
        return this.baseline;
    }

    public double calculateBias(int orientation) {
        double a = this.getConnection(Direction.getDirections(orientation)[0]).getAbsoluteMargin();
        double b = this.getConnection(Direction.getDirections(orientation)[1]).getAbsoluteMargin();
        double bias = a == 0.0 && b == 0.0 ? 0.5 : (a == 0.0 ? 0.0 : (b == 0.0 ? 1.0 : a / (a + b)));
        return bias;
    }

    public double getCenterError(int orientation) {
        double a = this.getConnection(Direction.getDirections(orientation)[0]).getAbsoluteMargin();
        double b = this.getConnection(Direction.getDirections(orientation)[1]).getAbsoluteMargin();
        double size = orientation == 1 ? (double)this.myScoutWidget.getWidth() : (double)this.myScoutWidget.getHeight();
        double error = Math.abs(0.5 - this.calculateBias(orientation));
        if (!this.getConnection(Direction.getDirections(orientation)[0]).isParentConnection() || !this.getConnection(Direction.getDirections(orientation)[1]).isParentConnection()) {
            error *= 2.0;
        }
        error *= error * (a + b + size) * this.errorCenterFactor;
        return error;
    }

    public int numberOfConnections() {
        int connections = 0;
        for (Direction dir : Direction.getAllDirections()) {
            if (!this.getConnection(dir).isConnected()) continue;
            ++connections;
        }
        return connections;
    }
}

