/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.editor.timeline.graph;

import com.android.tools.idea.uibuilder.handlers.motion.editor.timeline.graph.Interpolator;

public class LinearInterpolator
extends Interpolator {
    private static final String TAG = "LinearInterpolator";
    private double[] mT;
    private double[][] mY;

    public LinearInterpolator(double[] time2, double[][] y) {
        int N = time2.length;
        int dim = y[0].length;
        this.mT = time2;
        this.mY = y;
    }

    @Override
    public void getPos(double t, double[] v) {
        int n = this.mT.length;
        int dim = this.mY[0].length;
        if (t <= this.mT[0]) {
            for (int j = 0; j < dim; ++j) {
                v[j] = this.mY[0][j];
            }
            return;
        }
        if (t >= this.mT[n - 1]) {
            for (int j = 0; j < dim; ++j) {
                v[j] = this.mY[n - 1][j];
            }
            return;
        }
        for (int i2 = 0; i2 < n - 1; ++i2) {
            if (t == this.mT[i2]) {
                for (int j = 0; j < dim; ++j) {
                    v[j] = this.mY[i2][j];
                }
            }
            if (!(t < this.mT[i2 + 1])) continue;
            double h = this.mT[i2 + 1] - this.mT[i2];
            double x = (t - this.mT[i2]) / h;
            for (int j = 0; j < dim; ++j) {
                double y1 = this.mY[i2][j];
                double y2 = this.mY[i2 + 1][j];
                v[j] = y1 * (1.0 - x) + y2 * x;
            }
            return;
        }
    }

    @Override
    public void getPos(double t, float[] v) {
        int n = this.mT.length;
        int dim = this.mY[0].length;
        if (t <= this.mT[0]) {
            for (int j = 0; j < dim; ++j) {
                v[j] = (float)this.mY[0][j];
            }
            return;
        }
        if (t >= this.mT[n - 1]) {
            for (int j = 0; j < dim; ++j) {
                v[j] = (float)this.mY[n - 1][j];
            }
            return;
        }
        for (int i2 = 0; i2 < n - 1; ++i2) {
            if (t == this.mT[i2]) {
                for (int j = 0; j < dim; ++j) {
                    v[j] = (float)this.mY[i2][j];
                }
            }
            if (!(t < this.mT[i2 + 1])) continue;
            double h = this.mT[i2 + 1] - this.mT[i2];
            double x = (t - this.mT[i2]) / h;
            for (int j = 0; j < dim; ++j) {
                double y1 = this.mY[i2][j];
                double y2 = this.mY[i2 + 1][j];
                v[j] = (float)(y1 * (1.0 - x) + y2 * x);
            }
            return;
        }
    }

    @Override
    public double getPos(double t, int j) {
        int n = this.mT.length;
        if (t <= this.mT[0]) {
            return this.mY[0][j];
        }
        if (t >= this.mT[n - 1]) {
            return this.mY[n - 1][j];
        }
        for (int i2 = 0; i2 < n - 1; ++i2) {
            if (t == this.mT[i2]) {
                return this.mY[i2][j];
            }
            if (!(t < this.mT[i2 + 1])) continue;
            double h = this.mT[i2 + 1] - this.mT[i2];
            double x = (t - this.mT[i2]) / h;
            double y1 = this.mY[i2][j];
            double y2 = this.mY[i2 + 1][j];
            return y1 * (1.0 - x) + y2 * x;
        }
        return 0.0;
    }

    @Override
    public void getSlope(double t, double[] v) {
        int n = this.mT.length;
        int dim = this.mY[0].length;
        if (t <= this.mT[0]) {
            t = this.mT[0];
        } else if (t >= this.mT[n - 1]) {
            t = this.mT[n - 1];
        }
        for (int i2 = 0; i2 < n - 1; ++i2) {
            if (!(t <= this.mT[i2 + 1])) continue;
            double h = this.mT[i2 + 1] - this.mT[i2];
            double x = (t - this.mT[i2]) / h;
            for (int j = 0; j < dim; ++j) {
                double y1 = this.mY[i2][j];
                double y2 = this.mY[i2 + 1][j];
                v[j] = (y2 - y1) / h;
            }
            break;
        }
    }

    @Override
    public double getSlope(double t, int j) {
        int n = this.mT.length;
        if (t < this.mT[0]) {
            t = this.mT[0];
        } else if (t >= this.mT[n - 1]) {
            t = this.mT[n - 1];
        }
        for (int i2 = 0; i2 < n - 1; ++i2) {
            if (!(t <= this.mT[i2 + 1])) continue;
            double h = this.mT[i2 + 1] - this.mT[i2];
            double x = (t - this.mT[i2]) / h;
            double y1 = this.mY[i2][j];
            double y2 = this.mY[i2 + 1][j];
            return (y2 - y1) / h;
        }
        return 0.0;
    }

    @Override
    public double[] getTimePoints() {
        return this.mT;
    }
}

