/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.editor.timeline;

import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEUI;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.timeline.GraphRender;
import com.android.tools.idea.uibuilder.handlers.motion.editor.timeline.TimeLineRowData;
import com.android.tools.idea.uibuilder.handlers.motion.editor.timeline.TimelineStructure;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MeModel;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JPanel;

public class TimeLineRow
extends JPanel {
    private static final boolean DEBUG = false;
    TimeLineRowData mRow;
    int mRowNumber = 0;
    private boolean mSelected;
    private boolean mCellHasFocus;
    TimelineStructure mTimelineStructure;
    MTag mSelectedKeyFrame;
    private int myTitleHeight = MEUI.scale(20);
    private int myRowHeight = MEUI.scale(20);
    private int myGraphHeight = MEUI.scale(50);
    boolean mShowTitle = false;
    int[] mXPoint = new int[4];
    int[] mYPoint = new int[4];
    private boolean mHasGraph = true;
    private boolean mGraphOpen = false;
    GraphRender mGraph = new GraphRender();

    @Override
    public void updateUI() {
        super.updateUI();
        this.myTitleHeight = MEUI.scale(20);
        this.myRowHeight = MEUI.scale(20);
        this.myGraphHeight = MEUI.scale(50);
        if (this.mShowTitle) {
            this.setSize(MEUI.size(100, 40));
            this.setPreferredSize(MEUI.size(100, this.getNewHeight()));
        } else {
            this.setSize(MEUI.size(100, 20));
            this.setPreferredSize(MEUI.size(100, this.getNewHeight()));
        }
    }

    TimeLineRow(TimelineStructure timelineStructure) {
        this.setPreferredSize(MEUI.size(100, 20));
        this.mTimelineStructure = timelineStructure;
    }

    @Override
    public void paint(Graphics g) {
        int w = this.getWidth();
        int h = this.getHeight();
        int titley = MEUI.scale(20);
        if (this.mShowTitle) {
            g.setColor(MEUI.ourPrimaryPanelBackground);
            g.fillRect(0, 0, w, titley);
            if (this.mSelected) {
                g.setColor(MEUI.ourMySelectedLineColor);
                g.fillRect(0, titley, MEUI.ourLeftColumnWidth, this.myRowHeight);
                g.setColor(MEUI.ourSecondaryPanelBackground);
                g.fillRect(MEUI.ourLeftColumnWidth, titley, w - MEUI.ourLeftColumnWidth, this.myRowHeight);
                g.fillRect(0, titley + this.myRowHeight, w, h - (titley + this.myRowHeight));
            } else {
                g.setColor(MEUI.ourSecondaryPanelBackground);
                g.fillRect(0, titley, w, this.myRowHeight);
            }
        } else if (this.mSelected) {
            g.setColor(MEUI.ourMySelectedLineColor);
            g.fillRect(0, 0, MEUI.ourLeftColumnWidth, this.myRowHeight);
            g.setColor(MEUI.ourSecondaryPanelBackground);
            g.fillRect(MEUI.ourLeftColumnWidth, 0, w - MEUI.ourLeftColumnWidth, this.myRowHeight);
            g.fillRect(0, this.myRowHeight, w, h - this.myRowHeight);
        } else {
            g.setColor(MEUI.ourSecondaryPanelBackground);
            g.fillRect(0, 0, w, h);
        }
        g.setColor(MEUI.ourBorder);
        g.fillRect(MEUI.ourLeftColumnWidth, 0, 1, h);
        FontMetrics metrics = g.getFontMetrics();
        int refWidth = Math.max(metrics.stringWidth("Id:"), metrics.stringWidth("Tg:"));
        int sx = MEUI.scale(2);
        int fontAscent = metrics.getAscent();
        int sy = 0;
        if (this.mShowTitle) {
            g.setColor(MEUI.ourTextColor);
            g.setClip(0, 0, MEUI.ourLeftColumnWidth, this.getHeight());
            g.drawString(this.mRow.mRef + ":" + this.mRow.mName, sx, fontAscent);
            g.setClip(null);
            sy += this.myTitleHeight;
        }
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.mHasGraph) {
            this.drawArrow(g, sy);
        }
        sy += fontAscent;
        g.setColor(this.mSelected ? MEUI.ourMySelectedTextColor : MEUI.ourTextColor);
        sx = MEUI.scale(22);
        int rowTypeEnd = 0;
        if (this.mRow.mType != null) {
            g.setClip(0, 0, MEUI.ourLeftColumnWidth, this.getHeight());
            g.drawString(this.mRow.mType, sx, sy);
            g.setClip(null);
            rowTypeEnd = sx + metrics.stringWidth(this.mRow.mType);
        }
        if (this.mRow.mKeyProp != null) {
            sx = MEUI.ourLeftColumnWidth - metrics.stringWidth(this.mRow.mKeyProp) - 3;
            if (sx < rowTypeEnd) {
                g.setClip(0, 0, MEUI.ourLeftColumnWidth, this.getHeight());
                g.drawString(this.mRow.mKeyProp, rowTypeEnd, sy);
                g.setClip(null);
            } else {
                g.drawString(this.mRow.mKeyProp, sx, sy);
            }
        }
        sy -= metrics.getAscent();
        int rad = 4;
        int diameter = rad * 2;
        for (MTag keyFrame : this.mRow.mKeyFrames) {
            String posString = keyFrame.getAttributeValue("framePosition");
            if (posString == null) continue;
            int pos = Integer.parseInt(posString);
            if (keyFrame == this.mSelectedKeyFrame && this.mSelected) {
                g.setColor(MEUI.ourMySelectedKeyColor);
            } else {
                g.setColor(MEUI.ourTextColor);
            }
            int ypos = sy + this.myRowHeight / 2;
            int x = this.mTimelineStructure.floatToPosition(pos) + MEUI.ourLeftColumnWidth;
            this.drawDiamond(g, x, ypos);
            if (keyFrame != this.mSelectedKeyFrame || !this.mSelected) continue;
            g.setColor(MEUI.ourTextColor);
        }
        if (this.mHasGraph && this.mGraphOpen) {
            int gy = this.myRowHeight + (this.mShowTitle ? this.myTitleHeight : 0);
            this.mGraph.draw(g, this.mTimelineStructure, MEUI.ourLeftColumnWidth, gy, w - MEUI.ourLeftColumnWidth, this.myGraphHeight);
        }
        g.setColor(MEUI.myGridColor);
        TimeLineRow.drawTicks(g, this.mTimelineStructure, h);
    }

    public void drawArrow(Graphics g, int y) {
        int x = 2;
        int size = this.myRowHeight / 3;
        y += size;
        if (this.mGraphOpen) {
            this.mXPoint[0] = x;
            this.mXPoint[1] = x + size;
            this.mXPoint[2] = x + size / 2;
            this.mYPoint[0] = y;
            this.mYPoint[1] = y;
            this.mYPoint[2] = y + size;
        } else {
            this.mXPoint[0] = x;
            this.mXPoint[1] = x;
            this.mXPoint[2] = x + size;
            this.mYPoint[0] = y;
            this.mYPoint[1] = y + size;
            this.mYPoint[2] = y + size / 2;
        }
        g.fillPolygon(this.mXPoint, this.mYPoint, 3);
    }

    public static void drawTicks(Graphics g, TimelineStructure mTimelineStructure, int h) {
        for (int i2 = 0; i2 < mTimelineStructure.myXTicksPixels.length; ++i2) {
            int x = mTimelineStructure.myXTicksPixels[i2] + MEUI.ourLeftColumnWidth;
            g.fillRect(x, 0, 1, h);
        }
    }

    private void drawDiamond(Graphics g, int x, int y) {
        int size = 4;
        this.mXPoint[0] = x;
        this.mXPoint[1] = x + size;
        this.mXPoint[2] = x;
        this.mXPoint[3] = x - size;
        this.mYPoint[0] = y - size;
        this.mYPoint[1] = y;
        this.mYPoint[2] = y + size;
        this.mYPoint[3] = y;
        g.fillPolygon(this.mXPoint, this.mYPoint, 4);
    }

    void setRowData(MeModel model2, TimeLineRowData row, int row_number, boolean selection, boolean cellHasFocus, MTag selectedKeyFrame, boolean showTitle) {
        this.mRow = row;
        this.mRowNumber = row_number;
        this.mSelected = selection;
        this.mCellHasFocus = cellHasFocus;
        this.mSelectedKeyFrame = selectedKeyFrame;
        this.mShowTitle = showTitle;
        this.mHasGraph = this.mGraph.setUp(model2, row);
        this.updateUI();
    }

    private int getNewHeight() {
        int ret2 = this.myRowHeight;
        if (this.mShowTitle) {
            ret2 += this.myTitleHeight;
        }
        if (this.mGraphOpen & this.mHasGraph) {
            ret2 += this.myGraphHeight;
        }
        return ret2;
    }

    public void setSelectedKeyFrame(MTag selectedKeyFrame) {
        this.mSelectedKeyFrame = selectedKeyFrame;
        this.repaint();
    }

    public void setSelected(boolean b) {
        this.mSelected = b;
    }

    public void toggleGraph() {
        if (!this.mHasGraph) {
            return;
        }
        this.mGraphOpen = !this.mGraphOpen;
        this.setPreferredSize(MEUI.size(100, this.getNewHeight()));
        this.revalidate();
    }
}

