/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.editor.createDialogs;

import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEComboBox;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEIcons;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEUI;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MotionEditor;
import com.android.tools.idea.uibuilder.handlers.motion.editor.utils.Debug;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.Popup;
import javax.swing.SwingUtilities;

public class BaseCreatePanel
extends JPanel {
    public static final boolean DEBUG = false;
    protected Popup myPopup;
    MEUI.Popup myDialog;
    Icon icon = MEIcons.CREATE_TRANSITION;
    protected MotionEditor mMotionEditor;
    protected boolean inSubPopup = false;
    private Component mSourceComponent;

    @Override
    public void updateUI() {
        super.updateUI();
        int n = this.getComponentCount();
        for (int i2 = 0; i2 < n; ++i2) {
            Component c = this.getComponent(i2);
            if (!(c instanceof JComponent)) continue;
            ((JComponent)c).updateUI();
        }
    }

    public JButton createButton() {
        JButton button2 = new JButton(this.icon);
        button2.setContentAreaFilled(false);
        button2.setToolTipText("create " + this.getName());
        button2.addActionListener(e -> this.showPopup(button2, 0, 0));
        button2.setBorder(null);
        return button2;
    }

    BaseCreatePanel() {
        super(new GridBagLayout());
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        KeyStroke escapeKeyStroke = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseCreatePanel.this.dismissPopup();
            }
        };
        this.getInputMap(2).put(escapeKeyStroke, "ESCAPE");
        this.getActionMap().put("ESCAPE", escapeAction2);
    }

    protected static void grid(GridBagConstraints gbc, int x, int y) {
        gbc.gridy = y;
        gbc.gridx = x;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
    }

    protected static void grid(GridBagConstraints gbc, int x, int y, int w, int h) {
        gbc.gridy = y;
        gbc.gridx = x;
        gbc.gridwidth = w;
        gbc.gridheight = h;
    }

    protected JTextField newTextField(String xxx) {
        JTextField ret2 = new JTextField();
        ret2.setText(xxx);
        ret2.setPreferredSize(ret2.getPreferredSize());
        ret2.setText("");
        return ret2;
    }

    protected JComboBox<String> newComboBox(String ... choices) {
        MEComboBox<String> ret2 = MEUI.makeComboBox(choices);
        return ret2;
    }

    protected PromptedTextField newTextField(String prompt, int spaces) {
        return new PromptedTextField(prompt, spaces);
    }

    protected void showErrorDialog(String str) {
        this.inSubPopup = true;
        JOptionPane optionPane = new JOptionPane(str, 0);
        JDialog dialog2 = optionPane.createDialog(this, "Invalid");
        dialog2.setContentPane(optionPane);
        dialog2.setTitle("Invalid");
        dialog2.setAlwaysOnTop(true);
        dialog2.setModal(true);
        dialog2.setResizable(false);
        dialog2.setLocationRelativeTo(this);
        this.myDialog.hide();
        dialog2.setVisible(true);
        dialog2.dispose();
        this.inSubPopup = false;
        this.myDialog.show();
    }

    protected void showPreconditionDialog(String str) {
        this.inSubPopup = true;
        JOptionPane optionPane = new JOptionPane(str, 0);
        JDialog dialog2 = optionPane.createDialog(this.mSourceComponent, "Invalid");
        dialog2.setContentPane(optionPane);
        dialog2.setTitle("Invalid");
        dialog2.setAlwaysOnTop(true);
        dialog2.setModal(true);
        dialog2.setResizable(false);
        dialog2.setLocationRelativeTo(this.mSourceComponent);
        dialog2.setVisible(true);
        dialog2.dispose();
        this.inSubPopup = false;
    }

    public MTag create() {
        this.dismissPopup();
        return null;
    }

    public void dismissPopup() {
        if (this.myDialog == null) {
            return;
        }
        this.myDialog.dismiss();
        this.myDialog = null;
    }

    public void showPopup(JComponent source, int offx, int offy) {
        this.updateUI();
        this.myDialog = MEUI.createPopup(this, source);
    }

    public void showPopup2(Component source, int offx, int offy) {
        final JDialog dialog2 = new JDialog(SwingUtilities.getWindowAncestor(source), "Click a button");
        dialog2.setUndecorated(true);
        Point scr = source.getLocationOnScreen();
        dialog2.setBounds(scr.x, scr.y, 0, 0);
        Container comp = this.getParent();
        if (comp != null) {
            comp.remove(this);
        }
        dialog2.setContentPane(this);
        dialog2.setAlwaysOnTop(true);
        dialog2.pack();
        dialog2.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
                if (BaseCreatePanel.this.inSubPopup) {
                    return;
                }
                dialog2.setVisible(false);
            }
        });
        dialog2.setVisible(true);
        dialog2.requestFocus();
    }

    protected boolean populateDialog() {
        return true;
    }

    public Action getAction(final JComponent component, final MotionEditor motionEditor) {
        this.mMotionEditor = motionEditor;
        AbstractAction aa = new AbstractAction(this.getName(), this.icon){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseCreatePanel.this.mSourceComponent = component;
                boolean ok = BaseCreatePanel.this.populateDialog();
                if (ok) {
                    MEUI.invokeLater(() -> {
                        Debug.log("popup ....");
                        BaseCreatePanel.this.showPopup(component, 0, 0);
                        motionEditor.dataChanged();
                    });
                }
            }
        };
        aa.putValue("ShortDescription", component.getToolTipText());
        return aa;
    }

    String addIdPrefix(String str) {
        if (str == null) {
            return null;
        }
        if (str.startsWith("@+id/") || str.startsWith("@id/")) {
            return str;
        }
        return "@+id/" + str;
    }

    public static class PromptedTextField
    extends JTextField {
        String mPromptText;

        public void setPromptText(String prompt) {
            String s = this.getText();
            this.mPromptText = prompt;
            this.setText(prompt);
        }

        PromptedTextField(String prompt, int spaces) {
            this.mPromptText = prompt;
            char[] xxx = new char[spaces];
            Arrays.fill(xxx, 'X');
            this.setText(new String(xxx));
            this.setPreferredSize(this.getPreferredSize());
            this.setText(prompt);
            final Color normalColor = this.getForeground();
            this.setForeground(Color.GRAY);
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    String s = this.getText();
                    if (s.equals(mPromptText)) {
                        this.setText("");
                        this.setForeground(normalColor);
                    }
                }

                @Override
                public void focusLost(FocusEvent e) {
                    String s = this.getText();
                    if (s.trim().equals("")) {
                        this.setText(mPromptText);
                        this.setForeground(Color.GRAY);
                    }
                }
            });
        }

        public String getPromptText() {
            return this.mPromptText;
        }
    }
}

