/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint;

import com.android.tools.idea.common.command.NlWriteCommandActionUtil;
import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlComponentModificationDelegate;
import com.android.utils.Pair;
import com.intellij.psi.xml.XmlTag;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComponentModification
implements NlAttributesHolder {
    private final NlComponent myComponent;
    private final NlComponentModificationDelegate myDelegate;
    private final String myLabel;
    HashMap<Pair<String, String>, String> myAttributes = new HashMap();

    public ComponentModification(@NotNull NlComponent component, @NotNull String label) {
        this.myComponent = component;
        this.myLabel = label;
        this.myDelegate = this.myComponent.getComponentModificationDelegate();
        if (this.myDelegate != null) {
            this.myDelegate.initializeModification(this);
        } else {
            component.startAttributeTransaction();
        }
    }

    @NotNull
    public String getLabel() {
        return this.myLabel;
    }

    @NotNull
    public NlComponent getComponent() {
        return this.myComponent;
    }

    @Override
    public void setAttribute(@Nullable String namespace, @NotNull String name, @Nullable String value2) {
        if (this.myDelegate != null) {
            this.myDelegate.setAttribute(this.myAttributes, namespace, name, value2);
        } else {
            AttributesTransaction transaction = this.myComponent.startAttributeTransaction();
            transaction.setAttribute(namespace, name, value2);
        }
    }

    @Override
    public String getAttribute(@Nullable String namespace, @NotNull String attribute) {
        if (this.myDelegate != null) {
            return this.myDelegate.getAttribute(this.myAttributes, namespace, attribute);
        }
        AttributesTransaction transaction = this.myComponent.startAttributeTransaction();
        return transaction.getAttribute(namespace, attribute);
    }

    public HashMap<Pair<String, String>, String> getAttributes() {
        return this.myAttributes;
    }

    @Override
    public void removeAttribute(@NotNull String namespace, @NotNull String name) {
        this.myAttributes.remove(Pair.of((Object)namespace, (Object)name));
    }

    public void apply() {
        if (this.myDelegate != null) {
            this.myDelegate.applyModification(this);
            return;
        }
        this.directApply();
    }

    public void directApply() {
        AttributesTransaction transaction = this.myComponent.startAttributeTransaction();
        transaction.apply();
    }

    public void commit() {
        if (this.myDelegate != null) {
            this.myDelegate.commitModification(this);
            return;
        }
        this.directCommit();
    }

    public void directCommit() {
        AttributesTransaction transaction = this.myComponent.startAttributeTransaction();
        transaction.apply();
        NlWriteCommandActionUtil.run(this.myComponent, this.myLabel, transaction::commit);
    }

    public void commitTo(XmlTag view) {
        for (Pair<String, String> key : this.myAttributes.keySet()) {
            String value2 = this.myAttributes.get(key);
            String namespace = (String)key.getFirst();
            if (namespace.equalsIgnoreCase("http://schemas.android.com/tools")) {
                namespace = "http://schemas.android.com/apk/res-auto";
            }
            view.setAttribute((String)key.getSecond(), namespace, value2);
        }
    }
}

