/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers;

import android.view.View;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.handlers.frame.FrameLayoutHandler;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.model.Ranges;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class NavigationViewHandler
extends FrameLayoutHandler {
    NavigationViewHandler() {
    }

    @Override
    public void onActivateInDesignSurface(@NotNull NlComponent component, ViewEditor editor2, int x, int y) {
        String resource;
        ViewInfo viewInfo = NlComponentHelperKt.getViewInfo(component);
        if (viewInfo == null) {
            return;
        }
        View view = NavigationViewHandler.getHeaderView(viewInfo.getViewObject(), 0);
        if (view != null && NavigationViewHandler.contains(view, x, y)) {
            resource = component.getAttribute("http://schemas.android.com/apk/res-auto", "headerLayout");
        } else if (NlComponentHelperKt.contains(component, x, y)) {
            resource = component.getAttribute("http://schemas.android.com/apk/res-auto", "menu");
        } else {
            return;
        }
        if (resource == null) {
            return;
        }
        editor2.openResourceFile(resource);
    }

    private static boolean contains(@NotNull View view, int x, int y) {
        int viewX = view.getLeft();
        int viewY = view.getTop();
        return Ranges.contains(viewX, viewX + view.getWidth(), x) && Ranges.contains(viewY, viewY + view.getHeight(), y);
    }

    @Nullable
    private static View getHeaderView(@NotNull Object navigationView, int index2) {
        try {
            return (View)navigationView.getClass().getDeclaredMethod("getHeaderView", Integer.TYPE).invoke(navigationView, index2);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException exception) {
            return null;
        }
    }

    @Override
    @NotNull
    public List<String> getInspectorProperties() {
        return ImmutableList.of((Object)"headerLayout", (Object)"menu", (Object)"itemBackground", (Object)"itemIconTint", (Object)"itemTextAppearance", (Object)"itemTextColor", (Object)"fitsSystemWindows");
    }
}

