/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.api.XmlType;
import com.android.tools.idea.uibuilder.handlers.DelegatingViewHandler;
import com.android.xml.XmlBuilder;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import javax.swing.Icon;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomViewHandler
extends DelegatingViewHandler {
    private final Icon myIcon16;
    private final String myTagName;
    private final String myClassName;
    @Language(value="XML")
    private final String myXml;
    @Language(value="XML")
    private final String myPreviewXml;
    private final String myLibraryCoordinate;
    private final String myPreferredProperty;
    private final List<String> myProperties;

    public CustomViewHandler(@NotNull ViewHandler handler2, @Nullable Icon icon16, @NotNull String tagName, @NotNull String className2, @Nullable @Language(value="XML") String xml, @Nullable @Language(value="XML") String previewXml, @NotNull String libraryCoordinate, @Nullable String preferredProperty, @NotNull List<String> properties2) {
        super(handler2);
        this.myIcon16 = icon16;
        this.myTagName = tagName;
        this.myClassName = className2;
        this.myXml = xml;
        this.myPreviewXml = previewXml;
        this.myLibraryCoordinate = libraryCoordinate;
        this.myPreferredProperty = preferredProperty;
        this.myProperties = properties2;
    }

    @NotNull
    public String getTagName() {
        return this.myTagName;
    }

    @Override
    @NotNull
    public Icon getIcon(@NotNull String tagName) {
        return this.myIcon16 != null && tagName.equals(this.myTagName) ? this.myIcon16 : super.getIcon(tagName);
    }

    @Override
    @NotNull
    public String getGradleCoordinateId(@NotNull String tagName) {
        return tagName.equals(this.myTagName) ? this.myLibraryCoordinate : super.getGradleCoordinateId(tagName);
    }

    @Override
    @NotNull
    @Language(value="XML")
    public String getXml(@NotNull String tagName, @NotNull XmlType xmlType) {
        if (xmlType != XmlType.COMPONENT_CREATION) {
            return tagName.equals(this.myTagName) && !StringUtil.isEmpty((String)this.myPreviewXml) ? this.myPreviewXml : "";
        }
        if (tagName.equals(this.myTagName) && !StringUtil.isEmpty((String)this.myXml)) {
            return this.myXml;
        }
        if (this.myClassName.equals(this.myTagName)) {
            return super.getXml(tagName, xmlType);
        }
        return new XmlBuilder().startTag("view").attribute("class", this.myClassName).androidAttribute("layout_width", "wrap_content").androidAttribute("layout_height", "wrap_content").endTag("view").toString();
    }

    @Override
    @NotNull
    public Icon getIcon(@NotNull NlComponent component) {
        return component.getTagName().equals(this.myTagName) && this.myIcon16 != null ? this.myIcon16 : super.getIcon(component);
    }

    @Override
    @NotNull
    public List<String> getInspectorProperties() {
        return this.myProperties;
    }

    @Override
    @Nullable
    public String getPreferredProperty() {
        return this.myPreferredProperty;
    }
}

