/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.error;

import com.android.tools.idea.common.error.Issue;
import com.android.tools.idea.common.error.IssueProvider;
import com.android.tools.idea.common.error.IssueSource;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.rendering.errors.ui.RenderErrorModel;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableCollection;
import com.intellij.lang.annotation.HighlightSeverity;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenderIssueProvider
extends IssueProvider {
    @NotNull
    private final RenderErrorModel myRenderErrorModel;
    @Nullable
    private final NlModel mySourceNlModel;

    public RenderIssueProvider(@Nullable NlModel sourceNlModel, @NotNull RenderErrorModel renderErrorModel) {
        this.myRenderErrorModel = renderErrorModel;
        this.mySourceNlModel = sourceNlModel;
    }

    @Override
    public void collectIssues(@NotNull ImmutableCollection.Builder<Issue> issueListBuilder) {
        this.myRenderErrorModel.getIssues().forEach(issue2 -> issueListBuilder.add((Object)NlRenderIssueWrapper.wrapIssue(issue2, this.mySourceNlModel)));
    }

    @VisibleForTesting
    public static class NlRenderIssueWrapper
    extends Issue {
        private final RenderErrorModel.Issue myIssue;
        private final IssueSource mySource;

        private NlRenderIssueWrapper(@NotNull RenderErrorModel.Issue issue2, @Nullable NlModel sourceModel) {
            this.myIssue = issue2;
            this.mySource = sourceModel == null ? IssueSource.NONE : IssueSource.fromNlModel(sourceModel);
        }

        @NotNull
        public static Issue wrapIssue(@NotNull RenderErrorModel.Issue renderIssue, @Nullable NlModel sourceModel) {
            return new NlRenderIssueWrapper(renderIssue, sourceModel);
        }

        @Override
        @NotNull
        public String getSummary() {
            return this.myIssue.getSummary();
        }

        @Override
        @NotNull
        public String getDescription() {
            return this.myIssue.getHtmlContent();
        }

        @Override
        @NotNull
        public HighlightSeverity getSeverity() {
            return this.myIssue.getSeverity();
        }

        @Override
        @NotNull
        public IssueSource getSource() {
            return this.mySource;
        }

        @Override
        @NotNull
        public String getCategory() {
            return "Rendering Issue";
        }

        @Override
        @Nullable
        public HyperlinkListener getHyperlinkListener() {
            return this.myIssue.getHyperlinkListener();
        }
    }
}

