/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.analytics;

import com.android.tools.idea.common.analytics.CommonUsageTracker;
import com.android.tools.idea.common.analytics.CommonUsageTrackerImpl;
import com.android.tools.idea.common.analytics.CommonUsageTrackerKt;
import com.android.tools.idea.common.analytics.UsageTrackerUtil;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.stats.AnonymizerUtil;
import com.android.tools.idea.uibuilder.analytics.NlUsageTracker;
import com.android.tools.idea.uibuilder.property2.NelePropertyItem;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.wireless.android.sdk.stats.AndroidAttribute;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.LayoutAttributeChangeEvent;
import com.google.wireless.android.sdk.stats.LayoutEditorEvent;
import com.google.wireless.android.sdk.stats.LayoutFavoriteAttributeChangeEvent;
import com.google.wireless.android.sdk.stats.LayoutPaletteEvent;
import com.google.wireless.android.sdk.stats.SearchOption;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlUsageTrackerImpl
implements NlUsageTracker {
    private static final Pattern STYLE_PATTERN = Pattern.compile("style=\"(.*)\"");
    private static final Pattern INPUT_STYLE_PATTERN = Pattern.compile("android:inputType=\"(.*)\"");
    private static final Pattern ORIENTATION_PATTERN = Pattern.compile("android:orientation=\"(.*)\"");
    private static final Map<String, LayoutPaletteEvent.ViewOption> PALETTE_VIEW_OPTION_MAP = ImmutableMap.builder().put((Object)"textPassword", (Object)LayoutPaletteEvent.ViewOption.PASSWORD).put((Object)"numberPassword", (Object)LayoutPaletteEvent.ViewOption.PASSWORD_NUMERIC).put((Object)"textEmailAddress", (Object)LayoutPaletteEvent.ViewOption.EMAIL).put((Object)"phone", (Object)LayoutPaletteEvent.ViewOption.PHONE).put((Object)"textPostalAddress", (Object)LayoutPaletteEvent.ViewOption.POSTAL_ADDRESS).put((Object)"textMultiLine", (Object)LayoutPaletteEvent.ViewOption.MULTILINE_TEXT).put((Object)"time", (Object)LayoutPaletteEvent.ViewOption.TIME_EDITOR).put((Object)"date", (Object)LayoutPaletteEvent.ViewOption.DATE_EDITOR).put((Object)"number", (Object)LayoutPaletteEvent.ViewOption.NUMBER).put((Object)"numberSigned", (Object)LayoutPaletteEvent.ViewOption.SIGNED_NUMBER).put((Object)"numberDecimal", (Object)LayoutPaletteEvent.ViewOption.DECIMAL_NUMBER).build();
    @NotNull
    private final CommonUsageTracker myCommonTracker;

    NlUsageTrackerImpl(@NotNull Executor executor, @Nullable DesignSurface surface2, @NotNull Consumer<AndroidStudioEvent.Builder> eventLogger) {
        if (surface2 == null || surface2.getModel() == null) {
            this.myCommonTracker = new CommonUsageTrackerImpl(executor, surface2, eventLogger);
        } else {
            String applicationId2 = CommonUsageTrackerKt.getApplicationId(surface2.getModel().getFacet());
            Consumer<AndroidStudioEvent.Builder> builder2 = delegatingBuilder -> {
                if (applicationId2 != null) {
                    delegatingBuilder.setRawProjectId(applicationId2).setProjectId(AnonymizerUtil.anonymizeUtf8((String)applicationId2));
                }
                eventLogger.accept((AndroidStudioEvent.Builder)delegatingBuilder);
            };
            this.myCommonTracker = new CommonUsageTrackerImpl(executor, surface2, builder2);
        }
    }

    @Override
    public void logDropFromPalette(@NotNull String viewTagName, @NotNull String representation, @NotNull String selectedGroup, int filterMatches) {
        LayoutPaletteEvent.Builder builder2 = LayoutPaletteEvent.newBuilder().setView(UsageTrackerUtil.convertTagName(viewTagName)).setViewOption(NlUsageTrackerImpl.convertViewOption(viewTagName, representation)).setSelectedGroup(NlUsageTrackerImpl.convertGroupName(selectedGroup)).setSearchOption(NlUsageTrackerImpl.convertFilterMatches(filterMatches));
        this.myCommonTracker.logStudioEvent(LayoutEditorEvent.LayoutEditorEventType.DROP_VIEW_FROM_PALETTE, event -> event.setPaletteEvent(builder2));
    }

    @Override
    public void logPropertyChange(@NotNull NelePropertyItem property2, int filterMatches) {
        LayoutAttributeChangeEvent.Builder builder2 = LayoutAttributeChangeEvent.newBuilder().setAttribute(NlUsageTrackerImpl.convertAttribute(property2)).setSearchOption(NlUsageTrackerImpl.convertFilterMatches(filterMatches));
        for (NlComponent component : property2.getComponents()) {
            builder2.addView(UsageTrackerUtil.convertTagName(component.getTagName()));
        }
        this.myCommonTracker.logStudioEvent(LayoutEditorEvent.LayoutEditorEventType.ATTRIBUTE_CHANGE, event -> event.setAttributeChangeEvent(builder2));
    }

    @NotNull
    private static AndroidAttribute convertAttribute(@NotNull NelePropertyItem property2) {
        AndroidFacet facet2 = property2.getModel().getFacet();
        AndroidAttribute.AttributeNamespace namespace = UsageTrackerUtil.convertNamespace(property2.getNamespace());
        return AndroidAttribute.newBuilder().setAttributeName(UsageTrackerUtil.convertAttributeName(property2.getName(), namespace, property2.getLibraryName(), facet2)).setAttributeNamespace(namespace).build();
    }

    @Override
    public void logFavoritesChange(@NotNull String addedPropertyName, @NotNull String removedPropertyName, @NotNull List<String> currentFavorites, @NotNull AndroidFacet facet2) {
        LayoutFavoriteAttributeChangeEvent.Builder builder2 = LayoutFavoriteAttributeChangeEvent.newBuilder();
        if (!addedPropertyName.isEmpty()) {
            builder2.setAdded(UsageTrackerUtil.convertAttribute(addedPropertyName, facet2));
        }
        if (!removedPropertyName.isEmpty()) {
            builder2.setRemoved(UsageTrackerUtil.convertAttribute(removedPropertyName, facet2));
        }
        for (String propertyName : currentFavorites) {
            builder2.addActive(UsageTrackerUtil.convertAttribute(propertyName, facet2));
        }
        this.myCommonTracker.logStudioEvent(LayoutEditorEvent.LayoutEditorEventType.FAVORITE_CHANGE, event -> event.setFavoriteChangeEvent(builder2));
    }

    @NotNull
    static LayoutPaletteEvent.ViewGroup convertGroupName(@NotNull String groupName) {
        switch (groupName) {
            case "All": {
                return LayoutPaletteEvent.ViewGroup.ALL_GROUPS;
            }
            case "All Results": {
                return LayoutPaletteEvent.ViewGroup.ALL_RESULTS;
            }
            case "Common": {
                return LayoutPaletteEvent.ViewGroup.COMMON;
            }
            case "Buttons": {
                return LayoutPaletteEvent.ViewGroup.BUTTONS;
            }
            case "Widgets": {
                return LayoutPaletteEvent.ViewGroup.WIDGETS;
            }
            case "Text": {
                return LayoutPaletteEvent.ViewGroup.TEXT;
            }
            case "Layouts": {
                return LayoutPaletteEvent.ViewGroup.LAYOUTS;
            }
            case "Containers": {
                return LayoutPaletteEvent.ViewGroup.CONTAINERS;
            }
            case "Images": {
                return LayoutPaletteEvent.ViewGroup.IMAGES;
            }
            case "Date": {
                return LayoutPaletteEvent.ViewGroup.DATES;
            }
            case "Transitions": {
                return LayoutPaletteEvent.ViewGroup.TRANSITIONS;
            }
            case "Advanced": {
                return LayoutPaletteEvent.ViewGroup.ADVANCED;
            }
            case "Google": {
                return LayoutPaletteEvent.ViewGroup.GOOGLE;
            }
            case "Design": {
                return LayoutPaletteEvent.ViewGroup.DESIGN;
            }
            case "AppCompat": {
                return LayoutPaletteEvent.ViewGroup.APP_COMPAT;
            }
            case "Legacy": {
                return LayoutPaletteEvent.ViewGroup.LEGACY;
            }
            case "Helpers": {
                return LayoutPaletteEvent.ViewGroup.HELPERS;
            }
        }
        return LayoutPaletteEvent.ViewGroup.CUSTOM;
    }

    @NotNull
    static LayoutPaletteEvent.ViewOption convertViewOption(@NotNull String tagName, @NotNull String representation) {
        switch (tagName) {
            case "ProgressBar": {
                return NlUsageTrackerImpl.convertProgressBarViewOption(representation);
            }
            case "SeekBar": {
                return NlUsageTrackerImpl.convertSeekBarViewOption(representation);
            }
            case "EditText": {
                return NlUsageTrackerImpl.convertEditTextViewOption(representation);
            }
            case "LinearLayout": {
                return NlUsageTrackerImpl.convertLinearLayoutViewOption(representation);
            }
        }
        return LayoutPaletteEvent.ViewOption.NORMAL;
    }

    @NotNull
    static SearchOption convertFilterMatches(int matches) {
        if (matches < 1) {
            return SearchOption.NONE;
        }
        if (matches > 1) {
            return SearchOption.MULTIPLE_MATCHES;
        }
        return SearchOption.SINGLE_MATCH;
    }

    @Nullable
    @VisibleForTesting
    static String getStyleValue(@NotNull String representation) {
        Matcher matcher = STYLE_PATTERN.matcher(representation);
        return matcher.find() ? matcher.group(1) : null;
    }

    @NotNull
    @VisibleForTesting
    static LayoutPaletteEvent.ViewOption convertProgressBarViewOption(@NotNull String representation) {
        String styleValue = NlUsageTrackerImpl.getStyleValue(representation);
        if (styleValue == null || styleValue.equals("?android:attr/progressBarStyle")) {
            return LayoutPaletteEvent.ViewOption.NORMAL;
        }
        if (styleValue.equals("?android:attr/progressBarStyleHorizontal")) {
            return LayoutPaletteEvent.ViewOption.HORIZONTAL_PROGRESS_BAR;
        }
        return LayoutPaletteEvent.ViewOption.CUSTOM_OPTION;
    }

    @NotNull
    @VisibleForTesting
    static LayoutPaletteEvent.ViewOption convertSeekBarViewOption(@NotNull String representation) {
        String styleValue = NlUsageTrackerImpl.getStyleValue(representation);
        if (styleValue == null) {
            return LayoutPaletteEvent.ViewOption.NORMAL;
        }
        if (styleValue.equals("@style/Widget.AppCompat.SeekBar.Discrete")) {
            return LayoutPaletteEvent.ViewOption.DISCRETE_SEEK_BAR;
        }
        return LayoutPaletteEvent.ViewOption.CUSTOM_OPTION;
    }

    @NotNull
    @VisibleForTesting
    static LayoutPaletteEvent.ViewOption convertEditTextViewOption(@NotNull String representation) {
        Matcher matcher = INPUT_STYLE_PATTERN.matcher(representation);
        if (!matcher.find()) {
            return LayoutPaletteEvent.ViewOption.NORMAL;
        }
        LayoutPaletteEvent.ViewOption viewOption = PALETTE_VIEW_OPTION_MAP.get(matcher.group(1));
        return viewOption != null ? viewOption : LayoutPaletteEvent.ViewOption.CUSTOM_OPTION;
    }

    @NotNull
    @VisibleForTesting
    static LayoutPaletteEvent.ViewOption convertLinearLayoutViewOption(@NotNull String representation) {
        Matcher matcher = ORIENTATION_PATTERN.matcher(representation);
        if (!matcher.find()) {
            return LayoutPaletteEvent.ViewOption.HORIZONTAL_LINEAR_LAYOUT;
        }
        String orientation = matcher.group(1);
        if (orientation.equals("horizontal")) {
            return LayoutPaletteEvent.ViewOption.HORIZONTAL_LINEAR_LAYOUT;
        }
        if (orientation.equals("vertical")) {
            return LayoutPaletteEvent.ViewOption.VERTICAL_LINEAR_LAYOUT;
        }
        return LayoutPaletteEvent.ViewOption.CUSTOM_OPTION;
    }
}

